/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.chunkgenerator;

import cn.leolezury.eternalstarlight.common.world.gen.biomesource.ESBiomeSource;
import cn.leolezury.eternalstarlight.common.world.gen.biomesource.IESBiomeSource;
import cn.leolezury.eternalstarlight.common.world.gen.chunkgenerator.IRandomState;
import cn.leolezury.eternalstarlight.common.world.gen.chunkgenerator.StarlightSurfaceSystem;
import cn.leolezury.eternalstarlight.common.world.gen.structure.placement.LandmarkStructurePlacement;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3541;
import net.minecraft.class_3754;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5539;
import net.minecraft.class_5817;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6724;
import net.minecraft.class_6748;
import net.minecraft.class_6780;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6910;
import net.minecraft.class_7059;
import net.minecraft.class_7138;
import net.minecraft.class_7225;
import net.minecraft.class_7869;
import org.jetbrains.annotations.Nullable;

public class ESChunkGenerator
extends class_3754 {
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private static final class_2680 LAVA = class_2246.field_10164.method_9564();
    private final class_2680 defaultBlock;
    private final int seaLevel;
    public long seed = 0L;
    private class_3541 noise = new class_3541((class_5819)new class_2919((class_5819)new class_5820(this.seed)));
    public static final MapCodec<ESChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(o -> o.field_12761), (App)class_5284.field_24781.fieldOf("settings").forGetter(class_3754::method_41541)).apply((Applicative)instance, instance.stable(ESChunkGenerator::new)));

    public void setSeed(long newSeed) {
        if (this.seed != newSeed) {
            this.noise = new class_3541((class_5819)new class_2919((class_5819)new class_5820(newSeed)));
            this.seed = newSeed;
        }
    }

    public ESChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings) {
        super(biomeSource, settings);
        if (settings.method_40227()) {
            this.defaultBlock = ((class_5284)settings.comp_349()).comp_475();
            this.seaLevel = ((class_5284)settings.comp_349()).comp_479();
        } else {
            this.defaultBlock = class_2246.field_10340.method_9564();
            this.seaLevel = 50;
        }
    }

    public class_7869 method_46696(class_7225<class_7059> holderLookup, class_7138 randomState, long seed) {
        this.setSeed(seed);
        class_1966 class_19662 = this.field_12761;
        if (class_19662 instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)class_19662;
            source.setSeed(seed);
        }
        return super.method_46696(holderLookup, randomState, seed);
    }

    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    protected class_2791 method_33754(class_6748 blender, class_5138 structureManager, class_7138 randomState, class_2791 chunkAccess, int i, int j) {
        ESBiomeSource.Cached cached;
        class_1923 chunkPos = chunkAccess.method_12004();
        class_5817 beardifier = class_5817.method_42695((class_5138)structureManager, (class_1923)chunkPos);
        class_2902 oceanFloorMap = chunkAccess.method_12032(class_2902.class_2903.field_13195);
        class_2902 worldSurfaceMap = chunkAccess.method_12032(class_2902.class_2903.field_13194);
        int minBlockX = chunkPos.method_8326();
        int minBlockZ = chunkPos.method_8328();
        int minY = this.method_33730();
        int minYSec = Math.floorDiv(minY, 16);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int cellWidth = 16;
        int cellHeight = 16;
        int numSec = chunkAccess.method_12006().length;
        class_1966 class_19662 = this.field_12761;
        if (class_19662 instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)class_19662;
            cached = source.cache();
        } else {
            cached = null;
        }
        ESBiomeSource.Cached cachedBiomeSource = cached;
        for (int secY = numSec - 1; secY >= 0; --secY) {
            class_2826 levelChunkSection = chunkAccess.method_38259(secY);
            for (int relativeY = cellHeight - 1; relativeY >= 0; --relativeY) {
                int worldY = (minYSec + secY) * cellHeight + relativeY;
                int blockYInCell = worldY & 0xF;
                for (int cellBlockX = 0; cellBlockX < cellWidth; ++cellBlockX) {
                    int worldX = minBlockX + cellBlockX;
                    int blockXInCell = worldX & 0xF;
                    for (int cellBlockZ = 0; cellBlockZ < cellWidth; ++cellBlockZ) {
                        double beard;
                        int worldZ = minBlockZ + cellBlockZ;
                        int blockZInCell = worldZ & 0xF;
                        int surfaceHeight = this.getSurfaceHeight(cachedBiomeSource, worldX, worldZ);
                        class_2680 blockState = this.getStateAt(worldY, surfaceHeight, this.getBiomeDataAt(cachedBiomeSource, worldX, worldZ));
                        double noiseVal = this.noise.method_22416((double)worldX / 50.0, (double)worldY / 30.0, (double)worldZ / 50.0);
                        if (worldY < surfaceHeight - 15 && worldY > minY + 2 && (worldY > minY + 4 || (int)(noiseVal * 200.0) % 5 == 0) && noiseVal < -0.3) {
                            class_2680 class_26802 = blockState = worldY > minY + 8 ? AIR : LAVA;
                        }
                        if ((beard = beardifier.method_40464((class_6910.class_6912)new class_6910.class_6914(worldX, worldY, worldZ))) > 0.1) {
                            blockState = this.defaultBlock;
                        }
                        if (blockState == AIR) continue;
                        levelChunkSection.method_12256(blockXInCell, blockYInCell, blockZInCell, blockState, false);
                        oceanFloorMap.method_12597(blockXInCell, worldY, blockZInCell, blockState);
                        worldSurfaceMap.method_12597(blockXInCell, worldY, blockZInCell, blockState);
                        if (blockState.method_26227().method_15769()) continue;
                        mutableBlockPos.method_10103(worldX, worldY, worldZ);
                        chunkAccess.method_12039((class_2338)mutableBlockPos);
                    }
                }
            }
        }
        return chunkAccess;
    }

    protected void method_38327(class_6748 blender, class_7138 randomState, class_5138 structureManager, class_2791 chunkAccess) {
        class_1966 class_19662 = this.field_12761;
        if (class_19662 instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)class_19662;
            source.setRegistryAccess(structureManager.method_41036());
            chunkAccess.method_38257((class_6780)source.cache(), randomState.method_42371());
        } else {
            chunkAccess.method_38257((class_6780)this.field_12761, randomState.method_42371());
        }
    }

    public void method_12110(class_3233 worldGenRegion, class_5138 structureManager, class_7138 randomState, class_2791 chunkAccess) {
        class_6724 class_67242 = randomState.method_42372();
        if (class_67242 instanceof StarlightSurfaceSystem) {
            StarlightSurfaceSystem system = (StarlightSurfaceSystem)class_67242;
            system.setStarlightChunkGenerator(this);
            class_1966 class_19662 = this.field_12761;
            if (class_19662 instanceof ESBiomeSource) {
                ESBiomeSource source = (ESBiomeSource)class_19662;
                randomState = ((IRandomState)randomState).clone();
                class_6724 clonedSurfaceSystem = ((StarlightSurfaceSystem)randomState.method_42372()).clone();
                ((IRandomState)randomState).setSurfaceSystem(clonedSurfaceSystem);
                ((StarlightSurfaceSystem)clonedSurfaceSystem).setCachedStarlightBiomeSource(source.cache());
            }
        }
        super.method_12110(worldGenRegion, structureManager, randomState, chunkAccess);
    }

    public int method_16397(int x, int z, class_2902.class_2903 types, class_5539 levelHeightAccessor, class_7138 randomState) {
        return this.getSurfaceHeight(x, z);
    }

    public class_4966 method_26261(int x, int z, class_5539 levelHeightAccessor, class_7138 randomState) {
        class_2680[] states = new class_2680[((class_5284)this.method_41541().comp_349()).comp_474().method_42368(levelHeightAccessor).comp_174()];
        this.iterateTerrainColumn(x, z, states, null, levelHeightAccessor);
        return new class_4966(levelHeightAccessor.method_31607(), states);
    }

    private int iterateTerrainColumn(int x, int z, class_2680[] states, @Nullable Predicate<class_2680> statePredicate, class_5539 level) {
        int surfaceHeight = this.getSurfaceHeight(x, z);
        int maxHeight = level.method_31600();
        int height = level.method_31607();
        BiomeData data = this.getBiomeDataAt(x, z);
        int index = 0;
        while (height < maxHeight) {
            class_2680 state = this.getStateAt(height, surfaceHeight, data);
            if (statePredicate != null && !statePredicate.test(state)) continue;
            states[index] = state;
            ++index;
            ++height;
        }
        return states.length;
    }

    private class_2680 getStateAt(int y, int surfaceHeight, BiomeData data) {
        class_2680 state = y <= surfaceHeight ? this.defaultBlock : (y <= this.seaLevel ? ((class_2248)data.fluidBlock().comp_349()).method_9564() : AIR);
        return state;
    }

    public int getSurfaceHeight(int x, int z) {
        class_1966 class_19662 = this.field_12761;
        if (class_19662 instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)class_19662;
            return source.getHeight(x, z);
        }
        return 0;
    }

    public int getSurfaceHeight(IESBiomeSource source, int x, int z) {
        if (source != null) {
            return source.getHeight(x, z);
        }
        return 0;
    }

    private BiomeData getBiomeDataAt(int x, int z) {
        class_1966 class_19662 = this.field_12761;
        if (class_19662 instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)class_19662;
            return source.getBiomeData(x, z);
        }
        return null;
    }

    private BiomeData getBiomeDataAt(IESBiomeSource source, int x, int z) {
        if (source != null) {
            return source.getBiomeData(x, z);
        }
        return null;
    }

    @Nullable
    public Pair<class_2338, class_6880<class_3195>> method_12103(class_3218 level, class_6885<class_3195> structure, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        Pair mapStructure = super.method_12103(level, structure, pos, searchRadius, skipKnownStructures);
        if (mapStructure != null) {
            return mapStructure;
        }
        class_7869 structureState = level.method_14178().method_46642();
        Object2ObjectArrayMap placements = new Object2ObjectArrayMap();
        for (class_6880 structureHolder : structure) {
            for (class_6874 structurePlacement : structureState.method_46708(structureHolder)) {
                placements.computeIfAbsent(structurePlacement, placement -> new ObjectArraySet()).add(structureHolder);
            }
        }
        if (placements.isEmpty()) {
            return null;
        }
        Pair result = null;
        double currentDist = Double.MAX_VALUE;
        class_5138 structureManager = level.method_27056();
        ArrayList list = new ArrayList(placements.size());
        for (Map.Entry entry : placements.entrySet()) {
            if (!(entry.getKey() instanceof LandmarkStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int chunkX = class_4076.method_18675((int)pos.method_10263());
            int chunkZ = class_4076.method_18675((int)pos.method_10260());
            for (int currentRadius = 0; currentRadius <= searchRadius; ++currentRadius) {
                boolean found = false;
                for (Map.Entry entry : list) {
                    Pair currentStructure = null;
                    for (int x = -currentRadius; x <= currentRadius; ++x) {
                        boolean xSide = x == -currentRadius || x == currentRadius;
                        for (int z = -currentRadius; z <= currentRadius; ++z) {
                            boolean zSide;
                            boolean bl = zSide = z == -currentRadius || z == currentRadius;
                            if (!xSide && !zSide) continue;
                            class_1923 landmarkPos = LandmarkStructurePlacement.getRegionLandmarkPos(structureState, x + chunkX, z + chunkZ);
                            if (landmarkPos.field_9181 != x + chunkX || landmarkPos.field_9180 != z + chunkZ) continue;
                            currentStructure = ESChunkGenerator.method_41522((Set)((Set)entry.getValue()), (class_4538)level, (class_5138)structureManager, (boolean)skipKnownStructures, (class_6874)((class_6874)entry.getKey()), (class_1923)landmarkPos);
                        }
                    }
                    if (currentStructure == null) continue;
                    found = true;
                    double dist = pos.method_10262((class_2382)currentStructure.getFirst());
                    if (!(dist < currentDist)) continue;
                    currentDist = dist;
                    result = currentStructure;
                }
                if (!found) continue;
                return result;
            }
        }
        return result;
    }
}

