/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Creteor;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class AethersentMeteor
extends class_1668
implements TrailOwner {
    public static final String TAG_METEOR_COOLDOWN = "meteor_cooldown";
    private static final String TAG_SIZE = "size";
    private static final String TAG_TARGET = "target";
    private static final String TAG_TARGET_X = "target_x";
    private static final String TAG_TARGET_Y = "target_y";
    private static final String TAG_TARGET_Z = "target_z";
    private static final String TAG_ONLY_HURT_ENEMY = "only_hurt_enemy";
    private static final String TAG_NATURAL = "natural";
    private static final class_2960 TRAIL_TEXTURE = EternalStarlight.id("textures/entity/concentrated_trail.png");
    protected static final class_2940<Integer> SIZE = class_2945.method_12791(AethersentMeteor.class, (class_2941)class_2943.field_13327);
    @Nullable
    private class_1309 target;
    @Nullable
    private UUID targetId;
    private class_243 targetPos = class_243.field_1353;
    private boolean onlyHurtEnemy = true;
    private boolean natural = true;

    public int getSize() {
        return (Integer)this.method_5841().method_12789(SIZE);
    }

    public void setSize(int size) {
        this.method_5841().method_12778(SIZE, (Object)size);
    }

    public class_1309 getTarget() {
        return this.target;
    }

    public void setTarget(class_1309 target) {
        this.target = target;
    }

    public void setTargetPos(class_243 targetPos) {
        this.targetPos = targetPos;
    }

    public void setOnlyHurtEnemy(boolean onlyHurtEnemy) {
        this.onlyHurtEnemy = onlyHurtEnemy;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public AethersentMeteor(class_1299<? extends AethersentMeteor> type, class_1937 level) {
        super(type, level);
    }

    public AethersentMeteor(class_1937 level, class_1309 entity, double x, double y, double z) {
        this(ESEntities.AETHERSENT_METEOR.get(), level);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.method_5814(x, y, z);
        this.method_7432((class_1297)entity);
    }

    public static void createMeteorShower(class_1937 level, class_1309 entity, class_1309 target, double targetX, double targetY, double targetZ, double height, boolean onlyHurtEnemy) {
        if (!level.field_9236) {
            class_2487 tag = ESEntityUtil.getPersistentData((class_1297)entity);
            if (tag.method_10550(TAG_METEOR_COOLDOWN) > 0) {
                return;
            }
            tag.method_10569(TAG_METEOR_COOLDOWN, 1);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    class_5819 random = entity.method_59922();
                    AethersentMeteor meteor = new AethersentMeteor(level, entity, targetX + (double)x + ((double)random.method_43057() - 0.5) * 3.0, targetY + height + ((double)random.method_43057() - 0.5) * 5.0, targetZ + (double)z + ((double)random.method_43057() - 0.5) * 3.0);
                    meteor.setSize(random.method_43051(2, 5));
                    meteor.setTarget(target);
                    meteor.setTargetPos(new class_243(targetX, targetY, targetZ));
                    meteor.onlyHurtEnemy = onlyHurtEnemy;
                    meteor.natural = false;
                    level.method_8649((class_1297)meteor);
                    if (!(level instanceof class_3218)) continue;
                    class_3218 serverLevel = (class_3218)level;
                    serverLevel.method_14199((class_2394)class_2398.field_11236, meteor.method_23317(), meteor.method_23318(), meteor.method_23321(), 2, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SIZE, (Object)0);
    }

    public void method_5749(class_2487 compoundTag) {
        this.setSize(compoundTag.method_10550(TAG_SIZE));
        if (compoundTag.method_25928(TAG_TARGET)) {
            this.targetId = compoundTag.method_25926(TAG_TARGET);
        }
        this.targetPos = new class_243(compoundTag.method_10574(TAG_TARGET_X), compoundTag.method_10574(TAG_TARGET_Y), compoundTag.method_10574(TAG_TARGET_Z));
        if (compoundTag.method_10573(TAG_ONLY_HURT_ENEMY, 1)) {
            this.onlyHurtEnemy = compoundTag.method_10577(TAG_ONLY_HURT_ENEMY);
        }
        if (compoundTag.method_10573(TAG_NATURAL, 1)) {
            this.natural = compoundTag.method_10577(TAG_NATURAL);
        }
    }

    public void method_5652(class_2487 compoundTag) {
        compoundTag.method_10569(TAG_SIZE, this.getSize());
        if (this.target != null) {
            compoundTag.method_25927(TAG_TARGET, this.target.method_5667());
        }
        if (this.targetPos != null) {
            compoundTag.method_10549(TAG_TARGET_X, this.targetPos.field_1352);
            compoundTag.method_10549(TAG_TARGET_Y, this.targetPos.field_1351);
            compoundTag.method_10549(TAG_TARGET_Z, this.targetPos.field_1350);
        }
        compoundTag.method_10556(TAG_ONLY_HURT_ENEMY, this.onlyHurtEnemy);
        compoundTag.method_10556(TAG_NATURAL, this.natural);
    }

    public void dropAndDiscard(boolean clean) {
        if (!this.method_31481() && !this.method_37908().field_9236) {
            if (this.natural && this.getSize() >= 10) {
                class_1542 entity = this.method_5775(new class_1799((class_1935)ESItems.RAW_AETHERSENT.get(), this.field_5974.method_43051(5, 9)));
                if (entity != null) {
                    entity.method_5834(true);
                }
                if (!clean) {
                    for (int x = -3; x <= 3; ++x) {
                        for (int y = -3; y <= 3; ++y) {
                            for (int z = -3; z <= 3; ++z) {
                                class_2338 pos = this.method_24515().method_10069(x, y, z);
                                if (!(pos.method_19770((class_2374)this.method_24515().method_46558()) <= 3.5) || !this.method_37908().method_8320(pos).method_26164(ESTags.Blocks.AETHERSENT_METEOR_REPLACEABLES)) continue;
                                this.method_37908().method_8501(pos, this.field_5974.method_43056() ? ESBlocks.RAW_AETHERSENT_BLOCK.get().method_9564() : ESBlocks.NEBULAITE.get().method_9564());
                            }
                        }
                    }
                    if (ESConfig.INSTANCE.mobsConfig.creteor.canSpawn() && (double)this.field_5974.method_43057() < ESConfig.INSTANCE.mobsConfig.creteor.spawnChance() && this.method_37908().method_18467(Creteor.class, this.method_5829().method_1014(32.0)).isEmpty()) {
                        Creteor creteor = new Creteor(ESEntities.CRETEOR.get(), this.method_37908());
                        creteor.method_33574(this.method_19538());
                        creteor.method_5971();
                        this.method_37908().method_8649((class_1297)creteor);
                    }
                    for (int m = 0; m < ((class_3218)this.method_37908()).method_18456().size(); ++m) {
                        class_3222 serverPlayer = (class_3222)((class_3218)this.method_37908()).method_18456().get(m);
                        ((class_3218)this.method_37908()).method_14166(serverPlayer, (class_2394)ESParticles.AETHERSENT_EXPLOSION.get(), true, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else {
                    class_1937 m = this.method_37908();
                    if (m instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)m;
                        for (int i = 0; i < 25; ++i) {
                            class_243 speed = new class_243((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)).method_1029();
                            ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.AETHERSENT, this.method_19538().field_1352 + speed.field_1352 * 1.2, this.method_19538().field_1351 + speed.field_1351 * 1.2, this.method_19538().field_1350 + speed.field_1350 * 1.2, speed.field_1352, speed.field_1351, speed.field_1350));
                        }
                    }
                }
            }
            this.method_31472();
        }
    }

    protected void method_7488(class_239 hitResult) {
        Object serverLevel;
        super.method_7488(hitResult);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            serverLevel = (class_3218)class_19372;
            ScreenShakeVfx.createInstance((class_5321<class_1937>)this.method_37908().method_27983(), this.method_19538(), 45.0f, 40, 0.01f, 0.015f, 4.5f, 5.0f).send((class_3218)serverLevel);
        }
        for (class_1309 livingEntity : this.method_37908().method_18467(class_1309.class, this.method_5829().method_1009((double)this.getSize(), 0.0, (double)this.getSize()))) {
            if (this.method_24921() instanceof class_1657 && !(livingEntity instanceof class_1569) && this.onlyHurtEnemy || this.method_24921() == livingEntity) continue;
            livingEntity.field_6008 = 0;
            livingEntity.method_5643(ESDamageTypes.getEntityDamageSource(this.method_37908(), ESDamageTypes.METEOR, this.method_24921()), (float)this.getSize() * 5.0f * (this.method_24921() instanceof class_1309 ? 0.02f : 1.0f));
        }
        if (this.getTarget() != null && this.method_23318() < this.getTarget().method_23318() || this.method_23318() < this.targetPos.field_1351) {
            this.method_5783((class_3414)class_3417.field_15152.comp_349(), this.getSoundVolume(), this.getVoicePitch());
            if (!this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
                serverLevel = (class_3218)class_19372;
                serverLevel.method_14199((class_2394)(this.getSize() >= 8 ? class_2398.field_11221 : class_2398.field_11236), this.method_23317(), this.method_23318() + 0.05 * (double)this.getSize(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.method_31472();
        }
        if (this.natural) {
            this.dropAndDiscard(false);
        }
    }

    public void method_5773() {
        class_1937 class_19372;
        super.method_5773();
        this.method_18800(0.0, -2.0, 0.0);
        if (this.field_6012 % 10 == 0) {
            this.method_18382();
        }
        if (!this.method_37908().field_9236 && this.target == null && this.targetId != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_1297 class_12972 = serverLevel.method_14190(this.targetId);
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity;
                this.target = livingEntity = (class_1309)class_12972;
            }
            if (this.target == null) {
                this.targetId = null;
            }
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_18383((float)this.getSize() / 10.0f);
    }

    @Nullable
    protected class_2394 method_7467() {
        return null;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f;
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_5809() {
        return false;
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        return false;
    }

    protected boolean method_7468() {
        return false;
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(Math.max((float)this.getSize() / 10.0f, 0.4f), 15);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        class_243 oldPos = new class_243(this.field_6038, this.field_5971, this.field_5989);
        effect.update(oldPos.method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0), this.method_19538().method_1020(oldPos));
        if (this.method_31481()) {
            effect.setLength(Math.max(effect.getLength() - 1.2f, 0.0f));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TrailEffect.TrailPoint adjustPoint(TrailEffect.TrailPoint point, boolean vertical, float partialTicks) {
        class_243 center = point.center();
        float width = point.width() / 2.0f;
        if (class_310.method_1551().method_1560() != null) {
            float yRot = class_310.method_1551().method_1560().method_5791() + 90.0f;
            class_243 upper = ESMathUtil.rotationToPosition(center, width, 0.0f, yRot + 90.0f);
            class_243 lower = ESMathUtil.rotationToPosition(center, width, 0.0f, yRot - 90.0f);
            return new TrailEffect.TrailPoint(upper, lower);
        }
        return point;
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.5647059f, 0.36862746f, 0.65882355f, 1.0f);
    }

    @Override
    public boolean isTrailFullBright() {
        return true;
    }

    @Override
    public boolean shouldRenderHorizontal() {
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1921 getTrailRenderType() {
        return ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE);
    }
}

