/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESLootTables;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESServerBossEvent;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperCastFireballPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperComboPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperDanceFightPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperDashPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperDodgePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperMeleePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperSwingSwordPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperTrades;
import cn.leolezury.eternalstarlight.common.entity.living.goal.GatekeeperTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.LookAtTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.handler.CommonHandlers;
import cn.leolezury.eternalstarlight.common.item.component.ResourceKeyComponent;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_3853;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_8103;
import net.minecraft.class_8779;
import org.jetbrains.annotations.Nullable;

public class TheGatekeeper
extends ESBoss
implements class_1655,
class_1915 {
    private static final String TAG_GATEKEEPER_NAME = "gatekeeper_name";
    private static final String TAG_FIGHT_TARGET = "flight_target";
    private static final String TAG_FIGHT_PLAYER_ONLY = "fight_player_only";
    private static final String TAG_RESTOCK_COOLDOWN = "restock_cooldown";
    private final ESServerBossEvent bossEvent = new ESServerBossEvent(this, this.method_5667(), class_1259.class_1260.field_5783, false);
    protected static final class_2940<Float> FIXED_Y_ROT = class_2945.method_12791(TheGatekeeper.class, (class_2941)class_2943.field_13320);
    private final BehaviorManager<TheGatekeeper> behaviorManager = new BehaviorManager<TheGatekeeper>(this, List.of(new GatekeeperMeleePhase(), new GatekeeperDodgePhase(), new GatekeeperDashPhase(), new GatekeeperCastFireballPhase(), new GatekeeperDanceFightPhase(), new GatekeeperSwingSwordPhase(), new GatekeeperComboPhase()));
    public class_7094 idleAnimationState = new class_7094();
    public class_7094 meleeAnimationStateA = new class_7094();
    public class_7094 meleeAnimationStateB = new class_7094();
    public class_7094 meleeAnimationStateC = new class_7094();
    public class_7094 dodgeAnimationState = new class_7094();
    public class_7094 dashAnimationState = new class_7094();
    public class_7094 castFireballAnimationState = new class_7094();
    public class_7094 danceFightAnimationState = new class_7094();
    public class_7094 swingSwordAnimationState = new class_7094();
    public class_7094 comboAnimationState = new class_7094();
    private String gatekeeperName = "TheGatekeeper";
    @Nullable
    private class_1657 customer;
    @Nullable
    protected class_1916 offers;
    private int restockCooldown;
    @Nullable
    private class_3222 conversationTarget;
    @Nullable
    private String fightTarget;
    private boolean fightPlayerOnly = true;

    public TheGatekeeper(class_1299<? extends TheGatekeeper> entityType, class_1937 level) {
        super(entityType, level);
    }

    public float getFixedYRot() {
        return ((Float)this.method_5841().method_12789(FIXED_Y_ROT)).floatValue();
    }

    public void setFixedYRot(float attackYRot) {
        this.method_5841().method_12778(FIXED_Y_ROT, (Object)Float.valueOf(attackYRot));
    }

    public void setFightPlayerOnly(boolean fightPlayerOnly) {
        this.fightPlayerOnly = fightPlayerOnly;
    }

    public void setFightTargetName(String fightTarget) {
        this.fightTarget = fightTarget;
    }

    public Optional<? extends class_1657> getFightTarget() {
        return this.method_37908().method_18456().stream().filter(p -> p.method_5477().getString().equals(this.fightTarget)).findFirst();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FIXED_Y_ROT, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.gatekeeperName = compoundTag.method_10558(TAG_GATEKEEPER_NAME);
        this.fightTarget = compoundTag.method_10558(TAG_FIGHT_TARGET);
        this.fightPlayerOnly = compoundTag.method_10577(TAG_FIGHT_PLAYER_ONLY);
        this.restockCooldown = compoundTag.method_10550(TAG_RESTOCK_COOLDOWN);
        this.bossEvent.setId(this.method_5667());
        if (this.offers == null) {
            this.offers = new class_1916();
            this.addTrades();
        }
    }

    @Override
    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10582(TAG_GATEKEEPER_NAME, this.gatekeeperName);
        if (this.fightTarget != null) {
            compoundTag.method_10582(TAG_FIGHT_TARGET, this.fightTarget);
        }
        compoundTag.method_10556(TAG_FIGHT_PLAYER_ONLY, this.fightPlayerOnly);
        compoundTag.method_10569(TAG_RESTOCK_COOLDOWN, this.restockCooldown);
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1366(this, (class_1314)this, 0.5, false){

            protected void method_6288(class_1309 livingEntity) {
            }
        });
        this.field_6201.method_6277(2, (class_1352)new LookAtTargetGoal((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(0, (class_1352)new GatekeeperTargetGoal((class_1314)this){

            @Override
            public boolean method_6264() {
                return super.method_6264() && TheGatekeeper.this.fightPlayerOnly && TheGatekeeper.this.isActivated();
            }
        });
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{TheGatekeeper.class}){

            public boolean method_6264() {
                return super.method_6264() && !TheGatekeeper.this.fightPlayerOnly && TheGatekeeper.this.isActivated();
            }
        }.method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400<class_1657>((class_1308)this, class_1657.class, true){

            public boolean method_6264() {
                return super.method_6264() && !TheGatekeeper.this.fightPlayerOnly && TheGatekeeper.this.isActivated();
            }
        });
    }

    protected class_1330 method_5963() {
        return new class_1330((class_1308)this){

            public void method_6224() {
                if (TheGatekeeper.this.getBehaviorState() == 3) {
                    TheGatekeeper.this.method_5636(TheGatekeeper.this.getFixedYRot());
                    TheGatekeeper.this.method_5847(TheGatekeeper.this.getFixedYRot());
                } else {
                    super.method_6224();
                }
            }
        };
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, ESConfig.INSTANCE.mobsConfig.theGatekeeper.maxHealth()).method_26868(class_5134.field_23724, ESConfig.INSTANCE.mobsConfig.theGatekeeper.armor()).method_26868(class_5134.field_23721, ESConfig.INSTANCE.mobsConfig.theGatekeeper.attackDamage()).method_26868(class_5134.field_23717, ESConfig.INSTANCE.mobsConfig.theGatekeeper.followRange()).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23725, 5.0).method_26868(class_5134.field_23718, 0.8);
    }

    @Nullable
    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData) {
        spawnGroupData = super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        class_5819 randomSource = serverLevelAccessor.method_8409();
        this.method_5964(randomSource, difficultyInstance);
        return spawnGroupData;
    }

    protected void method_5964(class_5819 randomSource, class_1266 difficultyInstance) {
        super.method_5964(randomSource, difficultyInstance);
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)ESItems.SHATTERED_SWORD.get()));
    }

    public void stopAllAnimStates() {
        this.meleeAnimationStateA.method_41325();
        this.meleeAnimationStateB.method_41325();
        this.meleeAnimationStateC.method_41325();
        this.dodgeAnimationState.method_41325();
        this.dashAnimationState.method_41325();
        this.castFireballAnimationState.method_41325();
        this.danceFightAnimationState.method_41325();
        this.swingSwordAnimationState.method_41325();
        this.comboAnimationState.method_41325();
    }

    public void method_5674(class_2940<?> accessor) {
        if (accessor.equals((Object)BEHAVIOR_STATE) && this.getBehaviorState() != 0) {
            this.stopAllAnimStates();
            switch (this.getBehaviorState()) {
                case 1: {
                    switch (this.method_59922().method_43048(3)) {
                        case 0: {
                            this.meleeAnimationStateA.method_41322(this.field_6012);
                            break;
                        }
                        case 1: {
                            this.meleeAnimationStateB.method_41322(this.field_6012);
                            break;
                        }
                        case 2: {
                            this.meleeAnimationStateC.method_41322(this.field_6012);
                        }
                    }
                    break;
                }
                case 2: {
                    this.dodgeAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 3: {
                    this.dashAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 4: {
                    this.castFireballAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 5: {
                    this.danceFightAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 6: {
                    this.swingSwordAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 7: {
                    this.comboAnimationState.method_41322(this.field_6012);
                }
            }
        }
        super.method_5674(accessor);
    }

    public boolean method_18395(class_1309 livingEntity) {
        return super.method_18395(livingEntity) && this.isActivated();
    }

    public void method_18799(class_243 vec3) {
        boolean cantMove = this.getBehaviorState() == 5 || this.getBehaviorState() == 6;
        super.method_18799(cantMove ? new class_243(0.0, vec3.field_1351, 0.0) : vec3);
    }

    @Override
    public void initializeBoss() {
        super.initializeBoss();
        this.setActivated(false);
        this.gatekeeperName = CommonHandlers.getGatekeeperName();
    }

    @Override
    public boolean shouldPlayBossMusic() {
        return super.shouldPlayBossMusic() && this.isActivated();
    }

    protected class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_3222 serverPlayer;
        if (!this.method_37908().field_9236 && player instanceof class_3222 && (serverPlayer = (class_3222)player).method_5682() != null && this.method_8257() == null && !this.isActivated() && this.method_5968() == null && this.getFightTarget().isEmpty()) {
            class_8779 killDragon = serverPlayer.method_5682().method_3851().method_12896(class_2960.method_60656((String)"end/kill_dragon"));
            boolean killed = killDragon != null && serverPlayer.method_14236().method_12882(killDragon).method_740();
            boolean challenged = this.isPlayerPermitted(serverPlayer);
            boolean hasOrb = false;
            for (int i = 0; i < serverPlayer.method_31548().method_5439(); ++i) {
                if (!serverPlayer.method_31548().method_5438(i).method_31574(ESItems.ORB_OF_PROPHECY.get())) continue;
                hasOrb = true;
            }
            boolean hasBook = false;
            for (int i = 0; i < serverPlayer.method_31548().method_5439(); ++i) {
                ResourceKeyComponent component;
                class_1799 inventoryItem = serverPlayer.method_31548().method_5438(i);
                if (inventoryItem.method_31574(ESItems.BOOK.get())) {
                    hasBook = true;
                }
                if (!inventoryItem.method_31574(ESItems.LOOT_BAG.get()) || (component = (ResourceKeyComponent)inventoryItem.method_57824(ESDataComponents.LOOT_TABLE.get())) == null || !component.resourceKey().method_29177().equals((Object)ESLootTables.BOSS_THE_GATEKEEPER.method_29177())) continue;
                hasBook = true;
            }
            if (!challenged) {
                if (killed) {
                    class_1542 orb;
                    class_1542 book;
                    this.permitPlayer(serverPlayer);
                    if (!hasBook && (book = this.method_5706((class_1935)ESItems.BOOK.get())) != null) {
                        book.method_5834(true);
                    }
                    if (!hasOrb && (orb = this.method_5706((class_1935)ESItems.ORB_OF_PROPHECY.get())) != null) {
                        orb.method_5834(true);
                    }
                } else if (super.method_18395((class_1309)serverPlayer)) {
                    this.setFightTargetName(serverPlayer.method_5477().getString());
                    this.setActivated(true);
                    this.method_5673(class_1304.field_6173, new class_1799((class_1935)ESItems.SHATTERED_SWORD.get()));
                }
            } else if (!this.method_8264().isEmpty()) {
                this.method_8259((class_1657)serverPlayer);
                this.method_17449((class_1657)serverPlayer, this.method_5476(), 1);
            }
        }
        return this.isActivated() ? class_1269.field_5811 : class_1269.method_29236((boolean)this.method_37908().field_9236);
    }

    private void permitPlayer(class_3222 player) {
        ESCriteriaTriggers.CHALLENGED_GATEKEEPER.get().method_9141(player);
        ESBookUtil.unlock(player, EternalStarlight.id("permitted_by_gatekeeper"));
    }

    private boolean isPlayerPermitted(class_3222 player) {
        if (player.method_5682() != null) {
            boolean challenged;
            class_8779 challenge = player.method_5682().method_3851().method_12896(EternalStarlight.id("challenge_gatekeeper"));
            boolean bl = challenged = challenge != null && player.method_14236().method_12882(challenge).method_740();
            if (challenged) {
                return true;
            }
        }
        return ESBookUtil.getUnlockedParts(player).contains(EternalStarlight.id("permitted_by_gatekeeper"));
    }

    public void spawnMeleeAttackParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            float lookYaw = this.method_5791() + 90.0f;
            float lookPitch = -this.method_36455();
            class_243 initialEndPos = ESMathUtil.rotationToPosition(this.method_33571(), 1.0f, lookPitch, lookYaw);
            for (int i = 0; i < 15; ++i) {
                class_243 endPos = initialEndPos.method_49272(this.method_59922(), 0.8f);
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((class_2394)ESParticles.BLADE_SHOCKWAVE.get(), this.method_33571().field_1352, this.method_33571().field_1351, this.method_33571().field_1350, endPos.field_1352 - this.method_33571().field_1352, endPos.field_1351 - this.method_33571().field_1351, endPos.field_1350 - this.method_33571().field_1350));
            }
        }
    }

    @Override
    public void method_6078(class_1282 source) {
        if (source.method_48789(class_8103.field_42242)) {
            super.method_6078(source);
        } else if (!this.method_37908().field_9236) {
            this.getFightTarget().ifPresent(p -> {
                if (p instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)p;
                    this.permitPlayer(serverPlayer);
                }
            });
            for (class_1657 player : this.method_37908().method_18456()) {
                if (!(player instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)player;
                if (!this.fightParticipants.stream().anyMatch(s -> s.equals(player.method_5477().getString())) || !player.method_5805()) continue;
                this.permitPlayer(serverPlayer);
            }
            this.method_6033(this.method_6063());
            this.setFightTargetName("");
            this.method_5980(null);
            this.setActivated(false);
            this.tryTeleportBack();
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                this.method_6099(serverLevel, source, true);
            }
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (!(source.method_48789(class_8103.field_42242) || source.method_5529() != null && this.method_5968() != null)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    private void tryTeleportBack() {
        class_243 initialPos = this.getInitialPos();
        class_2338 blockPos = class_2338.method_49638((class_2374)initialPos);
        if (initialPos.method_1022(this.method_19538()) > 15.0) {
            Stream<class_265> shapes = StreamSupport.stream(this.method_37908().method_20812((class_1297)this, this.method_5829().method_997(initialPos.method_1020(this.method_19538()))).spliterator(), false);
            if (shapes.allMatch(class_265::method_1110) && this.method_37908().method_8320(blockPos.method_10074()).method_26206((class_1922)this.method_37908(), blockPos.method_10074(), class_2350.field_11036)) {
                this.method_33574(initialPos);
                return;
            }
            for (int i = 0; !(i >= 16 || this.teleportTowards(initialPos) && initialPos.method_1022(this.method_19538()) <= 15.0); ++i) {
            }
        }
    }

    private boolean teleportTowards(class_243 target) {
        class_243 vec3 = new class_243(this.method_23317() - target.method_10216(), this.method_23323(0.5) - target.method_10214(), this.method_23321() - target.method_10215()).method_1029();
        double x = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 8.0 - vec3.field_1352 * 16.0;
        double y = this.method_23318() + (double)(this.field_5974.method_43048(16) - 8) - vec3.field_1351 * 16.0;
        double z = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 8.0 - vec3.field_1350 * 16.0;
        return this.teleport(target, x, y, z);
    }

    private boolean teleport(class_243 target, double x, double y, double z) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, y, z);
        while (mutableBlockPos.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutableBlockPos).method_51366()) {
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.method_37908().method_8320((class_2338)mutableBlockPos);
        if (blockState.method_51366()) {
            return this.randomTeleportGatekeeper(target, x, y, z);
        }
        return false;
    }

    private boolean randomTeleportGatekeeper(class_243 target, double x, double y, double z) {
        double oldX = this.method_23317();
        double oldY = this.method_23318();
        double oldZ = this.method_23321();
        double currentY = y;
        boolean success = false;
        class_2338 blockPos = class_2338.method_49637((double)x, (double)currentY, (double)z);
        class_1937 level = this.method_37908();
        if (level.method_22340(blockPos)) {
            boolean blocksMotion = false;
            while (!blocksMotion && blockPos.method_10264() > level.method_31607()) {
                class_2338 blockPos2 = blockPos.method_10074();
                class_2680 blockState = level.method_8320(blockPos2);
                if (blockState.method_51366()) {
                    blocksMotion = true;
                    continue;
                }
                currentY -= 1.0;
                blockPos = blockPos2;
            }
            if (blocksMotion) {
                class_243 class_2432 = new class_243(x, currentY, z);
                if (class_2432.method_1022(target) <= 15.0) {
                    if (ESPlatform.INSTANCE.postTeleportEvent((class_1297)this, new class_243(x, currentY, z))) {
                        this.method_5859(x, currentY, z);
                    }
                    boolean bl = success = level.method_17892((class_1297)this) && !level.method_22345(this.method_5829());
                }
            }
        }
        if (!success && ESPlatform.INSTANCE.postTeleportEvent((class_1297)this, new class_243(oldX, oldY, oldZ))) {
            this.method_5859(oldX, oldY, oldZ);
        }
        return success;
    }

    public void method_6007() {
        super.method_6007();
        this.bossEvent.update();
        if (this.field_6012 % 5 == 0 && !this.isActivated()) {
            this.bossEvent.allConvertToUnseen();
        }
        this.method_18382();
        if (!this.method_37908().field_9236) {
            if (this.method_5805() && this.field_6012 % 5 == 0 && (this.method_5968() == null || !this.method_5968().method_5805())) {
                this.method_6033(this.method_6063());
                this.setFightTargetName("");
                this.method_5980(null);
                this.setActivated(false);
                this.tryTeleportBack();
            }
            if (this.restockCooldown > 0) {
                --this.restockCooldown;
            } else {
                this.restockCooldown = 12000;
                this.restockAll();
            }
            if (this.method_8257() != null && this.method_8257().method_5739((class_1297)this) > 16.0f) {
                this.method_8259(null);
            }
            this.method_5665((class_2561)class_2561.method_43470((String)this.gatekeeperName));
            this.method_5880(true);
            if (this.method_5961()) {
                this.method_5937(false);
            }
            if (this.method_5968() != null && !this.method_5968().method_5805()) {
                this.method_5980(null);
            }
            if (this.isActivated() && !this.method_5987() && this.method_5805()) {
                this.behaviorManager.tick();
            }
        } else {
            this.idleAnimationState.method_41324(this.field_6012);
            this.method_37908().method_8406((class_2394)ESParticles.STARLIGHT.get(), this.method_23317() + (this.method_59922().method_43058() - 0.5) * 2.0, this.method_23318() + 1.0 + (this.method_59922().method_43058() - 0.5) * 2.0, this.method_23321() + (this.method_59922().method_43058() - 0.5) * 2.0, 0.0, 0.0, 0.0);
        }
    }

    protected class_4048 method_55694(class_4050 pose) {
        class_4048 dimensions = super.method_55694(pose);
        return this.isActivated() ? dimensions : dimensions.method_19539(1.0f, 0.7f);
    }

    @Override
    public class_3414 getBossMusic() {
        return ESSoundEvents.MUSIC_BOSS_GATEKEEPER.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15115;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14904;
    }

    public void method_8259(@Nullable class_1657 player) {
        this.customer = player;
    }

    @Nullable
    public class_1657 method_8257() {
        return this.customer;
    }

    public class_1916 method_8264() {
        if (this.offers == null) {
            this.offers = new class_1916();
            this.addTrades();
        }
        return this.offers;
    }

    protected void addTrades() {
        class_1916 merchantoffers = this.method_8264();
        this.addTrades(merchantoffers, GatekeeperTrades.TRADES, 50);
    }

    protected void addTrades(class_1916 original, class_3853.class_1652[] newTrades, int maxNumbers) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.field_5974.method_43048(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            class_3853.class_1652 trade = newTrades[integer];
            class_1914 merchantoffer = trade.method_7246((class_1297)this, this.field_5974);
            if (merchantoffer == null) continue;
            original.add((Object)merchantoffer);
        }
    }

    protected void restockAll() {
        for (class_1914 merchantoffer : this.method_8264()) {
            merchantoffer.method_19275();
        }
    }

    public void method_8261(@Nullable class_1916 offers) {
    }

    public void method_8262(class_1914 offer) {
        offer.method_8244();
        this.field_6191 = -this.method_5970();
        if (offer.method_8256()) {
            int i = 3 + this.field_5974.method_43048(4);
            this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), i));
        }
    }

    public void method_8258(class_1799 stack) {
    }

    public int method_19269() {
        return 0;
    }

    public void method_19271(int xp) {
    }

    public boolean method_19270() {
        return false;
    }

    public class_3414 method_18010() {
        return class_3417.field_14709;
    }

    public boolean method_38069() {
        return this.method_37908().field_9236;
    }
}

