/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack.ray;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.RayAttackUser;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_3726;

public class RayAttack
extends class_1297 {
    protected static final class_2940<Integer> CASTER = class_2945.method_12791(RayAttack.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> PITCH = class_2945.method_12791(RayAttack.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> YAW = class_2945.method_12791(RayAttack.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> LENGTH = class_2945.method_12791(RayAttack.class, (class_2941)class_2943.field_13320);
    public float prevPitch;
    public float prevYaw;
    private final Object2IntArrayMap<class_2338> destroyProgresses = new Object2IntArrayMap();

    public Optional<class_1297> getCaster() {
        return Optional.ofNullable(this.method_37908().method_8469(((Integer)this.method_5841().method_12789(CASTER)).intValue()));
    }

    public void setCaster(class_1297 caster) {
        this.method_5841().method_12778(CASTER, (Object)caster.method_5628());
    }

    public float getPitch() {
        return ((Float)this.method_5841().method_12789(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.method_5841().method_12778(PITCH, (Object)Float.valueOf(pitch));
    }

    public float getYaw() {
        return ((Float)this.method_5841().method_12789(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.method_5841().method_12778(YAW, (Object)Float.valueOf(yaw));
    }

    public float getLength() {
        return ((Float)this.method_5841().method_12789(LENGTH)).floatValue();
    }

    public void setLength(float length) {
        this.method_5841().method_12778(LENGTH, (Object)Float.valueOf(length));
    }

    public RayAttack(class_1299<? extends RayAttack> type, class_1937 world) {
        super(type, world);
        this.field_5985 = true;
    }

    public RayAttack(class_1299<? extends RayAttack> type, class_1937 world, class_1309 caster, double x, double y, double z, float yaw, float pitch) {
        this(type, world);
        this.setCaster((class_1297)caster);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setLength(this.getRadius());
        this.method_5814(x, y, z);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(CASTER, (Object)-1).method_56912(PITCH, (Object)Float.valueOf(0.0f)).method_56912(YAW, (Object)Float.valueOf(0.0f)).method_56912(LENGTH, (Object)Float.valueOf(0.0f));
    }

    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            boolean hasBlock;
            class_243 idealEndPos;
            this.update();
            class_243 endPos = idealEndPos = ESMathUtil.rotationToPosition(this.method_19538(), this.getRadius(), this.getPitch(), this.getYaw());
            ESEntityUtil.RaytraceResult result = ESEntityUtil.raytrace((class_1936)this.method_37908(), class_3726.method_16195((class_1297)this), this.method_19538(), idealEndPos);
            this.onFirstHit(result);
            boolean bl = hasBlock = result.blockHitResult() != null && result.blockHitResult().method_17783() != class_239.class_240.field_1333;
            if (hasBlock) {
                endPos = result.blockHitResult().method_17784();
            }
            this.setLength((float)endPos.method_1022(this.method_19538()));
            result = ESEntityUtil.raytrace((class_1936)this.method_37908(), class_3726.method_16195((class_1297)this), this.method_19538(), endPos);
            this.onHit(result);
        } else {
            this.prevYaw = this.getYaw();
            this.prevPitch = this.getPitch();
            this.field_6014 = this.method_23317();
            this.field_6036 = this.method_23318();
            this.field_5969 = this.method_23321();
            class_243 endPos = ESMathUtil.rotationToPosition(this.method_19538(), this.getLength(), this.getPitch(), this.getYaw());
            this.addEndParticles(endPos);
        }
    }

    public int getRadius() {
        return 20;
    }

    public void onFirstHit(ESEntityUtil.RaytraceResult result) {
        this.getCaster().ifPresent(caster -> {
            if (result.blockHitResult() != null) {
                class_2338 hitPos;
                this.destroyProgresses.put((Object)hitPos, this.destroyProgresses.containsKey((Object)(hitPos = result.blockHitResult().method_17777())) ? this.destroyProgresses.getInt((Object)hitPos) + 1 : 1);
                if (this.destroyProgresses.getInt((Object)hitPos) > 60) {
                    class_2680 blockState;
                    boolean canDestroy;
                    boolean bl = canDestroy = ESPlatform.INSTANCE.postEntityDestroyBlockEvent(this.method_37908(), hitPos, (class_1297)caster) && ESConfig.INSTANCE.laserBeamBreakBlocks;
                    if (canDestroy && (blockState = this.method_37908().method_8320(hitPos)).method_26214((class_1922)this.method_37908(), hitPos) >= 0.0f) {
                        this.method_37908().method_8651(hitPos, true, (class_1297)this);
                    }
                }
            }
        });
        while (this.destroyProgresses.size() > 32) {
            this.destroyProgresses.removeInt(this.destroyProgresses.keySet().stream().sorted().toList().getFirst());
        }
    }

    public void onHit(ESEntityUtil.RaytraceResult result) {
        for (class_1297 target : result.entities()) {
            if (!(target instanceof class_1309)) continue;
            class_1309 living = (class_1309)target;
            if (!this.getCaster().isEmpty() && living == this.getCaster().get()) continue;
            this.doHurtTarget(living);
        }
    }

    public void doHurtTarget(class_1309 target) {
        this.getCaster().ifPresent(caster -> {
            if (target.method_5643(ESDamageTypes.getIndirectEntityDamageSource(this.method_37908(), ESDamageTypes.LASER, this, caster), this.getAttackDamage())) {
                target.method_20803(Math.max(target.method_20802(), 100));
            }
        });
    }

    public void addEndParticles(class_243 endPos) {
        for (int i = 0; i < 4; ++i) {
            this.method_37908().method_8466((class_2394)ESExplosionParticleOptions.ENERGY, true, endPos.field_1352 + (double)this.field_5974.method_43057() - 0.5, endPos.field_1351 + (double)this.field_5974.method_43057() - 0.5, endPos.field_1350 + (double)this.field_5974.method_43057() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    public float getRotationSpeed() {
        return 1.6f;
    }

    public float getAttackDamage() {
        return 8.0f;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5640(double distance) {
        return distance < 1024.0;
    }

    protected void method_5749(class_2487 compoundTag) {
    }

    protected void method_5652(class_2487 compoundTag) {
    }

    private void update() {
        this.updateRotations();
        this.updatePosition();
    }

    protected float rotateTowards(float from, float to, float maxAngle) {
        float f = class_3532.method_15381((float)from, (float)to);
        float f1 = class_3532.method_15363((float)f, (float)(-maxAngle), (float)maxAngle);
        return from + f1;
    }

    public void updateRotations() {
        this.getCaster().ifPresent(caster -> {
            if (caster instanceof class_1309) {
                RayAttackUser shooter;
                class_1309 living = (class_1309)caster;
                if (caster instanceof RayAttackUser && !(shooter = (RayAttackUser)caster).isRayFollowingHeadRotation()) {
                    class_243 idealEndPos = ESMathUtil.rotationToPosition(this.method_19538(), this.getRadius(), this.getPitch(), this.getYaw());
                    shooter.updateRayEnd(idealEndPos);
                    class_243 wantedPos = shooter.getRayRotationTarget();
                    float wantedYaw = ESMathUtil.positionToYaw(this.method_19538(), wantedPos);
                    float wantedPitch = ESMathUtil.positionToPitch(this.method_19538(), wantedPos);
                    float currentYaw = this.getYaw();
                    float currentPitch = this.getPitch();
                    this.setYaw(this.rotateTowards(currentYaw, wantedYaw, this.getRotationSpeed()));
                    this.setPitch(this.rotateTowards(currentPitch, wantedPitch, this.getRotationSpeed()));
                } else {
                    this.setYaw(living.field_6241 + 90.0f);
                    this.setPitch(-caster.method_36455());
                }
            }
        });
    }

    public void updatePosition() {
        this.getCaster().ifPresent(caster -> this.method_33574(this.getPositionForCaster((class_1297)caster, caster.method_19538())));
    }

    public class_243 getPositionForCaster(class_1297 caster, class_243 casterPos) {
        return casterPos;
    }
}

