/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.misc.ESBoat;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_7752;
import net.minecraft.class_7753;
import net.minecraft.class_7754;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class ESBoatRenderer
extends class_897<ESBoat> {
    private final Map<ESBoat.Type, Pair<class_2960, class_4595<class_1690>>> boatResources;

    public ESBoatRenderer(class_5617.class_5618 context, boolean chest) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(ESBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)EternalStarlight.id(ESBoatRenderer.getTextureLocation(type, chest)), this.createBoatModel(context, (ESBoat.Type)((Object)type), chest))));
    }

    private static class_5601 createLocation(String path, String model) {
        return new class_5601(EternalStarlight.id(path), model);
    }

    public static class_5601 createBoatModelName(ESBoat.Type pType) {
        return ESBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static class_5601 createChestBoatModelName(ESBoat.Type type) {
        return ESBoatRenderer.createLocation("chest_boat/" + type.getName(), "main");
    }

    private class_4595<class_1690> createBoatModel(class_5617.class_5618 context, ESBoat.Type type, boolean chest) {
        class_5601 modellayerlocation;
        class_5601 class_56012 = modellayerlocation = chest ? ESBoatRenderer.createChestBoatModelName(type) : ESBoatRenderer.createBoatModelName(type);
        if (type == ESBoat.Type.JINGLESTEM) {
            return chest ? new class_7753(context.method_32167(modellayerlocation)) : new class_7754(context.method_32167(modellayerlocation));
        }
        return chest ? new class_7752(context.method_32167(modellayerlocation)) : new class_554(context.method_32167(modellayerlocation));
    }

    private static String getTextureLocation(ESBoat.Type type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(ESBoat boat, float boatYaw, float partialTicks, class_4587 stack, class_4597 buffer, int light) {
        float f2;
        stack.method_22903();
        stack.method_46416(0.0f, 0.375f, 0.0f);
        stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - boatYaw));
        float f = (float)boat.method_54295() - partialTicks;
        float f1 = boat.method_54294() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            stack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * f1 / 10.0f * (float)boat.method_54296()));
        }
        if (!class_3532.method_15347((float)(f2 = boat.method_7547(partialTicks)), (float)0.0f)) {
            stack.method_22907(new Quaternionf().setAngleAxis(boat.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_4595<class_1690>> pair = this.getModelWithLocation(boat);
        class_2960 resourcelocation = (class_2960)pair.getFirst();
        class_4595 model = (class_4595)pair.getSecond();
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        stack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        model.method_2819((class_1297)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexconsumer = buffer.getBuffer(model.method_23500(resourcelocation));
        model.method_60879(stack, vertexconsumer, light, class_4608.field_21444);
        if (model instanceof class_554) {
            class_554 boatModel = (class_554)model;
            if (!boat.method_5869()) {
                class_4588 vertexconsumer1 = buffer.getBuffer(class_1921.method_23589());
                boatModel.method_22954().method_22698(stack, vertexconsumer1, light, class_4608.field_21444);
            }
        }
        stack.method_22909();
        super.method_3936((class_1297)boat, boatYaw, partialTicks, stack, buffer, light);
    }

    public class_2960 getTextureLocation(ESBoat entity) {
        return (class_2960)this.boatResources.get((Object)entity.getESBoatType()).getFirst();
    }

    public Pair<class_2960, class_4595<class_1690>> getModelWithLocation(ESBoat boat) {
        return this.boatResources.get((Object)boat.getESBoatType());
    }
}

