/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookAccess;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentDefinition;
import cn.leolezury.eternalstarlight.common.util.Color;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class IndexBookComponent
extends BookComponent {
    private final class_2561 introText;
    private final List<IndexItem> indexItems = new ArrayList<IndexItem>();
    private final Int2BooleanArrayMap leftHovers = new Int2BooleanArrayMap();
    private final Int2BooleanArrayMap rightHovers = new Int2BooleanArrayMap();
    private final Int2IntArrayMap oldHoverTicks = new Int2IntArrayMap();
    private final Int2IntArrayMap hoverTicks = new Int2IntArrayMap();
    private final List<class_5481> cachedComponents = new ArrayList<class_5481>();
    private final List<class_5481> hoveredIndexItemComponents = new ArrayList<class_5481>();
    private final IntList linesPerIndexItem = new IntArrayList();
    private int indexStartLine;

    public IndexBookComponent(class_2561 introText, List<IndexItem> indexItems, int width, int height) {
        super(width, height);
        this.introText = introText;
        for (IndexItem indexItem : indexItems) {
            if (!indexItem.enabled()) continue;
            this.indexItems.add(indexItem);
        }
    }

    @Override
    public int getPageCount(int pagesBefore, class_327 font) {
        if (this.cachedComponents.isEmpty()) {
            this.cachedComponents.addAll(font.method_1728((class_5348)this.introText, this.width));
            this.indexStartLine = this.cachedComponents.size();
            for (IndexItem indexItem : this.indexItems) {
                this.cachedComponents.addAll(font.method_1728((class_5348)indexItem.text().method_27661().method_54663(4668747), this.width));
                List list = font.method_1728((class_5348)indexItem.text().method_27661().method_54663(2497545).method_27692(class_124.field_1056), this.width);
                this.hoveredIndexItemComponents.addAll(list);
                this.linesPerIndexItem.add(list.size());
            }
        }
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        return this.cachedComponents.size() % linesPerPage == 0 ? this.cachedComponents.size() / linesPerPage : this.cachedComponents.size() / linesPerPage + 1;
    }

    private int getIndexItemFromRelativeLine(int line) {
        int lines = 0;
        for (int i = 0; i < this.indexItems.size(); ++i) {
            if ((lines += this.linesPerIndexItem.getInt(i)) <= line) continue;
            return i;
        }
        return -1;
    }

    private boolean isHovered(int index) {
        return this.leftHovers.getOrDefault(index, false) || this.rightHovers.getOrDefault(index, false);
    }

    @Override
    public void render(BookAccess access, class_332 graphics, class_327 font, int x, int y, int mouseX, int mouseY) {
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        for (int i = access.getRelativePage() * linesPerPage; i < Math.min((access.getRelativePage() + 1) * linesPerPage, this.cachedComponents.size()); ++i) {
            int n = i - access.getRelativePage() * linesPerPage;
            Objects.requireNonNull(font);
            int textY = n * 9;
            class_5481 toDraw = this.cachedComponents.get(i);
            if (i >= this.indexStartLine) {
                int currentIndexItem = this.getIndexItemFromRelativeLine(i - this.indexStartLine);
                int oldHover = this.oldHoverTicks.getOrDefault(currentIndexItem, 0);
                int hover = this.hoverTicks.getOrDefault(currentIndexItem, 0);
                float hoverTicks = Math.min(class_3532.method_16439((float)class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751()), (float)oldHover, (float)hover), 20.0f);
                int color = Color.argbi(0, 1, 1, 1).blend(Color.argb(0x66000000), hoverTicks / 20.0f).argb();
                Objects.requireNonNull(font);
                graphics.method_25296(x, y + textY, x + this.width, y + textY + 9, color, color);
                if (this.isHovered(this.getIndexItemFromRelativeLine(i - this.indexStartLine))) {
                    toDraw = this.hoveredIndexItemComponents.get(i - this.indexStartLine);
                }
            }
            graphics.method_51430(font, toDraw, x, y + textY, 0, false);
        }
    }

    @Override
    public void tick(BookAccess access, class_327 font, int x, int y, int mouseX, int mouseY) {
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        int relativeY = mouseY - y;
        int n = access.getRelativePage() * linesPerPage;
        Objects.requireNonNull(font);
        int line = n + Math.min(relativeY / 9, linesPerPage - 1);
        int hovered = this.getIndexItemFromRelativeLine(line - this.indexStartLine);
        Int2BooleanArrayMap hovers = access.isLeftPage() ? this.leftHovers : this.rightHovers;
        for (Int2BooleanMap.Entry entry : hovers.int2BooleanEntrySet()) {
            hovers.put(entry.getIntKey(), false);
        }
        if (line >= this.indexStartLine && hovered != -1 && mouseX > x && mouseX < x + this.width && mouseY > y && mouseY < y + this.height) {
            hovers.put(hovered, true);
        }
    }

    @Override
    public void singleTick(BookAccess access, class_327 font, int x, int y, int mouseX, int mouseY) {
        this.oldHoverTicks.putAll((Map)this.hoverTicks);
        for (int i = 0; i < this.indexItems.size(); ++i) {
            int value = this.hoverTicks.getOrDefault(i, 0);
            if (!this.isHovered(i)) {
                this.hoverTicks.put(i, Math.max(value - 1, 0));
                continue;
            }
            if (value >= 20) continue;
            this.hoverTicks.put(i, value + 1);
        }
    }

    @Override
    public void onClick(BookAccess access, class_327 font, int x, int y, int mouseX, int mouseY) {
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        int relativeY = mouseY - y;
        int n = access.getRelativePage() * linesPerPage;
        Objects.requireNonNull(font);
        int line = n + Math.min(relativeY / 9, linesPerPage - 1);
        int selected = this.getIndexItemFromRelativeLine(line - this.indexStartLine);
        if (line >= this.indexStartLine && selected != -1 && mouseX > x && mouseX < x + this.width && mouseY > y && mouseY < y + this.height) {
            class_2960 jumpTo = this.indexItems.get(selected).jumpTo();
            for (int i = 0; i < access.getComponents().size(); ++i) {
                BookComponentDefinition definition = access.getComponents().get(i);
                if (!definition.id().equals((Object)jumpTo)) continue;
                int pages = 0;
                for (int j = 0; j < i; ++j) {
                    pages += access.getComponents().get(j).component().getPageCount(pages, font);
                }
                access.setPage(pages);
                break;
            }
        }
    }

    public List<IndexItem> getIndexItems() {
        return this.indexItems;
    }

    public record IndexItem(class_2561 text, class_2561 originalText, class_2960 jumpTo, boolean enabled) {
        public IndexItem(class_2561 text, class_2960 jumpTo, boolean enabled) {
            this((class_2561)class_2561.method_43470((String)"\u2022").method_10852(text), text, jumpTo, enabled);
        }
    }
}

