/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookAccess;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.util.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class DisplayBookComponent
extends BookComponent {
    private final List<TextDisplay> textDisplays = new ArrayList<TextDisplay>();
    private final List<EntityDisplay> entityDisplays = new ArrayList<EntityDisplay>();
    private final Map<EntityDisplay, class_1309> entities = new HashMap<EntityDisplay, class_1309>();
    private final List<ItemDisplay> itemDisplays = new ArrayList<ItemDisplay>();
    private final List<ItemTagDisplay> itemTagDisplays = new ArrayList<ItemTagDisplay>();
    private final List<ImageDisplay> imageDisplays = new ArrayList<ImageDisplay>();
    private int tickCount;

    public DisplayBookComponent(int width, int height) {
        super(width, height);
    }

    @Override
    public int getPageCount(int pagesBefore, class_327 font) {
        return 1;
    }

    @Override
    public void render(BookAccess access, class_332 graphics, class_327 font, int x, int y, int mouseX, int mouseY) {
        for (ImageDisplay imageDisplay : this.imageDisplays) {
            graphics.method_25290(imageDisplay.location(), x + imageDisplay.x(), y + imageDisplay.y(), 0.0f, 0.0f, imageDisplay.width(), imageDisplay.height(), imageDisplay.width(), imageDisplay.height());
        }
        for (EntityDisplay entityDisplay : this.entityDisplays) {
            class_1309 livingEntity;
            if (!this.entities.containsKey(entityDisplay) && class_310.method_1551().field_1687 != null && (livingEntity = (class_1309)entityDisplay.type().method_5883((class_1937)class_310.method_1551().field_1687)) != null) {
                livingEntity.field_6283 = entityDisplay.yRot();
                livingEntity.method_36457(entityDisplay.xRot());
                livingEntity.method_36456(entityDisplay.yRot());
                livingEntity.field_6241 = livingEntity.method_36454();
                livingEntity.field_6259 = livingEntity.method_36454();
                this.entities.put(entityDisplay, livingEntity);
            }
            if (!this.entities.containsKey(entityDisplay)) continue;
            class_490.method_48472((class_332)graphics, (float)(x + entityDisplay.x()), (float)(y + entityDisplay.y()), (float)entityDisplay.scale(), (Vector3f)new Vector3f(), (Quaternionf)entityDisplay.rotation, null, (class_1309)this.entities.get(entityDisplay));
        }
        for (ItemDisplay itemDisplay : this.itemDisplays) {
            graphics.method_51427(itemDisplay.stack(), x + itemDisplay.x(), y + itemDisplay.y());
        }
        for (ItemTagDisplay itemTagDisplay : this.itemTagDisplays) {
            List<class_1792> items = StreamSupport.stream(class_7923.field_41178.method_40286(itemTagDisplay.tag()).spliterator(), false).map(class_6880::comp_349).toList();
            if (items.isEmpty()) continue;
            graphics.method_51427(items.get(this.tickCount / 20 % items.size()).method_7854(), x + itemTagDisplay.x(), y + itemTagDisplay.y());
        }
        for (TextDisplay textDisplay : this.textDisplays) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)(x + textDisplay.x()), (float)(y + textDisplay.y()), 0.0f);
            graphics.method_51448().method_22905(textDisplay.scale(), textDisplay.scale(), textDisplay.scale());
            class_2561 class_25612 = textDisplay.text();
            int n = -font.method_27525((class_5348)textDisplay.text()) / 2;
            Objects.requireNonNull(font);
            graphics.method_51439(font, class_25612, n, -9, Color.BLACK.argb(), false);
            graphics.method_51448().method_22909();
        }
    }

    @Override
    public void tick(BookAccess access, class_327 font, int x, int y, int mouseX, int mouseY) {
        ++this.tickCount;
    }

    @Override
    public void singleTick(BookAccess access, class_327 font, int x, int y, int mouseX, int mouseY) {
    }

    @Override
    public void onClick(BookAccess access, class_327 font, int x, int y, int mouseX, int mouseY) {
    }

    public DisplayBookComponent textDisplay(class_2561 text, int x, int y, float scale) {
        this.textDisplays.add(new TextDisplay(text, x, y, scale));
        return this;
    }

    public DisplayBookComponent entityDisplay(class_1299<? extends class_1309> type, int x, int y, float xRot, float yRot, float scale, Quaternionf rotation) {
        this.entityDisplays.add(new EntityDisplay(type, x, y, xRot, yRot, scale, rotation));
        return this;
    }

    public DisplayBookComponent itemDisplay(class_1799 stack, int x, int y) {
        this.itemDisplays.add(new ItemDisplay(stack, x, y));
        return this;
    }

    public DisplayBookComponent itemTagDisplay(class_6862<class_1792> tag, int x, int y) {
        this.itemTagDisplays.add(new ItemTagDisplay(tag, x, y));
        return this;
    }

    public DisplayBookComponent imageDisplay(class_2960 location, int x, int y, int width, int height) {
        this.imageDisplays.add(new ImageDisplay(location, x, y, width, height));
        return this;
    }

    private record ImageDisplay(class_2960 location, int x, int y, int width, int height) {
    }

    private record EntityDisplay(class_1299<? extends class_1309> type, int x, int y, float xRot, float yRot, float scale, Quaternionf rotation) {
    }

    private record ItemDisplay(class_1799 stack, int x, int y) {
    }

    private record ItemTagDisplay(class_6862<class_1792> tag, int x, int y) {
    }

    private record TextDisplay(class_2561 text, int x, int y, float scale) {
    }
}

