/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.block.DryingRackBlock;
import cn.leolezury.eternalstarlight.common.item.recipe.DryingRecipe;
import cn.leolezury.eternalstarlight.common.item.recipe.DryingRecipeInput;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESRecipes;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class DryingRackBlockEntity
extends class_2586 {
    private static final String TAG_DRYING_TICKS = "drying_ticks";
    private static final String TAG_ITEM = "item";
    private final class_1863.class_7266<DryingRecipeInput, DryingRecipe> quickCheck = class_1863.method_42302(ESRecipes.DRYING.get());
    private boolean lastLit;
    private int dryingTicks = 0;
    private class_1799 item = class_1799.field_8037;

    protected DryingRackBlockEntity(class_2591<?> entityType, class_2338 pos, class_2680 state) {
        super(entityType, pos, state);
    }

    public DryingRackBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(ESBlockEntities.DRYING_RACK.get(), blockPos, blockState);
    }

    public class_1799 getItem() {
        return this.item;
    }

    public void setItem(class_1799 item) {
        this.item = item;
        this.dryingTicks = 0;
        this.markUpdated();
    }

    public boolean canBeDried(class_1799 stack, boolean fireBelow) {
        if (this.field_11863 == null) {
            return false;
        }
        List list = this.field_11863.method_8433().method_30027(ESRecipes.DRYING.get());
        for (class_8786 holder : list) {
            DryingRecipe recipe = (DryingRecipe)holder.comp_1933();
            if (fireBelow != recipe.fireBelow() || !recipe.input().method_8093(stack)) continue;
            return true;
        }
        return false;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, DryingRackBlockEntity entity) {
        if (!entity.item.method_7960()) {
            Optional optionalRecipe;
            boolean lit = (Boolean)state.method_11654((class_2769)DryingRackBlock.LIT);
            if (entity.lastLit != lit) {
                entity.dryingTicks = 0;
                entity.lastLit = lit;
            }
            if ((optionalRecipe = entity.quickCheck.method_42303((class_9695)new DryingRecipeInput(entity.item, lit), level)).isPresent()) {
                DryingRecipe recipe = (DryingRecipe)((class_8786)optionalRecipe.get()).comp_1933();
                ++entity.dryingTicks;
                if (entity.dryingTicks > recipe.durationTicks()) {
                    entity.dryingTicks = 0;
                    entity.setItem(recipe.output().method_7972());
                }
            } else {
                entity.dryingTicks = 0;
            }
        } else {
            entity.dryingTicks = 0;
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38242(provider);
    }

    private void markUpdated() {
        if (this.method_10997() != null) {
            this.method_5431();
            this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.dryingTicks = compoundTag.method_10550(TAG_DRYING_TICKS);
        this.setItem(class_1799.method_57359((class_7225.class_7874)provider, (class_2487)compoundTag.method_10562(TAG_ITEM)));
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_10569(TAG_DRYING_TICKS, this.dryingTicks);
        compoundTag.method_10566(TAG_ITEM, this.item.method_57375(provider));
    }
}

