/*
 * Decompiled with CFR 0.152.
 */
package fuzs.resourcepackoverrides.client.util;

import fuzs.resourcepackoverrides.client.core.ClientAbstractions;
import fuzs.resourcepackoverrides.client.data.PackSelectionOverride;
import fuzs.resourcepackoverrides.client.data.ResourceOverridesManager;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;

public class ForwardingPackHelper {
    public static Pack copyAndOverride(Pack pack) {
        PackSelectionOverride override = ResourceOverridesManager.getOverride(pack.m_10446_());
        Component title = override.title() != null ? override.title() : pack.m_10429_();
        Component description = override.description() != null ? override.description() : pack.m_10442_();
        PackCompatibility compatibility = override.compatibility() != null ? override.compatibility() : pack.m_10443_();
        boolean required = override.required() != null ? override.required().booleanValue() : pack.m_10449_();
        boolean fixedPosition = override.fixedPosition() != null ? override.fixedPosition().booleanValue() : pack.m_10450_();
        Pack.Position defaultPosition = override.defaultPosition() != null ? override.defaultPosition() : pack.m_10451_();
        boolean hidden = override.hidden() != null ? override.hidden().booleanValue() : ClientAbstractions.INSTANCE.isPackHidden(pack);
        Pack.Info info = ForwardingPackHelper.rebuildPackInfo(pack, description, compatibility, hidden);
        return Pack.m_245512_((String)pack.m_10446_(), (Component)title, (boolean)required, id -> pack.m_10445_(), (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)defaultPosition, (boolean)fixedPosition, (PackSource)pack.m_10453_());
    }

    private static Pack.Info rebuildPackInfo(Pack pack, Component description, PackCompatibility compatibility, boolean hidden) {
        int packVersion = SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES);
        if (compatibility == PackCompatibility.TOO_OLD) {
            --packVersion;
        }
        if (compatibility == PackCompatibility.TOO_NEW) {
            ++packVersion;
        }
        return ClientAbstractions.INSTANCE.createPackInfo(description, packVersion, pack.m_245532_(), hidden);
    }
}

