/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.framework.api.event.EntityEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.event.IEntityEvent;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class KillMobChallenge
extends Challenge {
    public static final ResourceLocation ID = new ResourceLocation("backpacked", "kill_mob");
    public static final Serializer SERIALIZER = new Serializer();
    private final ProgressFormatter formatter;
    private final Optional<EntityPredicate> entity;
    private final Optional<ItemPredicate> item;
    private final int count;

    public KillMobChallenge(ProgressFormatter formatter, Optional<EntityPredicate> entity, Optional<ItemPredicate> item, int count) {
        super(ID);
        this.formatter = formatter;
        this.entity = entity;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ResourceLocation backpackId) {
        return new Tracker(this.count, this.formatter, this.entity, this.item);
    }

    public static final class Serializer
    extends ChallengeSerializer<KillMobChallenge> {
        @Override
        public KillMobChallenge deserialize(JsonObject object) {
            ProgressFormatter formatter = Serializer.readFormatter(object, ProgressFormatter.KILLED_X_OF_X);
            Optional<EntityPredicate> entity = object.has("mob") ? Optional.of(EntityPredicate.m_36614_((JsonElement)object.get("mob"))) : Optional.empty();
            Optional<ItemPredicate> item = object.has("item") ? Optional.of(ItemPredicate.m_45051_((JsonElement)object.get("item"))) : Optional.empty();
            int count = Serializer.readCount(object, 1);
            return new KillMobChallenge(formatter, entity, item, count);
        }
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<EntityPredicate> entityPredicate;
        private final Optional<ItemPredicate> itemPredicate;

        private Tracker(int maxCount, ProgressFormatter formatter, Optional<EntityPredicate> entityPredicate, Optional<ItemPredicate> itemPredicate) {
            super(maxCount, formatter);
            this.entityPredicate = entityPredicate;
            this.itemPredicate = itemPredicate;
        }

        private boolean test(LivingEntity entity, ItemStack stack, ServerPlayer player) {
            return this.entityPredicate.map(p -> p.m_36611_(player, (Entity)entity)).orElse(true) != false && this.itemPredicate.map(p -> p.m_45049_(stack)).orElse(true) != false;
        }

        public static void registerEvent() {
            EntityEvents.LIVING_ENTITY_DEATH.register((IFrameworkEvent)((IEntityEvent.LivingEntityDeath)(entity, source) -> {
                if (entity.m_9236_().m_5776_()) {
                    return false;
                }
                Entity cause = source.m_7639_();
                if (cause != null && cause.m_6095_() == EntityType.f_20532_) {
                    ServerPlayer player = (ServerPlayer)cause;
                    UnlockManager.getTrackers((Player)player, Tracker.class).forEach(tracker -> {
                        if (tracker.isComplete()) {
                            return;
                        }
                        ItemStack heldItem = player.m_21205_();
                        if (tracker.test(entity, heldItem, player)) {
                            tracker.increment(player);
                        }
                    });
                }
                return false;
            }));
        }
    }
}

