/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.platform.ClientServices;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class ShelfRenderer
implements BlockEntityRenderer<ShelfBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final Supplier<BakedModel> missingModel;

    public ShelfRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
        this.missingModel = () -> this.itemRenderer.m_115103_().m_109393_().m_119409_();
    }

    public void render(ShelfBlockEntity entity, float partialTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        ItemStack stack = entity.getBackpack();
        if (stack.m_41720_() != ModItems.BACKPACK.get()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        String modelName = tag.m_128461_("BackpackModel");
        Backpack backpack = BackpackManager.instance().getClientBackpackOrDefault(modelName);
        if (backpack == null) {
            return;
        }
        Direction facing = entity.getDirection();
        pose.m_85837_(0.5, 0.0, 0.5);
        pose.m_85837_(0.0, 0.001, 0.0);
        pose.m_252781_(facing.m_253075_());
        pose.m_85837_(-0.5, 0.0, -0.5);
        pose.m_85837_(0.5, -0.375, -0.3125);
        ModelMeta meta = BackpackManager.instance().getModelMeta(backpack);
        Vector3f offset = meta.shelfOffset();
        pose.m_85837_((double)offset.x * 0.0625, (double)offset.z * 0.0625, (double)(-offset.y) * 0.0625);
        pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        pose.m_85841_(1.0f, -1.0f, -1.0f);
        int animationTick = Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(player -> player.f_19797_).orElse(0);
        meta.renderer().ifPresentOrElse(renderer -> {
            pose.m_85836_();
            BackpackRenderContext context = new BackpackRenderContext(pose, buffer, light, stack, backpack, null, partialTick, animationTick, model -> this.itemRenderer.m_115143_(stack, ItemDisplayContext.NONE, false, pose, buffer, light, OverlayTexture.f_118083_, model));
            renderer.forEach(function -> function.apply(context));
            pose.m_85849_();
        }, () -> {
            BakedModel model = ClientServices.MODEL.getBakedModel(backpack.getBaseModel());
            this.itemRenderer.m_115143_(stack, ItemDisplayContext.NONE, false, pose, buffer, light, OverlayTexture.f_118083_, model);
        });
    }

    private BakedModel getModel(ResourceLocation location) {
        BakedModel model = ClientServices.MODEL.getBakedModel(location);
        return model != null ? model : this.missingModel.get();
    }
}

