/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.data.server;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.incubation.core.registry.IncubationBlocks;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class IncubationLootTableProvider
extends LootTableProvider {
    public IncubationLootTableProvider(PackOutput output) {
        super(output, BuiltInLootTables.m_78766_(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(IncubationBlockLoot::new, LootContextParamSets.f_81421_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
    }

    private static class IncubationBlockLoot
    extends BlockLootSubProvider {
        private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS));
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.f_50016_).map(ItemLike::m_5456_).collect(Collectors.toSet());

        protected IncubationBlockLoot() {
            super(EXPLOSION_RESISTANT, FeatureFlags.f_244280_.m_247355_());
        }

        public void m_245660_() {
            this.m_245724_((Block)IncubationBlocks.CHICKEN_EGG_CRATE.get());
            this.m_245724_((Block)IncubationBlocks.TURTLE_EGG_CRATE.get());
            this.m_245724_((Block)IncubationBlocks.HAY_NEST.get());
            this.m_246125_((Block)IncubationBlocks.HAY_CHICKEN_NEST.get(), (ItemLike)IncubationBlocks.HAY_NEST.get());
            this.m_246125_((Block)IncubationBlocks.HAY_DUCK_NEST.get(), (ItemLike)IncubationBlocks.HAY_NEST.get());
            this.m_246125_((Block)IncubationBlocks.HAY_TURKEY_NEST.get(), (ItemLike)IncubationBlocks.HAY_NEST.get());
            this.m_247577_((Block)IncubationBlocks.TWIG_NEST.get(), this.createTwigNestDrops((Block)IncubationBlocks.TWIG_NEST.get()));
            this.m_247577_((Block)IncubationBlocks.TWIG_CHICKEN_NEST.get(), this.createTwigNestDrops((Block)IncubationBlocks.TWIG_CHICKEN_NEST.get()));
            this.m_247577_((Block)IncubationBlocks.TWIG_DUCK_NEST.get(), this.createTwigNestDrops((Block)IncubationBlocks.TWIG_DUCK_NEST.get()));
            this.m_247577_((Block)IncubationBlocks.TWIG_TURKEY_NEST.get(), this.createTwigNestDrops((Block)IncubationBlocks.TWIG_TURKEY_NEST.get()));
        }

        protected static LootTable.Builder createShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> builder) {
            return IncubationBlockLoot.m_246900_((Block)block, (LootItemCondition.Builder)HAS_SHEARS, builder);
        }

        protected LootTable.Builder createTwigNestDrops(Block block) {
            return IncubationBlockLoot.createShearsDispatchTable((Block)IncubationBlocks.TWIG_NEST.get(), (LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))));
        }

        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block) != null && "incubation".equals(ForgeRegistries.BLOCKS.getKey(block).m_135827_())).collect(Collectors.toSet());
        }
    }
}

