/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.core;

import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import fuzs.forgeconfigscreens.core.NetworkingHelper;
import fuzs.forgeconfigscreens.core.WritableMessage;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class ForgeAbstractions
implements CommonAbstractions {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private final SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ForgeConfigScreens.id("play")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION)).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
    private final AtomicInteger discriminator = new AtomicInteger();

    @Override
    public Optional<String> getModDisplayName(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isClientEnvironment() {
        return FMLLoader.getDist().isClient();
    }

    @Override
    public Path getDefaultConfigPath() {
        return FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath());
    }

    @Override
    public void fireReloadingEvent(ModConfig modConfig) {
        try {
            Method fireEvent = ModConfig.class.getDeclaredMethod("fireEvent", IConfigEvent.class);
            fireEvent.setAccessible(true);
            MethodHandles.lookup().unreflect(fireEvent).invoke(modConfig, new ModConfigEvent.Reloading(modConfig));
        }
        catch (Throwable e) {
            ForgeConfigScreens.LOGGER.error("Unable to fire config reloading event for {}", (Object)modConfig.getFileName(), (Object)e);
        }
    }

    @Override
    public <T extends WritableMessage> void registerClientboundMessage(Class<T> clazz, Supplier<NetworkingHelper.ClientMessageListener<T>> listener) {
        this.registerMessage(clazz, (message, player) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer clientPlayer = minecraft.f_91074_;
            Objects.requireNonNull(clientPlayer, "player is null");
            ((NetworkingHelper.ClientMessageListener)listener.get()).handle(message, minecraft, clientPlayer.f_108617_, clientPlayer, minecraft.f_91073_);
        }, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <T extends WritableMessage> void registerServerboundMessage(Class<T> clazz, Supplier<NetworkingHelper.ServerMessageListener<T>> listener) {
        this.registerMessage(clazz, (message, player) -> {
            Objects.requireNonNull(player, "player is null");
            ((NetworkingHelper.ServerMessageListener)listener.get()).handle(message, ServerLifecycleHooks.getCurrentServer(), player.f_8906_, (ServerPlayer)player, player.m_284548_());
        }, NetworkDirection.PLAY_TO_SERVER);
    }

    private <T extends WritableMessage> void registerMessage(Class<T> clazz, BiConsumer<T, ServerPlayer> consumer, NetworkDirection networkDirection) {
        Function<FriendlyByteBuf, T> factory = CommonAbstractions.findMessageConstructor(clazz);
        this.channel.registerMessage(this.discriminator.getAndIncrement(), clazz, WritableMessage::write, factory, (message, supplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            context.enqueueWork(() -> consumer.accept(message, context.getSender()));
            context.setPacketHandled(true);
        }, Optional.of(networkDirection));
    }

    @Override
    public Packet<?> toClientboundPacket(WritableMessage message) {
        return this.channel.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public Packet<?> toServerboundPacket(WritableMessage message) {
        return this.channel.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    public void registerConfig(String modId, ModConfig.Type type, IConfigSpec<?> spec) {
        ModLoadingContext.get().registerConfig(type, spec);
    }

    @Override
    public void registerConfig(String modId, ModConfig.Type type, IConfigSpec<?> spec, String fileName) {
        ModLoadingContext.get().registerConfig(type, spec, fileName);
    }
}

