/*
 * Decompiled with CFR 0.152.
 */
package toni.chunkactivitytracker.data;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.LevelResource;
import toni.chunkactivitytracker.ChunkActivityTracker;
import toni.chunkactivitytracker.data.ChunkActivityInfo;
import toni.lib.networking.codecs.StreamCodec;

public class ChunkActivityMap
implements Serializable {
    public static ConcurrentHashMap<ResourceKey<Level>, ChunkActivityMap> instances = new ConcurrentHashMap();
    public static StreamCodec<ByteBuf, ChunkActivityMap> CODEC = new StreamCodec<ByteBuf, ChunkActivityMap>(){

        public ChunkActivityMap decode(ByteBuf buffer) {
            FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
            Map entries = buf.m_236847_(FriendlyByteBuf::readLong, a -> (ChunkActivityInfo)ChunkActivityInfo.CODEC.decode(a));
            String dimension = buf.m_130277_();
            return new ChunkActivityMap(entries, dimension);
        }

        public void encode(ByteBuf buffer, ChunkActivityMap map) {
            FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
            buf.m_236831_(map.chunks, FriendlyByteBuf::writeLong, (a, b) -> ChunkActivityInfo.CODEC.encode(a, b));
            buf.m_130070_(map.dimension);
        }
    };
    private final ConcurrentHashMap<Long, ChunkActivityInfo> chunks;
    private String dimension;

    public static void clear() {
        instances.clear();
        ChunkActivityTracker.LOGGER.info("Server stopping, clearing chunk activity tracking map.");
    }

    public static ChunkActivityMap getOrCreateChunkMap(ResourceKey<Level> level) {
        ChunkActivityMap map = instances.getOrDefault(level, null);
        if (map != null) {
            return map;
        }
        ChunkActivityMap ret = ChunkActivityMap.load(level);
        ret.save();
        instances.put(level, ret);
        return ret;
    }

    public static ChunkActivityInfo getChunkInfo(ResourceKey<Level> level, ChunkPos chunkPos) {
        ChunkActivityMap map = ChunkActivityMap.getOrCreateChunkMap(level);
        return map.chunks.getOrDefault(chunkPos.m_45588_(), null);
    }

    public static ChunkActivityInfo getOrCreateChunkInfo(LevelChunk chunk) {
        ResourceKey dimension = chunk.m_62953_().m_46472_();
        ChunkActivityInfo chunkInfo = ChunkActivityMap.getChunkInfo((ResourceKey<Level>)dimension, chunk.m_7697_());
        if (chunkInfo != null) {
            return chunkInfo;
        }
        ChunkActivityMap map = ChunkActivityMap.getOrCreateChunkMap((ResourceKey<Level>)dimension);
        chunkInfo = new ChunkActivityInfo(chunk);
        map.chunks.put(chunk.m_7697_().m_45588_(), chunkInfo);
        return chunkInfo;
    }

    public static ChunkActivityInfo createChunkInfo(ResourceKey<Level> dimension, LevelChunk chunk) {
        ChunkActivityMap map = ChunkActivityMap.getOrCreateChunkMap(dimension);
        ChunkActivityInfo chunkInfo = new ChunkActivityInfo(chunk);
        map.chunks.put(chunk.m_7697_().m_45588_(), chunkInfo);
        return chunkInfo;
    }

    public static ChunkActivityInfo createChunkInfo(ResourceKey<Level> level, ChunkPos chunk) {
        ChunkActivityMap map = ChunkActivityMap.getOrCreateChunkMap(level);
        ChunkActivityInfo chunkInfo = new ChunkActivityInfo(new HashMap<UUID, Long>(), new HashMap<UUID, Integer>(), null);
        map.chunks.put(chunk.m_45588_(), chunkInfo);
        return chunkInfo;
    }

    public ChunkActivityMap(Map<Long, ChunkActivityInfo> chunks, String dimension) {
        this.chunks = chunks != null ? new ConcurrentHashMap<Long, ChunkActivityInfo>(chunks) : new ConcurrentHashMap();
        this.dimension = dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        long startTime = System.currentTimeMillis();
        Path filePath = ChunkActivityMap.datafile(this.dimension);
        if (filePath == null) {
            ChunkActivityTracker.LOGGER.error("Could not get chunk activity data location!");
            return;
        }
        try (FileOutputStream fileOut = new FileOutputStream(filePath.toFile());
             GZIPOutputStream gzipOut = new GZIPOutputStream(fileOut);){
            ByteBuf buffer = Unpooled.buffer();
            try {
                CODEC.encode((Object)buffer, (Object)this);
                gzipOut.write(buffer.array(), buffer.readerIndex(), buffer.readableBytes());
                gzipOut.flush();
            }
            finally {
                buffer.release();
            }
        }
        catch (Exception e) {
            ChunkActivityTracker.LOGGER.error("Error when saving chunk activity info: " + e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        ChunkActivityTracker.LOGGER.info("Saving data for " + this.chunks.size() + " chunks for dimension '" + this.dimension + "' took " + (endTime - startTime) + " milliseconds");
    }

    /*
     * Exception decompiling
     */
    public static ChunkActivityMap load(ResourceKey<Level> dimension) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path datafile(String dimension) {
        Path dir = ChunkActivityTracker.getWorldPath(new LevelResource("chunk_activity_info/"));
        if (dir == null) {
            return null;
        }
        dir.toFile().mkdirs();
        return ChunkActivityTracker.getWorldPath(new LevelResource("chunk_activity_info/" + dimension + ".dat"));
    }

    @Generated
    public ConcurrentHashMap<Long, ChunkActivityInfo> getChunks() {
        return this.chunks;
    }

    @Generated
    public String getDimension() {
        return this.dimension;
    }
}

