/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.data;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.LanguageProvider;
import us.drullk.umbralskies.block.UmbralBlocks;
import us.drullk.umbralskies.item.UmbralItems;

public class UmbralLocaleData
extends LanguageProvider {
    public UmbralLocaleData(PackOutput output) {
        super(output, "umbral_skies", "en_us");
    }

    protected void addTranslations() {
        this.addBlock((Supplier)UmbralBlocks.SKYROOT_BANISTER, "Skyroot Banister");
        this.addBlock((Supplier)UmbralBlocks.HOLLOW_SKYROOT_LOG_HORIZONTAL, "Hollow Skyroot Log");
        this.addBlock((Supplier)UmbralBlocks.HOLLOW_SKYROOT_LOG_VERTICAL, "Hollow Skyroot Log");
        this.addBlock((Supplier)UmbralBlocks.HOLLOW_SKYROOT_LOG_CLIMBABLE, "Hollow Skyroot Log");
        this.addBlock((Supplier)UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_HORIZONTAL, "Hollow Golden Oak Log");
        this.addBlock((Supplier)UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_VERTICAL, "Hollow Golden Oak Log");
        this.addBlock((Supplier)UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_CLIMBABLE, "Hollow Golden Oak Log");
        this.addItem((Supplier)UmbralItems.NAGA_GLOVES, "Naga Scale Gloves");
        this.addItem((Supplier)UmbralItems.IRONWOOD_GLOVES, "Ironwood Gloves");
        this.addItem((Supplier)UmbralItems.FIERY_GLOVES, "Fiery Gloves");
        this.addItem((Supplier)UmbralItems.STEELEAF_GLOVES, "Steeleaf Gloves");
        this.addItem((Supplier)UmbralItems.KNIGHTMETAL_GLOVES, "Knightmetal Gauntlets");
        this.addItem((Supplier)UmbralItems.PHANTOM_GLOVES, "Phantom Gauntlets");
        this.addItem((Supplier)UmbralItems.ARCTIC_GLOVES, "Arctic Mittens");
        this.addItem((Supplier)UmbralItems.YETI_GLOVES, "Yeti Gloves");
        this.add("item.umbral_skies.phantom_gloves.desc", "Never drops on death");
        this.addItem((Supplier)UmbralItems.SLIDER_TROPHY, "Slider Trophy");
        this.addItem((Supplier)UmbralItems.VALKYRIE_QUEEN_TROPHY, "Valkyrie Queen Trophy");
        this.addItem((Supplier)UmbralItems.SUN_SPIRIT_TROPHY, "Sun Spirit Trophy");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralBlocks.SKYROOT_BANISTER, "A banister like those found from the Twilight Forest, however made of Skyroot wood.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.NAGA_GLOVES, "An accessory for Naga armor set.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.IRONWOOD_GLOVES, "An accessory for Ironwood armor set.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.FIERY_GLOVES, "An accessory for Fiery armor set.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.STEELEAF_GLOVES, "An accessory for Steeleaf armor set.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.KNIGHTMETAL_GLOVES, "An accessory for Knightmetal armor set.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.PHANTOM_GLOVES, "An accessory for Phantom armor set.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.ARCTIC_GLOVES, "An accessory for Arctic armor set.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.YETI_GLOVES, "An accessory for Yeti armor set.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.SLIDER_TROPHY, "The trophy from the Slider, who sleeps inside the Bronze Dungeon.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.VALKYRIE_QUEEN_TROPHY, "The trophy from the Valkyrie Queen, who rules the Silver Dungeon.");
        this.makeAetherLore((Supplier<? extends ItemLike>)UmbralItems.SUN_SPIRIT_TROPHY, "The trophy from the Sun Spirit, who resides within the Gold Dungeon.");
        this.add("itemGroup.umbral_skies", "Umbral Skies");
    }

    private void makeAetherLore(Supplier<? extends ItemLike> item, String text) {
        this.add("lore." + item.get().m_5456_().m_5524_(), text);
    }
}

