/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.data;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import us.drullk.umbralskies.data.UmbralBlockStateModels;
import us.drullk.umbralskies.data.UmbralDataPack;
import us.drullk.umbralskies.data.UmbralItemModels;
import us.drullk.umbralskies.data.UmbralLocaleData;
import us.drullk.umbralskies.data.UmbralLoot;
import us.drullk.umbralskies.data.UmbralLootModifiers;
import us.drullk.umbralskies.data.UmbralRecipes;
import us.drullk.umbralskies.data.UmbralTags;

public class UmbralData {
    public static void generateData(GatherDataEvent event) {
        boolean isServer = event.includeServer();
        boolean isClient = event.includeClient();
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(isClient, (DataProvider)new UmbralLocaleData(output));
        generator.addProvider(isClient, (DataProvider)new UmbralBlockStateModels(output, existingFileHelper));
        generator.addProvider(isClient, (DataProvider)new UmbralItemModels(output, existingFileHelper));
        UmbralTags.UmbralBlockTags blockTags = new UmbralTags.UmbralBlockTags(output, provider, existingFileHelper);
        generator.addProvider(isServer, (DataProvider)blockTags);
        generator.addProvider(isServer, (DataProvider)new UmbralTags.UmbralItemTags(output, provider, blockTags.m_274426_(), existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new DatapackBuiltinEntriesProvider(output, provider, UmbralDataPack.DATA_BUILDER, Collections.singleton("umbral_skies")));
        generator.addProvider(isServer, (DataProvider)new UmbralTags.UmbralPlacedFeatureTags(output, (CompletableFuture<HolderLookup.Provider>)provider.thenApply(p -> UmbralDataPack.DATA_BUILDER.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), p)), existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new UmbralRecipes(output));
        generator.addProvider(isServer, (DataProvider)new UmbralLootModifiers(output));
        generator.addProvider(isServer, (DataProvider)new UmbralLoot(output));
    }
}

