/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.data;

import com.aetherteam.aether.block.AetherBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.TwilightForestMod;
import twilightforest.block.BanisterBlock;
import twilightforest.block.HollowLogClimbable;
import twilightforest.block.HollowLogHorizontal;
import twilightforest.block.HollowLogVertical;
import twilightforest.enums.BanisterShape;
import twilightforest.enums.HollowLogVariants;
import us.drullk.umbralskies.UmbralKeys;
import us.drullk.umbralskies.block.UmbralBlocks;

public class UmbralBlockStateModels
extends BlockStateProvider {
    private static final ResourceLocation CUTOUT = new ResourceLocation("cutout");

    public UmbralBlockStateModels(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "umbral_skies", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.banister((BanisterBlock)UmbralBlocks.SKYROOT_BANISTER.get(), UmbralKeys.SKYROOT_BANISTER_TEX, "skyroot");
        BlockModelProvider models = this.models();
        ModelFile.ExistingModelFile horizontalHollowLog = models.getExistingFile(TwilightForestMod.prefix((String)"horizontal_hollow_log"));
        ModelFile.ExistingModelFile hollowLogMossGrass = models.getExistingFile(TwilightForestMod.prefix((String)"hollow_log_moss_grass"));
        ModelFile.ExistingModelFile hollowLogMoss = models.getExistingFile(TwilightForestMod.prefix((String)"hollow_log_moss"));
        ModelFile.ExistingModelFile hollowLogSnow = models.getExistingFile(TwilightForestMod.prefix((String)"hollow_log_snow"));
        ModelFile.ExistingModelFile verticalHollowLog = models.getExistingFile(TwilightForestMod.prefix((String)"vertical_hollow_log"));
        ModelFile.ExistingModelFile verticalHollowLogVine = models.getExistingFile(TwilightForestMod.prefix((String)"vertical_hollow_log_vine"));
        ModelFile.ExistingModelFile verticalHollowLogLadder = models.getExistingFile(TwilightForestMod.prefix((String)"vertical_hollow_log_ladder"));
        this.aetherHollowLogs((RegistryObject<RotatedPillarBlock>)AetherBlocks.SKYROOT_LOG, (RegistryObject<RotatedPillarBlock>)AetherBlocks.STRIPPED_SKYROOT_LOG, UmbralBlocks.HOLLOW_SKYROOT_LOG_HORIZONTAL, UmbralBlocks.HOLLOW_SKYROOT_LOG_VERTICAL, UmbralBlocks.HOLLOW_SKYROOT_LOG_CLIMBABLE, (ModelFile)horizontalHollowLog, (ModelFile)hollowLogMossGrass, (ModelFile)hollowLogMoss, (ModelFile)hollowLogSnow, (ModelFile)verticalHollowLog, (ModelFile)verticalHollowLogVine, (ModelFile)verticalHollowLogLadder);
        this.aetherHollowLogs((RegistryObject<RotatedPillarBlock>)AetherBlocks.GOLDEN_OAK_LOG, (RegistryObject<RotatedPillarBlock>)AetherBlocks.STRIPPED_SKYROOT_LOG, new ResourceLocation("aether", "block/natural/skyroot_log_top"), UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_HORIZONTAL, UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_VERTICAL, UmbralBlocks.HOLLOW_GOLDEN_OAK_LOG_CLIMBABLE, (ModelFile)horizontalHollowLog, (ModelFile)hollowLogMossGrass, (ModelFile)hollowLogMoss, (ModelFile)hollowLogSnow, (ModelFile)verticalHollowLog, (ModelFile)verticalHollowLogVine, (ModelFile)verticalHollowLogLadder);
    }

    private void banister(BanisterBlock banister, ResourceLocation tex0, String woodName) {
        this.getVariantBuilder((Block)banister).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BanisterBlock.f_54117_);
            int yRot = (int)facing.m_122435_();
            String extended = (Boolean)state.m_61143_((Property)BanisterBlock.EXTENDED) != false ? "_extended" : "";
            String variant = ((BanisterShape)state.m_61143_((Property)BanisterBlock.SHAPE)).m_7912_() + extended;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("block/" + this.getBlockName((Block)banister) + "_" + variant, TwilightForestMod.prefix((String)("banister_" + variant)))).texture("texture", tex0)).rotationY(yRot).build();
        }, new Property[]{BanisterBlock.WATERLOGGED});
    }

    private void aetherHollowLogs(RegistryObject<RotatedPillarBlock> originalLog, RegistryObject<RotatedPillarBlock> strippedLog, RegistryObject<HollowLogHorizontal> horizontalHollowLog, RegistryObject<HollowLogVertical> verticalHollowLog, RegistryObject<HollowLogClimbable> climbableHollowLog, ModelFile emptyLog, ModelFile mossLog, ModelFile grassLog, ModelFile snowLog, ModelFile hollowLog, ModelFile vineLog, ModelFile ladderLog) {
        this.aetherHollowLogs(originalLog, strippedLog, new ResourceLocation("aether", "block/natural/" + originalLog.getId().m_135815_() + "_top"), horizontalHollowLog, verticalHollowLog, climbableHollowLog, emptyLog, mossLog, grassLog, snowLog, hollowLog, vineLog, ladderLog);
    }

    private void aetherHollowLogs(RegistryObject<RotatedPillarBlock> originalLog, RegistryObject<RotatedPillarBlock> strippedLog, ResourceLocation top, RegistryObject<HollowLogHorizontal> horizontalHollowLog, RegistryObject<HollowLogVertical> verticalHollowLog, RegistryObject<HollowLogClimbable> climbableHollowLog, ModelFile emptyLog, ModelFile mossLog, ModelFile grassLog, ModelFile snowLog, ModelFile hollowLog, ModelFile vineLog, ModelFile ladderLog) {
        ResourceLocation side = new ResourceLocation("aether", "block/natural/" + originalLog.getId().m_135815_());
        ResourceLocation inner = new ResourceLocation("aether", "block/natural/" + strippedLog.getId().m_135815_());
        this.getVariantBuilder((Block)horizontalHollowLog.get()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            return builder.modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)(switch ((HollowLogVariants.Horizontal)state.m_61143_((Property)HollowLogHorizontal.VARIANT)) {
                case HollowLogVariants.Horizontal.MOSS -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(horizontalHollowLog.getId().m_135815_() + "_moss")).parent(mossLog);
                case HollowLogVariants.Horizontal.MOSS_AND_GRASS -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(horizontalHollowLog.getId().m_135815_() + "_moss_grass")).parent(grassLog);
                case HollowLogVariants.Horizontal.SNOW -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(horizontalHollowLog.getId().m_135815_() + "_snow")).parent(snowLog);
                default -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(horizontalHollowLog.getId().m_135815_())).parent(emptyLog);
            }).renderType(CUTOUT)).texture("top", top)).texture("side", side)).texture("inner", inner)).rotationY(state.m_61143_((Property)HollowLogHorizontal.HORIZONTAL_AXIS) == Direction.Axis.X ? 90 : 0).build();
        });
        this.simpleBlock((Block)verticalHollowLog.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(verticalHollowLog.getId().m_135815_())).parent(hollowLog)).texture("top", top)).texture("side", side)).texture("inner", inner));
        this.getVariantBuilder((Block)climbableHollowLog.get()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            return builder.modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)(switch ((HollowLogVariants.Climbable)state.m_61143_((Property)HollowLogClimbable.VARIANT)) {
                default -> throw new IncompatibleClassChangeError();
                case HollowLogVariants.Climbable.VINE -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(climbableHollowLog.getId().m_135815_() + "_vine")).parent(vineLog);
                case HollowLogVariants.Climbable.LADDER, HollowLogVariants.Climbable.LADDER_WATERLOGGED -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(climbableHollowLog.getId().m_135815_() + "_ladder")).parent(ladderLog);
            }).renderType(CUTOUT)).texture("top", top)).texture("side", side)).texture("inner", inner)).rotationY((int)((Direction)state.m_61143_((Property)HollowLogClimbable.f_54117_)).m_122435_()).uvLock(true).build();
        });
    }

    private String getBlockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }
}

