/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.client.renderer;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.client.TFClientEvents;
import us.drullk.umbralskies.UmbralSkies;
import us.drullk.umbralskies.client.renderer.RenderWithoutEntity;
import us.drullk.umbralskies.client.renderer.SliderTrophyRenderer;
import us.drullk.umbralskies.client.renderer.SunSpiritTrophyRenderer;
import us.drullk.umbralskies.client.renderer.ValkyrieQueenTrophyRenderer;
import us.drullk.umbralskies.item.UmbralItems;

public class UmbralWithoutLevelRenderer
extends BlockEntityWithoutLevelRenderer {
    private final SliderTrophyRenderer sliderTrophyRenderer;
    private final ValkyrieQueenTrophyRenderer valkyrieQueenTrophyRenderer;
    private final SunSpiritTrophyRenderer sunSpiritTrophyRenderer;
    private final ModelResourceLocation bronzeBackplate = new ModelResourceLocation(UmbralSkies.prefix("trophy_bronze"), "inventory");
    private final ModelResourceLocation silverBackplate = new ModelResourceLocation(TwilightForestMod.prefix((String)"trophy_minor"), "inventory");
    private final ModelResourceLocation goldBackplate = new ModelResourceLocation(TwilightForestMod.prefix((String)"trophy"), "inventory");
    private static final Supplier<UmbralWithoutLevelRenderer> INSTANCE = Suppliers.memoize(() -> new UmbralWithoutLevelRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));
    public static final IClientItemExtensions ITEM_EXTENSION = (IClientItemExtensions)Util.m_137537_(() -> new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return INSTANCE.get();
        }
    });

    private UmbralWithoutLevelRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
        this.sliderTrophyRenderer = new SliderTrophyRenderer(modelSet);
        this.valkyrieQueenTrophyRenderer = new ValkyrieQueenTrophyRenderer(modelSet);
        this.sunSpiritTrophyRenderer = new SunSpiritTrophyRenderer(modelSet);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext context, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (stack.m_150930_((Item)UmbralItems.SLIDER_TROPHY.get())) {
            UmbralWithoutLevelRenderer.render(stack, context, poseStack, bufferSource, packedLight, packedOverlay, this.sliderTrophyRenderer, this.bronzeBackplate);
        } else if (stack.m_150930_((Item)UmbralItems.VALKYRIE_QUEEN_TROPHY.get())) {
            UmbralWithoutLevelRenderer.render(stack, context, poseStack, bufferSource, packedLight, packedOverlay, this.valkyrieQueenTrophyRenderer, this.silverBackplate);
        } else if (stack.m_150930_((Item)UmbralItems.SUN_SPIRIT_TROPHY.get())) {
            UmbralWithoutLevelRenderer.render(stack, context, poseStack, bufferSource, packedLight, packedOverlay, this.sunSpiritTrophyRenderer, this.goldBackplate);
        }
    }

    private static void render(ItemStack stack, ItemDisplayContext context, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, RenderWithoutEntity withoutEntity, ModelResourceLocation backplateLocation) {
        poseStack.m_85836_();
        if (context == ItemDisplayContext.GUI) {
            poseStack.m_85836_();
            BakedModel backplate = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(backplateLocation);
            poseStack.m_252880_(0.5f, 0.5f, -1.5f);
            MultiBufferSource.BufferSource bufferSourceMain = Minecraft.m_91087_().m_91269_().m_110104_();
            Lighting.m_84930_();
            Minecraft.m_91087_().m_91291_().m_115143_(stack, context, false, poseStack, (MultiBufferSource)bufferSourceMain, 0xF000F0, OverlayTexture.f_118083_, backplate.applyTransform(context, poseStack, false));
            bufferSourceMain.m_109911_();
            Lighting.m_84931_();
            poseStack.m_85849_();
            poseStack.m_252880_(0.5f, 0.5f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
            poseStack.m_252781_(Axis.f_252392_.m_252977_((Boolean)TFConfig.CLIENT_CONFIG.rotateTrophyHeadsGui.get() != false ? TFClientEvents.rotationTicker : -45.0f));
            poseStack.m_252880_(-0.5f, -0.25f, -0.5f);
        }
        withoutEntity.render(poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.m_85849_();
    }
}

