/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.client;

import com.aetherteam.aether.client.renderer.accessory.GlovesRenderer;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import twilightforest.compat.curios.renderer.CurioHeadRenderer;
import us.drullk.umbralskies.UmbralSkies;
import us.drullk.umbralskies.block.UmbralBlocks;
import us.drullk.umbralskies.client.renderer.EmissiveGlovesRenderer;
import us.drullk.umbralskies.client.renderer.SliderTrophyRenderer;
import us.drullk.umbralskies.client.renderer.SunSpiritTrophyRenderer;
import us.drullk.umbralskies.client.renderer.ValkyrieQueenTrophyRenderer;
import us.drullk.umbralskies.item.AetherTrophyItem;
import us.drullk.umbralskies.item.UmbralItems;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class UmbralClient {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)UmbralBlocks.SLIDER_TROPHY_ENTITY.get()), SliderTrophyRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)UmbralBlocks.VALKYRIE_TROPHY_ENTITY.get()), ValkyrieQueenTrophyRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)UmbralBlocks.SUN_SPIRIT_TROPHY_ENTITY.get()), SunSpiritTrophyRenderer::new);
        UmbralClient.registerCuriosRenderers();
    }

    @SubscribeEvent
    public static void registerExtraModels(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)new ModelResourceLocation(UmbralSkies.prefix("trophy_bronze"), "inventory"));
    }

    private static void registerCuriosRenderers() {
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.NAGA_GLOVES.get()), GlovesRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.IRONWOOD_GLOVES.get()), GlovesRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.FIERY_GLOVES.get()), EmissiveGlovesRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.STEELEAF_GLOVES.get()), GlovesRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.KNIGHTMETAL_GLOVES.get()), GlovesRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.PHANTOM_GLOVES.get()), GlovesRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.ARCTIC_GLOVES.get()), GlovesRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.YETI_GLOVES.get()), GlovesRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.SLIDER_TROPHY.get()), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.VALKYRIE_QUEEN_TROPHY.get()), CurioHeadRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)UmbralItems.SUN_SPIRIT_TROPHY.get()), CurioHeadRenderer::new);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void renderLiving(RenderLivingEvent<?, ?> event) {
            ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
            if (!Events.stackIsTrophy(stack) && !Events.isWearingTrophyCurio(event)) {
                return;
            }
            EntityModel entityModel = event.getRenderer().m_7200_();
            if (!(entityModel instanceof HeadedModel)) {
                return;
            }
            HeadedModel headedModel = (HeadedModel)entityModel;
            headedModel.m_5585_().f_104207_ = false;
            if (!(headedModel instanceof HumanoidModel)) {
                return;
            }
            HumanoidModel humanoidModel = (HumanoidModel)headedModel;
            humanoidModel.f_102809_.f_104207_ = false;
        }

        private static boolean stackIsTrophy(ItemStack stack) {
            return stack.m_41720_() instanceof AetherTrophyItem;
        }

        private static boolean isWearingTrophyCurio(RenderLivingEvent<?, ?> event) {
            Optional slot = CuriosApi.getCuriosHelper().findFirstCurio(event.getEntity(), Events::stackIsTrophy);
            return slot.isPresent() && ((SlotResult)slot.get()).slotContext() != null && ((SlotResult)slot.get()).slotContext().visible();
        }
    }
}

