/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.umbralskies.block;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.block.BanisterBlock;
import twilightforest.block.HollowLogClimbable;
import twilightforest.block.HollowLogHorizontal;
import twilightforest.block.HollowLogVertical;
import twilightforest.item.HollowLogItem;
import us.drullk.umbralskies.UmbralSkies;
import us.drullk.umbralskies.block.FloorAetherTrophyBlock;
import us.drullk.umbralskies.block.WallAetherTrophyBlock;
import us.drullk.umbralskies.block.entity.AetherTrophyEntity;

public class UmbralBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"umbral_skies");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"umbral_skies");
    public static final RegistryObject<BanisterBlock> SKYROOT_BANISTER = BLOCKS.register("skyroot_banister", () -> new BanisterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<HollowLogHorizontal> HOLLOW_SKYROOT_LOG_HORIZONTAL = BLOCKS.register("hollow_skyroot_log_horizontal", () -> new HollowLogHorizontal(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283819_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_()));
    public static final RegistryObject<HollowLogVertical> HOLLOW_SKYROOT_LOG_VERTICAL = BLOCKS.register("hollow_skyroot_log_vertical", () -> new HollowLogVertical(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_(), HOLLOW_SKYROOT_LOG_CLIMBABLE));
    public static final RegistryObject<HollowLogClimbable> HOLLOW_SKYROOT_LOG_CLIMBABLE = BLOCKS.register("hollow_skyroot_log_climbable", () -> new HollowLogClimbable(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_(), HOLLOW_SKYROOT_LOG_VERTICAL));
    public static final RegistryObject<HollowLogHorizontal> HOLLOW_GOLDEN_OAK_LOG_HORIZONTAL = BLOCKS.register("hollow_golden_oak_log_horizontal", () -> new HollowLogHorizontal(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283819_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_()));
    public static final RegistryObject<HollowLogVertical> HOLLOW_GOLDEN_OAK_LOG_VERTICAL = BLOCKS.register("hollow_golden_oak_log_vertical", () -> new HollowLogVertical(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_(), HOLLOW_GOLDEN_OAK_LOG_CLIMBABLE));
    public static final RegistryObject<HollowLogClimbable> HOLLOW_GOLDEN_OAK_LOG_CLIMBABLE = BLOCKS.register("hollow_golden_oak_log_climbable", () -> new HollowLogClimbable(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_(), HOLLOW_GOLDEN_OAK_LOG_VERTICAL));
    public static final RegistryObject<FloorAetherTrophyBlock> SLIDER_TROPHY_BLOCK = BLOCKS.register("slider_trophy", () -> new FloorAetherTrophyBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_278166_(PushReaction.DESTROY), (Supplier<BlockEntityType<AetherTrophyEntity>>)SLIDER_TROPHY_ENTITY));
    public static final RegistryObject<FloorAetherTrophyBlock> VALKYRIE_QUEEN_TROPHY_BLOCK = BLOCKS.register("valkyrie_queen_trophy", () -> new FloorAetherTrophyBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_278166_(PushReaction.DESTROY), (Supplier<BlockEntityType<AetherTrophyEntity>>)VALKYRIE_TROPHY_ENTITY));
    public static final RegistryObject<FloorAetherTrophyBlock> SUN_SPIRIT_TROPHY_BLOCK = BLOCKS.register("sun_spirit_trophy", () -> new FloorAetherTrophyBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_278166_(PushReaction.DESTROY), (Supplier<BlockEntityType<AetherTrophyEntity>>)SUN_SPIRIT_TROPHY_ENTITY));
    public static final RegistryObject<WallAetherTrophyBlock> SLIDER_WALL_TROPHY_BLOCK = BLOCKS.register("slider_wall_trophy", () -> new WallAetherTrophyBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_278166_(PushReaction.DESTROY), (Supplier<BlockEntityType<AetherTrophyEntity>>)SLIDER_TROPHY_ENTITY));
    public static final RegistryObject<WallAetherTrophyBlock> VALKYRIE_WALL_QUEEN_TROPHY_BLOCK = BLOCKS.register("valkyrie_queen_wall_trophy", () -> new WallAetherTrophyBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.DESTROY).m_60966_(), (Supplier<BlockEntityType<AetherTrophyEntity>>)VALKYRIE_TROPHY_ENTITY));
    public static final RegistryObject<WallAetherTrophyBlock> SUN_SPIRIT_WALL_TROPHY_BLOCK = BLOCKS.register("sun_spirit_wall_trophy", () -> new WallAetherTrophyBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_278166_(PushReaction.DESTROY), (Supplier<BlockEntityType<AetherTrophyEntity>>)SUN_SPIRIT_TROPHY_ENTITY));
    public static final RegistryObject<BlockEntityType<AetherTrophyEntity>> SLIDER_TROPHY_ENTITY = BLOCK_ENTITIES.register("slider_trophy", () -> BlockEntityType.Builder.m_155273_(AetherTrophyEntity::slider, (Block[])new Block[]{(Block)SLIDER_TROPHY_BLOCK.get(), (Block)SLIDER_WALL_TROPHY_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<AetherTrophyEntity>> VALKYRIE_TROPHY_ENTITY = BLOCK_ENTITIES.register("valkyrie_queen_trophy", () -> BlockEntityType.Builder.m_155273_(AetherTrophyEntity::valkyrie, (Block[])new Block[]{(Block)VALKYRIE_QUEEN_TROPHY_BLOCK.get(), (Block)VALKYRIE_WALL_QUEEN_TROPHY_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<AetherTrophyEntity>> SUN_SPIRIT_TROPHY_ENTITY = BLOCK_ENTITIES.register("sun_spirit_trophy", () -> BlockEntityType.Builder.m_155273_(AetherTrophyEntity::sunSpirit, (Block[])new Block[]{(Block)SUN_SPIRIT_TROPHY_BLOCK.get(), (Block)SUN_SPIRIT_WALL_TROPHY_BLOCK.get()}).m_58966_(null));

    public static void registerItemsForBlocks(RegisterEvent event) {
        if (!ForgeRegistries.ITEMS.equals(event.getForgeRegistry())) {
            return;
        }
        UmbralBlocks.registerItemFromBlock(event, SKYROOT_BANISTER);
        UmbralBlocks.registerItem(event, UmbralSkies.prefix("hollow_skyroot_log"), () -> new HollowLogItem(HOLLOW_SKYROOT_LOG_HORIZONTAL, HOLLOW_SKYROOT_LOG_VERTICAL, HOLLOW_SKYROOT_LOG_CLIMBABLE, new Item.Properties()));
        UmbralBlocks.registerItem(event, UmbralSkies.prefix("hollow_golden_oak_log"), () -> new HollowLogItem(HOLLOW_GOLDEN_OAK_LOG_HORIZONTAL, HOLLOW_GOLDEN_OAK_LOG_VERTICAL, HOLLOW_GOLDEN_OAK_LOG_CLIMBABLE, new Item.Properties()));
    }

    private static void registerItemFromBlock(RegisterEvent event, RegistryObject<? extends Block> block) {
        event.register(ForgeRegistries.Keys.ITEMS, helper -> helper.register(block.getId(), (Object)new BlockItem((Block)block.get(), new Item.Properties())));
    }

    private static void registerItem(RegisterEvent event, ResourceLocation name, Supplier<Item> item) {
        event.register(ForgeRegistries.Keys.ITEMS, name, item);
    }
}

