/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.PayloadHandler;
import dev.terminalmc.clientsort.network.handler.validate.PolicyManager;
import dev.terminalmc.clientsort.network.handler.validate.SchemaValidator;
import dev.terminalmc.clientsort.network.payload.TransferPayload;
import dev.terminalmc.clientsort.network.payload.TransferResultPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TransferHandler
extends PayloadHandler {
    private TransferHandler() {
    }

    public static void handle(TransferPayload payload, MinecraftServer server, ServerPlayer player) {
        server.execute(() -> TransferHandler.processPayload(server, player, payload.srcContainerId(), menu -> TransferHandler.checkPolicy(menu, payload.srcSlotIds(), payload.dstSlotIds()), menu -> {
            SchemaValidator.validateSlotArray(player, menu, payload.srcSlotIds());
            SchemaValidator.validateSlotArray(player, menu, payload.dstSlotIds());
        }, menu -> TransferHandler.transfer(server, menu, payload.srcSlotIds(), payload.dstSlotIds()), TransferPayload.ID, TransferResultPayload.ID, (result, message) -> new TransferResultPayload(result.code, (String)message)));
    }

    private static void transfer(MinecraftServer server, AbstractContainerMenu menu, int[] srcSlotIds, int[] dstSlotIds) throws PayloadHandlerException {
        block0: for (int i = srcSlotIds.length - 1; i >= 0; --i) {
            ItemStack expected;
            ItemStack dstStackCopy;
            ItemStack dstStack;
            Slot dstSlot;
            int srcSlotId = srcSlotIds[i];
            Slot srcSlot = (Slot)menu.f_38839_.get(srcSlotId);
            ItemStack srcStack = srcSlot.m_7993_();
            ItemStack srcStackCopy = srcStack.m_41777_();
            if (srcStack.m_41619_()) continue;
            for (int dstSlotId : dstSlotIds) {
                dstSlot = (Slot)menu.f_38839_.get(dstSlotId);
                dstStack = dstSlot.m_7993_();
                dstStackCopy = dstStack.m_41777_();
                if (dstStack.m_41619_() || dstStack.m_41613_() >= dstSlot.m_5866_(dstStack) || !ItemStack.m_150942_((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                expected = srcStack.m_255036_(Math.min(srcStack.m_41613_() + dstStack.m_41613_(), dstSlot.m_5866_(dstStack)));
                dstSlot.m_150659_(srcStack);
                TransferHandler.validate(server, expected, dstSlot.m_7993_(), () -> String.format("Transfer operation failed to safe-insert from slot %d with item '%s' to slot %d with item '%s'", srcSlotId, srcStackCopy, dstSlotId, dstStackCopy), msg -> TransferHandler.setPolicy(menu, dstSlotIds, msg));
                if (srcStack.m_41619_()) break;
            }
            if (srcStack.m_41619_()) continue;
            for (int dstSlotId : dstSlotIds) {
                dstSlot = (Slot)menu.f_38839_.get(dstSlotId);
                dstStack = dstSlot.m_7993_();
                dstStackCopy = dstStack.m_41777_();
                if (!dstStack.m_41619_()) continue;
                expected = srcStack.m_255036_(Math.min(srcStack.m_41613_(), dstSlot.m_5866_(srcStack)));
                dstSlot.m_150659_(srcStack);
                TransferHandler.validate(server, expected, dstSlot.m_7993_(), () -> String.format("Transfer operation failed to safe-insert from slot %d with item '%s' to slot %d with item '%s'", srcSlotId, srcStackCopy, dstSlotId, dstStackCopy), msg -> TransferHandler.setPolicy(menu, dstSlotIds, msg));
                continue block0;
            }
        }
    }

    private static void checkPolicy(AbstractContainerMenu menu, int[] srcSlotIds, int[] dstSlotIds) throws PayloadHandlerException.UnsupportedOpException {
        Container srcContainer = srcSlotIds.length > 0 ? ((Slot)menu.f_38839_.get((int)srcSlotIds[0])).f_40218_ : null;
        Object srcObject = ClientSort.getObj(srcContainer, menu);
        if (srcObject == null) {
            throw new PayloadHandlerException.UnsupportedOpException("Reference src object is null for inputs '%s', '%s'!".formatted(srcContainer == null ? "null" : srcContainer.getClass().getName(), menu == null ? "null" : menu.getClass().getName()));
        }
        Container dstContainer = dstSlotIds.length > 0 ? ((Slot)menu.f_38839_.get((int)dstSlotIds[0])).f_40218_ : null;
        Object dstObject = ClientSort.getObj(dstContainer, menu);
        if (dstObject == null) {
            throw new PayloadHandlerException.UnsupportedOpException("Reference dst object is null for inputs '%s', '%s'!".formatted(dstContainer == null ? "null" : dstContainer.getClass().getName(), menu == null ? "null" : menu.getClass().getName()));
        }
        PolicyManager.checkPolicy(srcObject.getClass(), bl -> bl.transferEnabled);
        PolicyManager.checkPolicy(dstObject.getClass(), bl -> bl.transferEnabled);
    }

    private static void setPolicy(AbstractContainerMenu menu, int[] dstSlotIds, String message) {
        Container dstContainer = dstSlotIds.length > 0 ? ((Slot)menu.f_38839_.get((int)dstSlotIds[0])).f_40218_ : null;
        Object object = ClientSort.getObj(dstContainer, menu);
        if (object == null) {
            ClientSort.LOG.warn("Could not set policy: reference object is null for inputs '{}', '{}'!", dstContainer == null ? "null" : dstContainer.getClass().getName(), menu == null ? "null" : menu.getClass().getName());
            return;
        }
        PolicyManager.setPolicy(new ServerClassPolicy(object.getClass().getName(), true, true, false), TransferPayload.ID.toString(), message);
    }
}

