/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.components;

import fuzs.easyanvils.client.gui.components.OpenEditBox;
import org.jetbrains.annotations.Nullable;

public class TypeActionManager {
    private static final int MAX_STATES = 100;
    private final TypeState[] states = new TypeState[100];
    private int start;
    private int end;
    private int index;

    public void trySave(OpenEditBox editBox) {
    }

    public void undo(OpenEditBox editBox) {
    }

    public void redo(OpenEditBox editBox) {
    }

    @Nullable
    public TypeState pull() {
        if (this.index == this.end) {
            return null;
        }
        this.index = TypeActionManager.cycleIndex(this.index, 1);
        return this.states[this.index];
    }

    public void push(TypeState typeState) {
        this.states[this.index] = typeState;
        this.index = this.end = TypeActionManager.cycleIndex(this.index, 1);
        if (this.start == this.end) {
            this.start = TypeActionManager.cycleIndex(this.start, 1);
        }
    }

    @Nullable
    public TypeState pop(OpenEditBox editBox) {
        if (this.start == this.index) {
            return null;
        }
        this.index = TypeActionManager.cycleIndex(this.index, -1);
        TypeState state = this.states[this.index];
        if (state != null && state.equals(TypeState.from(editBox))) {
            return this.pop(editBox);
        }
        return state;
    }

    public TypeState peek() {
        if (this.start == this.index) {
            return TypeState.EMPTY;
        }
        return this.states[TypeActionManager.cycleIndex(this.index, -1)];
    }

    private static int cycleIndex(int index, int adjustment) {
        return ((index + adjustment) % 100 + 100) % 100;
    }

    private record TypeState(String value, int displayPos, int cursorPos, int highlightPos) {
        public static final TypeState EMPTY = new TypeState("", 0, 0, 0);

        private static TypeState from(OpenEditBox editBox) {
            return new TypeState(editBox.value, editBox.displayPos, editBox.cursorPos, editBox.highlightPos);
        }

        boolean hasChanged(TypeState other) {
            return other == null || !this.value.equals(other.value);
        }

        boolean hasChangedSignificantly(TypeState other) {
            if (other == null) {
                return true;
            }
            if (this.value.equals(other.value)) {
                return false;
            }
            int valueDiff = this.value.length() - other.value.length();
            int cursorDiff = this.cursorPos - other.cursorPos;
            int highlightDiff = this.highlightPos - other.highlightPos;
            return valueDiff != cursorDiff || cursorDiff != highlightDiff;
        }

        void apply(OpenEditBox editBox) {
            editBox.value = this.value;
            editBox.displayPos = this.displayPos;
            editBox.cursorPos = this.cursorPos;
            editBox.highlightPos = this.highlightPos;
        }
    }
}

