/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.abridged.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.abridged.config.ConfigHandler;
import dev.worldgen.abridged.registry.AbridgedRegistries;
import dev.worldgen.abridged.worldgen.structure.BridgeConfig;
import dev.worldgen.abridged.worldgen.structure.BridgePiece;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class BridgeStructure
extends Structure {
    public static final MapCodec<BridgeStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BridgeStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)Codec.INT.fieldOf("max_chunk_radius").forGetter(BridgeStructure::maxChunkRadius)).apply((Applicative)instance, BridgeStructure::new));
    private final int maxChunkRadius;

    protected BridgeStructure(Structure.StructureSettings baseSettings, int maxChunkRadius) {
        super(baseSettings);
        this.maxChunkRadius = maxChunkRadius;
    }

    public int maxChunkRadius() {
        return this.maxChunkRadius;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (context.f_226626_().m_188501_() > ConfigHandler.state().frequency) {
            return Optional.empty();
        }
        BlockPos origin = new BlockPos(context.f_226628_().m_151390_(), 90, context.f_226628_().m_151393_());
        Heightmaps heightmaps = this.buildHeightmapData(context, origin);
        List configs = context.f_226621_().m_255025_(AbridgedRegistries.BRIDGE_CONFIG_KEY).m_214062_().toList();
        IntArrayList indices = Util.m_214658_((IntStream)IntStream.rangeClosed(0, configs.size() - 1), (RandomSource)context.f_226626_());
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            Holder config = (Holder)configs.get(index);
            BridgeData bridgeData = this.getBridgeData(context, origin, heightmaps, (BridgeConfig)config.m_203334_());
            if (bridgeData == null) continue;
            BlockPos pos = new BlockPos(context.f_226628_().m_151390_(), bridgeData.getHeight().intValue(), context.f_226628_().m_151393_());
            return BridgeStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, collector -> BridgeStructure.addPieces(context.f_226625_(), (RandomSource)context.f_226626_(), pos, (StructurePieceAccessor)collector, bridgeData, (Holder<BridgeConfig>)config));
        }
        return Optional.empty();
    }

    private BridgeData getBridgeData(Structure.GenerationContext context, BlockPos pos, Heightmaps heightmaps, BridgeConfig config) {
        if (!config.condition().test(context, pos)) {
            return null;
        }
        BridgeData xBridgeData = this.findValidSegmentLayout(Direction.EAST, heightmaps, config);
        return xBridgeData != null ? xBridgeData : this.findValidSegmentLayout(Direction.SOUTH, heightmaps, config);
    }

    private BridgeData findValidSegmentLayout(Direction direction, Heightmaps heightmaps, BridgeConfig config) {
        List<Integer> leftHeights = heightmaps.heights().get(direction.m_122424_());
        List<Integer> rightHeights = heightmaps.heights().get(direction);
        Integer negativeHeight = null;
        Integer positiveHeight = null;
        Integer chunkOffset = null;
        Integer totalSegments = null;
        block0: for (int k = 0; k < leftHeights.size(); ++k) {
            Integer leftHeight = leftHeights.get(k);
            if (!config.height().m_184578_((Comparable)leftHeight)) continue;
            for (int l = 0; l < rightHeights.size(); ++l) {
                Integer rightHeight = rightHeights.get(l);
                if (!config.height().m_184578_((Comparable)rightHeight)) continue;
                int segments = k + l + 2;
                if (Math.abs(leftHeight - rightHeight) > config.maxHeightDifference() || !config.segments().m_184578_((Comparable)Integer.valueOf(segments))) continue;
                negativeHeight = leftHeight;
                positiveHeight = rightHeight;
                chunkOffset = -k - 1;
                totalSegments = segments;
                break block0;
            }
        }
        if (negativeHeight == null) {
            return null;
        }
        return new BridgeData(negativeHeight, positiveHeight, chunkOffset, totalSegments, direction);
    }

    private Heightmaps buildHeightmapData(Structure.GenerationContext context, BlockPos pos) {
        return new Heightmaps(new EnumMap<Direction, List<Integer>>(Map.of(Direction.NORTH, this.buildHeightmapList(context, pos, Direction.NORTH), Direction.EAST, this.buildHeightmapList(context, pos, Direction.EAST), Direction.SOUTH, this.buildHeightmapList(context, pos, Direction.SOUTH), Direction.WEST, this.buildHeightmapList(context, pos, Direction.WEST))));
    }

    private List<Integer> buildHeightmapList(Structure.GenerationContext context, BlockPos pos, Direction direction) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        for (int j = 1; j <= this.maxChunkRadius; ++j) {
            int height = BridgeStructure.getHeightmap(pos.m_5484_(direction, 16 * j), context);
            if (j != 1 && (Integer)heights.get(heights.size() - 1) > height) break;
            heights.add(height);
        }
        return heights;
    }

    private static int getHeightmap(BlockPos pos, Structure.GenerationContext context) {
        ChunkGenerator generator = context.f_226622_();
        if (generator instanceof NoiseBasedChunkGenerator && !ConfigHandler.state().directlySampleHeightmap) {
            double depthAtSeaLevel = context.f_226624_().m_224578_().f_209388_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), 64, pos.m_123343_()));
            return (int)((depthAtSeaLevel + 0.5) * 128.0) + 2;
        }
        return generator.m_223221_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
    }

    public static void addPieces(StructureTemplateManager manager, RandomSource random, BlockPos pos, StructurePieceAccessor pieceAccessor, BridgeData bridgeData, Holder<BridgeConfig> holder) {
        BridgeConfig config = (BridgeConfig)holder.m_203334_();
        for (int i = 0; i < bridgeData.totalSegments(); ++i) {
            if (i == 0) {
                pieceAccessor.m_142679_((StructurePiece)new BridgePiece(manager, BridgeStructure.getId(config.edge(), random), pos.m_5484_(bridgeData.direction(), (bridgeData.chunkOffset() + i) * 16), bridgeData.getRotation(), holder));
                continue;
            }
            if (i == bridgeData.totalSegments() - 1) {
                pieceAccessor.m_142679_((StructurePiece)new BridgePiece(manager, BridgeStructure.getId(config.edge(), random), pos.m_5484_(bridgeData.direction(), (bridgeData.chunkOffset() + i) * 16 + 15), bridgeData.getRotation(), Mirror.FRONT_BACK, holder));
                continue;
            }
            pieceAccessor.m_142679_((StructurePiece)new BridgePiece(manager, BridgeStructure.getId(config.base(), random), pos.m_5484_(bridgeData.direction(), (bridgeData.chunkOffset() + i) * 16), bridgeData.getRotation(), holder));
        }
        pieceAccessor.m_142679_((StructurePiece)new BridgePiece(manager, BridgePiece.BEARD_BASE, pos.m_5484_(bridgeData.direction(), bridgeData.chunkOffset() * 16).m_5484_(Direction.DOWN, -1), bridgeData.getRotation(), holder));
        pieceAccessor.m_142679_((StructurePiece)new BridgePiece(manager, BridgePiece.BEARD_BASE, pos.m_5484_(bridgeData.direction(), (bridgeData.chunkOffset() + bridgeData.totalSegments()) * 16 - 8).m_5484_(Direction.DOWN, -1), bridgeData.getRotation(), holder));
    }

    private static ResourceLocation getId(List<ResourceLocation> ids, RandomSource random) {
        return (ResourceLocation)Util.m_214621_(ids, (RandomSource)random);
    }

    public void m_214110_(WorldGenLevel p_226561_, StructureManager p_226562_, ChunkGenerator p_226563_, RandomSource p_226564_, BoundingBox p_226565_, ChunkPos p_226566_, PiecesContainer piecesContainer) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minY = p_226561_.m_6042_().f_156647_();
        BoundingBox blockBox = piecesContainer.m_192756_();
        int baseY = blockBox.m_162396_();
        List pieces = piecesContainer.f_192741_();
        if (pieces.isEmpty() || !(pieces.get(0) instanceof BridgePiece)) {
            return;
        }
        ResourceLocation configId = ((BridgePiece)((Object)pieces.get((int)0))).configId;
        Optional config = p_226561_.m_9598_().m_255025_(AbridgedRegistries.BRIDGE_CONFIG_KEY).m_254902_(ResourceKey.m_135785_(AbridgedRegistries.BRIDGE_CONFIG_KEY, (ResourceLocation)configId));
        if (config.isEmpty()) {
            return;
        }
        for (int x = p_226565_.m_162395_(); x <= p_226565_.m_162399_(); ++x) {
            for (int z = p_226565_.m_162398_(); z <= p_226565_.m_162401_(); ++z) {
                pos.m_122178_(x, baseY, z);
                BlockState state = p_226561_.m_8055_((BlockPos)pos);
                block2: for (BridgeConfig.Extension extension : ((BridgeConfig)((Holder.Reference)config.get()).m_203334_()).extensions()) {
                    if (!state.m_204341_(extension.blocks()) || !blockBox.m_71051_((Vec3i)pos) || !piecesContainer.m_192751_((BlockPos)pos)) continue;
                    for (int y = baseY - 1; y > minY; --y) {
                        pos.m_142448_(y);
                        if (!p_226561_.m_46859_((BlockPos)pos) && !p_226561_.m_8055_((BlockPos)pos).m_278721_() && !p_226561_.m_8055_((BlockPos)pos).m_204336_(BlockTags.f_144274_)) continue block2;
                        p_226561_.m_7731_((BlockPos)pos, extension.extendedState().m_213972_(p_226564_, (BlockPos)pos), 3);
                    }
                }
            }
        }
    }

    public StructureType<?> m_213658_() {
        return AbridgedRegistries.BRIDGE_STRUCTURE;
    }

    public record Heightmaps(EnumMap<Direction, List<Integer>> heights) {
    }

    public record BridgeData(Integer leftHeight, Integer rightHeight, Integer chunkOffset, Integer totalSegments, Direction direction) {
        public Rotation getRotation() {
            return this.direction.m_122434_() == Direction.Axis.X ? Rotation.NONE : Rotation.CLOCKWISE_90;
        }

        public Integer getHeight() {
            return Math.min(this.leftHeight, this.rightHeight);
        }
    }
}

