/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.abridged.worldgen.stateprovider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.abridged.registry.AbridgedRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;

public class GradientStateProvider
extends BlockStateProvider {
    public static final MapCodec<GradientStateProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("upper").forGetter(GradientStateProvider::upper), (App)BlockStateProvider.f_68747_.fieldOf("lower").forGetter(GradientStateProvider::lower), (App)Codec.INT.fieldOf("start_y").forGetter(GradientStateProvider::startY), (App)Codec.INT.fieldOf("end_y").forGetter(GradientStateProvider::endY)).apply((Applicative)instance, GradientStateProvider::new));
    private final BlockStateProvider upper;
    private final BlockStateProvider lower;
    private final int startY;
    private final int endY;

    public GradientStateProvider(BlockStateProvider upper, BlockStateProvider lower, int startY, int endY) {
        this.upper = upper;
        this.lower = lower;
        this.startY = startY;
        this.endY = endY;
    }

    public BlockStateProvider upper() {
        return this.upper;
    }

    public BlockStateProvider lower() {
        return this.lower;
    }

    public int startY() {
        return this.startY;
    }

    public int endY() {
        return this.endY;
    }

    protected BlockStateProviderType<?> m_5923_() {
        return AbridgedRegistries.GRADIENT_STATE_PROVIDER;
    }

    public BlockState m_213972_(RandomSource p_225964_, BlockPos pos) {
        int y = pos.m_123342_();
        if (y > this.endY) {
            return this.upper.m_213972_(p_225964_, pos);
        }
        if (y < this.startY) {
            return this.lower.m_213972_(p_225964_, pos);
        }
        double d = (double)(y - this.startY) / (double)(this.endY - this.startY);
        return (double)p_225964_.m_188501_() < d ? this.upper.m_213972_(p_225964_, pos) : this.lower.m_213972_(p_225964_, pos);
    }
}

