/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.abridged.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.worldgen.abridged.Abridged;
import dev.worldgen.abridged.config.ConfigState;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.util.GsonHelper;

public class ConfigHandler {
    private static ConfigState LOADED_CONFIG = new ConfigState(0.8f, false);

    public static ConfigState state() {
        return LOADED_CONFIG;
    }

    public static void load(Path folder) {
        Path path;
        block11: {
            path = folder.resolve("abridged.json");
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                ConfigHandler.write(path);
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                Optional result = ConfigState.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
                if (result.isPresent()) {
                    LOADED_CONFIG = (ConfigState)result.get();
                    break block11;
                }
                throw new JsonParseException("Invalid codec");
            }
            catch (JsonParseException e) {
                Abridged.LOGGER.error("Couldn't parse config file, resetting to default config");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ConfigHandler.write(path);
    }

    private static void write(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            JsonElement element = (JsonElement)ConfigState.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)LOADED_CONFIG).result().get();
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setIndent("  ");
            GsonHelper.m_216207_((JsonWriter)jsonWriter, (JsonElement)element, Comparator.naturalOrder());
            writer.write(stringWriter.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

