/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.reflect;

import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.reflect.Objects;
import me.decce.ixeris.core.shadow.reflect.accessor.UnsafeAccess;

@ParametersAreNonnullByDefault
public class Arrays {
    private static final int ARRAY_LENGTH_OFFSET;

    public static void setLength(Object array, int newLength) {
        if (ARRAY_LENGTH_OFFSET == -1) {
            throw new UnsupportedOperationException("Could not find the array length field offset");
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Object is not an array");
        }
        UnsafeAccess.putInt(array, ARRAY_LENGTH_OFFSET, newLength);
    }

    public static void fill(boolean[] array, boolean value) {
        UnsafeAccess.setMemory(array, Objects.BOOLEAN_ARRAY_BASE_OFFSET, (long)array.length * (long)Objects.BOOLEAN_ARRAY_INDEX_SCALE, (byte)(value ? 1 : 0));
    }

    public static void fill(byte[] array, byte value) {
        UnsafeAccess.setMemory(array, Objects.BYTE_ARRAY_BASE_OFFSET, (long)array.length * (long)Objects.BYTE_ARRAY_INDEX_SCALE, value);
    }

    public static void fill(short[] array, short value) {
        if (value == 0) {
            UnsafeAccess.setMemory(array, Objects.SHORT_ARRAY_BASE_OFFSET, (long)array.length * (long)Objects.SHORT_ARRAY_INDEX_SCALE, (byte)0);
        } else {
            for (int i = 0; i < array.length; ++i) {
                UnsafeAccess.putShort(array, Objects.SHORT_ARRAY_BASE_OFFSET + (long)i * (long)Objects.SHORT_ARRAY_INDEX_SCALE, value);
            }
        }
    }

    public static void fill(char[] array, char value) {
        if (value == '\u0000') {
            UnsafeAccess.setMemory(array, Objects.CHAR_ARRAY_BASE_OFFSET, (long)array.length * (long)Objects.CHAR_ARRAY_INDEX_SCALE, (byte)0);
        } else {
            for (int i = 0; i < array.length; ++i) {
                UnsafeAccess.putChar(array, Objects.CHAR_ARRAY_BASE_OFFSET + (long)i * (long)Objects.CHAR_ARRAY_INDEX_SCALE, value);
            }
        }
    }

    public static void fill(int[] array, int value) {
        if (value == 0) {
            UnsafeAccess.setMemory(array, Objects.INT_ARRAY_BASE_OFFSET, (long)array.length * (long)Objects.INT_ARRAY_INDEX_SCALE, (byte)0);
        } else {
            for (int i = 0; i < array.length; ++i) {
                UnsafeAccess.putInt(array, Objects.INT_ARRAY_BASE_OFFSET + (long)i * (long)Objects.INT_ARRAY_INDEX_SCALE, value);
            }
        }
    }

    public static void fill(long[] array, long value) {
        if (value == 0L) {
            UnsafeAccess.setMemory(array, Objects.LONG_ARRAY_BASE_OFFSET, (long)array.length * (long)Objects.LONG_ARRAY_INDEX_SCALE, (byte)0);
        } else {
            for (int i = 0; i < array.length; ++i) {
                UnsafeAccess.putLong(array, Objects.LONG_ARRAY_BASE_OFFSET + (long)i * (long)Objects.LONG_ARRAY_INDEX_SCALE, value);
            }
        }
    }

    public static void fill(float[] array, float value) {
        if (value == 0.0f) {
            UnsafeAccess.setMemory(array, Objects.FLOAT_ARRAY_BASE_OFFSET, (long)array.length * (long)Objects.FLOAT_ARRAY_INDEX_SCALE, (byte)0);
        } else {
            for (int i = 0; i < array.length; ++i) {
                UnsafeAccess.putFloat(array, Objects.FLOAT_ARRAY_BASE_OFFSET + (long)i * (long)Objects.FLOAT_ARRAY_INDEX_SCALE, value);
            }
        }
    }

    public static void fill(double[] array, double value) {
        if (value == 0.0) {
            UnsafeAccess.setMemory(array, Objects.DOUBLE_ARRAY_BASE_OFFSET, (long)array.length * (long)Objects.DOUBLE_ARRAY_INDEX_SCALE, (byte)0);
        } else {
            for (int i = 0; i < array.length; ++i) {
                UnsafeAccess.putDouble(array, Objects.DOUBLE_ARRAY_BASE_OFFSET + (long)i * (long)Objects.DOUBLE_ARRAY_INDEX_SCALE, value);
            }
        }
    }

    static {
        int lengthOffset = -1;
        byte[] test = new byte[123];
        int i = 0;
        while ((long)i < Objects.BYTE_ARRAY_BASE_OFFSET) {
            int arrayLength = test.length;
            if (UnsafeAccess.getInt(test, i) == arrayLength) {
                int newLength = arrayLength + 1;
                UnsafeAccess.putInt(test, i, newLength);
                if (test.length == newLength) {
                    lengthOffset = i;
                    break;
                }
                UnsafeAccess.putInt(test, i, arrayLength);
            }
            ++i;
        }
        ARRAY_LENGTH_OFFSET = lengthOffset;
    }
}

