/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.reflect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import me.decce.ixeris.core.shadow.reflect.ClassLoaders;
import me.decce.ixeris.core.shadow.reflect.Fields;
import me.decce.ixeris.core.shadow.reflect.JVMConstants;
import me.decce.ixeris.core.shadow.reflect.JavaBypass;
import me.decce.ixeris.core.shadow.reflect.Methods;
import me.decce.ixeris.core.shadow.reflect.bytecode.BytecodeUtils;
import me.decce.ixeris.core.shadow.reflect.bytecode.builder.BytecodeBuilder;
import me.decce.ixeris.core.shadow.reflect.bytecode.wrapper.BuiltClass;
import me.decce.ixeris.core.shadow.reflect.exceptions.FieldNotFoundException;
import me.decce.ixeris.core.shadow.reflect.utils.FieldInitializer;

public class Agents {
    private static final String DUMMY_AGENT_CLASS_NAME = String.join((CharSequence)".", "net", "lenni0451", "reflect", "AgentLoader");
    private static final String INSTRUMENTATION_FIELD_NAME = "instrumentation";
    private static final Class<?> instrumentationImpl = FieldInitializer.optInit(() -> Class.forName(JVMConstants.CLASS_InstrumentationImpl));
    private static final MethodHandle loadAgent = FieldInitializer.optInit(() -> Methods.getDeclaredMethod(instrumentationImpl, JVMConstants.METHOD_InstrumentationImpl_loadAgent, String.class), JavaBypass.TRUSTED_LOOKUP::unreflect);

    public static File createDummyAgent(Class<?> agentClass) throws IOException {
        File agentJar = File.createTempFile("DummyAgent", ".jar");
        agentJar.deleteOnExit();
        Agents.createDummyAgent(agentJar, agentClass.getName());
        return agentJar;
    }

    public static void createDummyAgent(File agentJar, String agentName) throws IOException {
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(agentJar));){
            jos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
            manifest.getMainAttributes().putValue("Launcher-Agent-Class", agentName);
            manifest.getMainAttributes().putValue("Can-Redefine-Classes", "true");
            manifest.getMainAttributes().putValue("Can-Retransform-Classes", "true");
            manifest.getMainAttributes().putValue("Can-Set-Native-Method-Prefix", "true");
            manifest.write(jos);
        }
    }

    public static void load(File agentJar) {
        if (loadAgent == null) {
            throw new IllegalStateException("Loading an Agent during runtime is not possible because the " + JVMConstants.METHOD_InstrumentationImpl_loadAgent + " method does not exist");
        }
        try {
            loadAgent.invokeExact(agentJar.getAbsolutePath());
        }
        catch (InternalError e) {
            File simpleAgentJar = new File(".reflect_temp_agent" + System.nanoTime() + ".jar");
            try {
                Files.copy(agentJar.toPath(), simpleAgentJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                loadAgent.invokeExact(simpleAgentJar.getName());
            }
            catch (Throwable t) {
                IllegalStateException finalException = new IllegalStateException("Failed to load agent from jar: " + agentJar.getAbsolutePath(), e);
                finalException.addSuppressed(t);
                throw finalException;
            }
            finally {
                simpleAgentJar.deleteOnExit();
                simpleAgentJar.delete();
            }
        }
    }

    public static void loadInternal(Class<?> agentClass) throws IOException {
        Agents.load(Agents.createDummyAgent(agentClass));
    }

    public static Instrumentation getInstrumentation() throws IOException {
        Class<?> agentLoaderClass;
        ClassLoader targetClassLoader = ClassLoader.getSystemClassLoader();
        try {
            agentLoaderClass = targetClassLoader.loadClass(DUMMY_AGENT_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            agentLoaderClass = ClassLoaders.defineClass(targetClassLoader, DUMMY_AGENT_CLASS_NAME, Agents.generateAgentClass());
            Agents.load(Agents.createDummyAgent(agentLoaderClass));
        }
        if (agentLoaderClass == null) {
            throw new IllegalStateException("Agent loader class is null", new ClassNotFoundException(DUMMY_AGENT_CLASS_NAME));
        }
        Field field = Fields.getDeclaredField(agentLoaderClass, INSTRUMENTATION_FIELD_NAME);
        if (field == null) {
            throw new IllegalStateException("Instrumentation field not found in agent loader class", new FieldNotFoundException(agentLoaderClass.getName(), INSTRUMENTATION_FIELD_NAME));
        }
        Instrumentation instrumentation = (Instrumentation)Fields.get(null, field);
        if (instrumentation == null) {
            throw new IllegalStateException("Instrumentation instance in class " + agentLoaderClass.getName() + " in loader " + targetClassLoader + " is null");
        }
        return instrumentation;
    }

    private static byte[] generateAgentClass() {
        BytecodeBuilder builder = BytecodeBuilder.get();
        BuiltClass clazz = builder.class_(builder.opcode("ACC_PUBLIC"), BytecodeUtils.slash(DUMMY_AGENT_CLASS_NAME), null, BytecodeUtils.slash(Object.class), null, cb -> {
            cb.field(builder.opcode("ACC_PUBLIC", "ACC_STATIC"), INSTRUMENTATION_FIELD_NAME, BytecodeUtils.desc(Instrumentation.class), null, null);
            cb.method(builder.opcode("ACC_PUBLIC"), "<init>", "()V", null, null, mb -> mb.aload(0).invokespecial(BytecodeUtils.slash(Object.class), "<init>", "()V", false).return_().maxs(1, 1));
            for (String methodName : new String[]{"agentmain", "premain"}) {
                cb.method(builder.opcode("ACC_PUBLIC", "ACC_STATIC"), methodName, BytecodeUtils.mdesc(Void.TYPE, String.class, Instrumentation.class), null, null, mb -> mb.aload(1).putstatic(BytecodeUtils.slash(DUMMY_AGENT_CLASS_NAME), INSTRUMENTATION_FIELD_NAME, BytecodeUtils.desc(Instrumentation.class)).return_().maxs(1, 2));
            }
        });
        return clazz.toBytes();
    }
}

