/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.transformer.impl.general;

import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.transformer.AnnotationHandler;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.mappings.MapRemapper;
import me.decce.ixeris.core.shadow.classtransform.utils.mappings.Remapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class SyntheticMethodGeneralHandler
extends AnnotationHandler {
    static void fillSyntheticMappings(ClassNode source, ClassNode target, MapRemapper remapper) {
        for (MethodNode method : source.methods) {
            if ((method.access & 0x1000) == 0) continue;
            String newName = SyntheticMethodGeneralHandler.getUniqueName(target, source, method);
            remapper.addMethodMapping(source.name, method.name, method.desc, newName);
        }
    }

    private static String getUniqueName(ClassNode target, ClassNode owner, MethodNode method) {
        String current;
        int id = 0;
        while (ASMUtils.hasMethod(target, current = method.name + "$" + SyntheticMethodGeneralHandler.getSimpleName(owner) + id, method.desc)) {
        }
        return current;
    }

    private static String getSimpleName(ClassNode node) {
        int index = node.name.lastIndexOf(47);
        return index == -1 ? node.name : node.name.substring(index + 1);
    }

    @Override
    public void transform(TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer) {
        MapRemapper remapper = new MapRemapper();
        SyntheticMethodGeneralHandler.fillSyntheticMappings(transformer, transformedClass, remapper);
        ClassNode remapped = Remapper.remap(transformer, remapper);
        Remapper.merge(transformer, remapped);
    }
}

