/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.transformer.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.annotations.injection.CRedirect;
import me.decce.ixeris.core.shadow.classtransform.exceptions.InvalidTargetException;
import me.decce.ixeris.core.shadow.classtransform.exceptions.TransformerException;
import me.decce.ixeris.core.shadow.classtransform.targets.IInjectionTarget;
import me.decce.ixeris.core.shadow.classtransform.transformer.coprocessor.AnnotationCoprocessorList;
import me.decce.ixeris.core.shadow.classtransform.transformer.impl.redirect.CRedirectField;
import me.decce.ixeris.core.shadow.classtransform.transformer.impl.redirect.CRedirectInvoke;
import me.decce.ixeris.core.shadow.classtransform.transformer.impl.redirect.CRedirectNew;
import me.decce.ixeris.core.shadow.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class CRedirectAnnotationHandler
extends RemovingTargetAnnotationHandler<CRedirect> {
    private final CRedirectInvoke redirectInvoke = new CRedirectInvoke();
    private final CRedirectField redirectField = new CRedirectField();
    private final CRedirectNew redirectNew = new CRedirectNew();

    public CRedirectAnnotationHandler() {
        super(CRedirect.class, CRedirect::method);
    }

    @Override
    public void transform(CRedirect annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        AnnotationCoprocessorList coprocessors = transformerManager.getCoprocessors();
        transformerMethod = coprocessors.preprocess(transformerManager, transformedClass, target, transformer, transformerMethod);
        Map<String, IInjectionTarget> injectionTargets = transformerManager.getInjectionTargets();
        IInjectionTarget injectionTarget = injectionTargets.get(annotation.target().value().toUpperCase(Locale.ROOT));
        if (injectionTarget == null) {
            throw new InvalidTargetException(transformerMethod, transformer, annotation.target().target(), injectionTargets.keySet());
        }
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        List<AbstractInsnNode> injectionInstructions = injectionTarget.getTargets(injectionTargets, target, annotation.target(), annotation.slice());
        if (injectionInstructions == null) {
            throw TransformerException.invalidMemberDeclaration(transformerMethod, transformer, annotation.target().target());
        }
        if (injectionInstructions.isEmpty() && !annotation.target().optional()) {
            throw new TransformerException(transformerMethod, transformer, "target '" + annotation.target().target() + "' could not be found").help("e.g. Ljava/lang/String;toString()V, Ljava/lang/Integer;MAX_VALUE:I");
        }
        ArrayList<MethodInsnNode> transformerMethodCalls = new ArrayList<MethodInsnNode>();
        MethodNode copiedTransformerMethod = this.renameAndCopy(transformerMethod, target, transformer, transformedClass, "CRedirect");
        for (AbstractInsnNode injectionInstruction : injectionInstructions) {
            if (injectionInstruction instanceof MethodInsnNode) {
                if (injectionInstruction.getOpcode() == 183 && ((MethodInsnNode)injectionInstruction).name.equals("<init>")) {
                    this.redirectNew.inject(transformedClass, target, transformer, transformerMethod, injectionInstruction, transformerMethodCalls);
                    continue;
                }
                this.redirectInvoke.inject(transformedClass, target, transformer, transformerMethod, injectionInstruction, transformerMethodCalls);
                continue;
            }
            if (injectionInstruction instanceof FieldInsnNode) {
                this.redirectField.inject(transformedClass, target, transformer, transformerMethod, injectionInstruction, transformerMethodCalls);
                continue;
            }
            throw new InvalidTargetException(transformerMethod, transformer, annotation.target().value(), Arrays.asList("INVOKE", "FIELD", "NEW"));
        }
        coprocessors.postprocess(transformerManager, transformedClass, target, transformerMethodCalls, transformer, copiedTransformerMethod);
    }
}

