/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.longs.Long2ReferenceArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWWindowCloseCallbackI;
import org.lwjgl.system.Callback;

public class WindowCloseCallbackDispatcher {
    private static final Long2ReferenceMap<WindowCloseCallbackDispatcher> instance = new Long2ReferenceArrayMap(1);
    private final ReferenceArrayList<GLFWWindowCloseCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWWindowCloseCallbackI lastCallback;
    public long lastCallbackAddress;
    private final long window;
    public volatile boolean suppressChecks;

    private WindowCloseCallbackDispatcher(long window) {
        this.window = window;
    }

    public static synchronized WindowCloseCallbackDispatcher get(long window) {
        if (!instance.containsKey(window)) {
            instance.put(window, (Object)new WindowCloseCallbackDispatcher(window));
            ((WindowCloseCallbackDispatcher)instance.get(window)).validate();
        }
        return (WindowCloseCallbackDispatcher)instance.get(window);
    }

    public synchronized void registerMainThreadCallback(GLFWWindowCloseCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetWindowCloseCallback((long)this.window, (long)0L);
        } else {
            GLFW.nglfwSetWindowCloseCallback((long)this.window, (long)CommonCallbacks.windowCloseCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWWindowCloseCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWWindowCloseCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetWindowCloseCallback((long)this.window, (long)CommonCallbacks.windowCloseCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetWindowCloseCallback((long)this.window, (long)0L);
            }
        } else if (current != CommonCallbacks.windowCloseCallback.address()) {
            this.lastCallback = (GLFWWindowCloseCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(long window) {
        if (this.window != window) {
            return;
        }
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWWindowCloseCallbackI)this.mainThreadCallbacks.get(i)).invoke(window);
        }
        if (this.lastCallback != null) {
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(window);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

