/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris;

import com.mojang.blaze3d.systems.RenderSystem;
import me.decce.ixeris.workarounds.WindowMinimizedStateWorkaround;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.util.NativeModuleLister;
import org.slf4j.Logger;

public class RenderThreadStarter
implements Runnable {
    private final GameConfig gameConfig;
    private final Logger logger;

    public RenderThreadStarter(GameConfig gameConfig, Logger logger) {
        this.gameConfig = gameConfig;
        this.logger = logger;
    }

    @Override
    public void run() {
        Minecraft minecraft = this.tryCreateMinecraft();
        if (minecraft != null) {
            RenderThreadStarter.initGameThread();
            minecraft.m_91374_();
            try {
                minecraft.m_91395_();
            }
            finally {
                minecraft.m_91393_();
            }
        }
    }

    private Minecraft tryCreateMinecraft() {
        Minecraft minecraft = null;
        try {
            RenderSystem.initRenderThread();
            RenderThreadStarter.beginInitialization();
            minecraft = new Minecraft(this.gameConfig);
            RenderThreadStarter.finishInitialization();
            WindowMinimizedStateWorkaround.init();
        }
        catch (SilentInitException silentInitException) {
            Util.m_137580_();
            this.logger.warn("Failed to create window: ", (Throwable)silentInitException);
            return null;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)"Initializing game");
            CrashReportCategory crashReportCategory = crashReport.m_127514_("Initialization");
            NativeModuleLister.m_184679_((CrashReportCategory)crashReportCategory);
            Minecraft.m_167872_((Minecraft)null, (LanguageManager)null, (String)this.gameConfig.f_101908_.f_101927_, (Options)null, (CrashReport)crashReport);
            Minecraft.m_91332_((CrashReport)crashReport);
            return null;
        }
        return minecraft;
    }

    public static void initGameThread() {
        RenderSystem.initGameThread((boolean)false);
    }

    public static void beginInitialization() {
    }

    public static void finishInitialization() {
    }
}

