/*
 * Decompiled with CFR 0.152.
 */
package com.memorysettings;

import com.memorysettings.Memory;
import com.memorysettings.config.CommonConfiguration;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="memorysettings")
public class MemorysettingsMod {
    public static final String MODID = "memorysettings";
    public static Random rand = new Random();
    public static MutableComponent memorycheckresult = Component.m_237119_();
    public static boolean didDisplay = false;

    public MemorysettingsMod() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "", (c, b) -> true));
        if (!((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).disableWarnings) {
            Memory.doEarlyWarnings();
            MemorysettingsMod.doWarning();
        }
    }

    public static void doWarning() {
        int configMax = FMLEnvironment.dist != Dist.DEDICATED_SERVER ? ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).maximumClient : ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).maximumServer;
        int configMin = FMLEnvironment.dist != Dist.DEDICATED_SERVER ? ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumClient : ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumServer;
        int recommendMemory = Math.min(Memory.getRecommendedMemoryForSystemMemory(Memory.systemMemory), configMax);
        Object message = "";
        if (Memory.heapSetting > configMax + 250) {
            message = (String)message + "You have more memory allocated(" + Memory.heapSetting + "mb) than recommended for this pack, the maximum is: " + configMax + "mb.\nThe recommended amount for your system is: " + recommendMemory + " mb.\n";
            memorycheckresult.m_7220_((Component)Component.m_237110_((String)"warning.toomuch", (Object[])new Object[]{Component.m_237113_((String)("" + Memory.heapSetting)).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)("" + configMax)).m_130940_(ChatFormatting.BLUE), Component.m_237113_((String)("" + recommendMemory)).m_130940_(ChatFormatting.GREEN)}));
        }
        if (Memory.heapSetting < configMin - 250) {
            message = (String)message + "You have less memory allocated(" + Memory.heapSetting + "mb) than recommended for this pack, the minimum is: " + configMin + "mb.\nThe recommended amount for your system is: " + recommendMemory + " mb.\n";
            memorycheckresult.m_7220_((Component)Component.m_237110_((String)"warning.toolow", (Object[])new Object[]{Component.m_237113_((String)("" + Memory.heapSetting)).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)("" + configMin)).m_130940_(ChatFormatting.BLUE), Component.m_237113_((String)("" + recommendMemory)).m_130940_(ChatFormatting.GREEN)}));
        }
        if ((double)Math.abs(Memory.heapSetting - recommendMemory) / (double)recommendMemory * 100.0 > (double)((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).warningTolerance && Memory.heapSetting <= configMax && Memory.heapSetting >= configMin) {
            message = (String)message + "You have " + (Memory.heapSetting > recommendMemory ? "more" : "less") + " more memory allocated than recommended for your system, the recommended amount for your system is: " + recommendMemory + " mb.\n";
            memorycheckresult.m_7220_((Component)Component.m_237110_((String)(Memory.heapSetting > recommendMemory ? "warning.overrecommended" : "warning.underrecommended"), (Object[])new Object[]{Component.m_237113_((String)("" + Memory.heapSetting)).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)("" + recommendMemory)).m_130940_(ChatFormatting.GREEN)}));
        }
        if (recommendMemory < configMin - 250) {
            message = (String)message + "The recommended for your system is lower than the required minimum of " + configMin + "mb for this pack, things may not work out so well.\nMost common sign of insufficient ram is frequent stutters.\n";
            memorycheckresult.m_7220_((Component)Component.m_237110_((String)"warning.recommendedbelowmin", (Object[])new Object[]{Component.m_237113_((String)("" + recommendMemory)).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)("" + configMin)).m_130940_(ChatFormatting.RED)}));
        }
        if (((String)message).equals("")) {
            return;
        }
        CommonConfiguration.LOGGER.warn((String)message);
    }
}

