/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.DynamicTreesHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsHandler {
    public static void tryMeltSnowUnderTrees(TickEvent.LevelTickEvent event) {
        ServerLevel level = (ServerLevel)event.level;
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
        SeasonsConfig.SeasonProperties seasonProperties = ModConfig.seasons.getSeasonProperties(subSeason);
        float meltRandomness = seasonProperties.meltChance() / 100.0f;
        int rolls = seasonProperties.meltRolls();
        if (rolls > 0 && meltRandomness > 0.0f && SereneSeasonsHandler.generateSnowAndIce() && ModConfig.seasons.isDimensionWhitelisted(level.m_46472_())) {
            SnowUnderTrees.runForChunks(level, chunk -> {
                for (int i = 0; i < rolls; ++i) {
                    BlockState stateAfter;
                    BlockState stateNow;
                    Holder biomeHolder;
                    boolean biomeDisabled;
                    int chunkZ;
                    ChunkPos chunkPos;
                    int chunkX;
                    BlockPos randomPos;
                    if (!(level.f_46441_.m_188501_() < meltRandomness) || !level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, randomPos = level.m_46496_(chunkX = (chunkPos = chunk.m_7697_()).m_45604_(), 0, chunkZ = chunkPos.m_45605_(), 15)).m_7495_()).m_204336_(BlockTags.f_13035_)) continue;
                    BlockPos pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos);
                    if (SnowUnderTrees.isDynamicTreesLoaded()) {
                        if ((pos = DynamicTreesHandler.findGround((WorldGenLevel)level, pos.m_122032_())) == null) {
                            return;
                        }
                        if (level.m_8055_(pos).m_60795_()) {
                            pos = pos.m_7495_();
                        }
                    }
                    boolean bl = biomeDisabled = SnowUnderTrees.isBiomeDisabled((Holder<Biome>)(biomeHolder = level.m_204166_(pos))) || biomeHolder.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES);
                    if (biomeDisabled || !SnowUnderTrees.isSnow((WorldGenLevel)level, pos) || !SeasonHooks.warmEnoughToRainSeasonal((LevelReader)level, (Holder)biomeHolder, (BlockPos)pos) || (stateNow = level.m_8055_(pos)) == (stateAfter = SnowUnderTrees.getStateAfterMelting(stateNow, (WorldGenLevel)level, pos))) continue;
                    BlockPos downPos = pos.m_7495_();
                    BlockState below = level.m_8055_(downPos);
                    level.m_46597_(pos, stateAfter);
                    if (!below.m_61138_((Property)SnowyDirtBlock.f_56637_)) continue;
                    level.m_7731_(downPos, (BlockState)below.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(false)), 2);
                }
            });
        }
    }

    public static boolean coldEnoughToSnow(WorldGenLevel level, Holder<Biome> biome, BlockPos pos) {
        return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, biome, (BlockPos)pos);
    }

    public static boolean generateSnowAndIce() {
        return ModConfig.seasons.generateSnowAndIce;
    }
}

