/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.enhanced_extinguishing;

import com.aetherteam.enhanced_extinguishing.block.ExtinguishingBlocks;
import com.aetherteam.enhanced_extinguishing.data.generators.ExtinguishingBlockStateData;
import com.aetherteam.enhanced_extinguishing.data.generators.ExtinguishingLanguageData;
import com.aetherteam.enhanced_extinguishing.data.generators.ExtinguishingRecipeData;
import com.aetherteam.enhanced_extinguishing.data.generators.tags.ExtinguishingBlockTagData;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;

@Mod(value="aether_enhanced_extinguishing")
public class EnhancedExtinguishing {
    public static final String MODID = "aether_enhanced_extinguishing";
    private static final Logger LOGGER = LogUtils.getLogger();

    public EnhancedExtinguishing() {
        DeferredRegister[] registers;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        for (DeferredRegister register : registers = new DeferredRegister[]{ExtinguishingBlocks.BLOCKS}) {
            register.register(modEventBus);
        }
        modEventBus.addListener(this::dataSetup);
        modEventBus.addListener(this::packSetup);
    }

    public void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeClient(), (DataProvider)new ExtinguishingBlockStateData(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtinguishingLanguageData(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtinguishingRecipeData(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtinguishingBlockTagData(packOutput, lookupProvider, fileHelper));
        PackMetadataGenerator packMeta = new PackMetadataGenerator(packOutput);
        Map<PackType, Integer> packTypes = Map.of(PackType.SERVER_DATA, SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
        packMeta.m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237115_((String)"pack.aether_enhanced_extinguishing.mod.description"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES), packTypes));
        generator.addProvider(true, (DataProvider)packMeta);
    }

    public void packSetup(AddPackFindersEvent event) {
        this.setupRecipeOverridePack(event);
    }

    private void setupRecipeOverridePack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/recipe_override"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, true, resourcePath);
            PackMetadataSection metadata = new PackMetadataSection((Component)Component.m_237113_((String)""), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
            event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"builtin/extinguishing_recipe_override", (Component)Component.m_237113_((String)""), (boolean)true, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.getPackFormat(PackType.SERVER_DATA), metadata.getPackFormat(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_246902_(), true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
        }
    }
}

