/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.util;

import com.aetherteam.aether.item.AetherCreativeTabs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.registries.RegistryObject;
import org.razordevs.ascended_quark.blocks.AQHedgeBlock;
import org.razordevs.ascended_quark.blocks.AQHollowLogBlock;
import org.razordevs.ascended_quark.blocks.AQLeafCarpetBlock;
import org.razordevs.ascended_quark.blocks.AQVariantBookshelfBlock;
import org.razordevs.ascended_quark.blocks.AQWoodenPostBlock;
import org.razordevs.ascended_quark.blocks.CompAQVerticalSlabBlock;
import org.razordevs.ascended_quark.blocks.LeafCarpetWithParticlesBlock;
import org.razordevs.ascended_quark.module.SkyrootQuarkBlocksModule;
import org.razordevs.ascended_quark.util.TabModel;
import org.razordevs.ascended_quark.util.WoodSetContext;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.quark.content.building.block.VariantLadderBlock;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.mixin.mixins.AccessorLootTable;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BooleanSuppliers;
import org.violetmoon.zeta.util.handler.ToolInteractionHandler;

public class RegistryUtil {
    public static ArrayList<TabModel> TABS = new ArrayList();

    public static void registerWoodsetExtension(String type, ZetaModule module, WoodSetContext context) {
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)new ZetaBlock("vertical_" + type + "_planks", module, BlockPropertyUtil.copyPropertySafe((Block)Blocks.f_50705_)), context.planks(), module);
        SkyrootQuarkBlocksModule.makeChestBlocks(module, type, Blocks.f_50087_, SoundType.f_56736_, BooleanSuppliers.TRUE);
        RegistryUtil.createHedge(type + "_hedge", module, context.fence());
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)new AQHollowLogBlock("hollow_" + type + "_log", module), context.log(), module);
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)new VariantLadderBlock(type, module, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_), true), context.planks(), module);
        if (!type.equals("skyroot")) {
            RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)new AQVariantBookshelfBlock(type, module, true, SoundType.f_56736_), context.planks(), module);
        }
        AQWoodenPostBlock post = new AQWoodenPostBlock(type + "_post", module);
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)post, context.log(), module);
        AQWoodenPostBlock stripped = new AQWoodenPostBlock("stripped_" + type + "_post", module);
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)stripped, context.log(), module);
        ToolInteractionHandler.registerInteraction((ToolAction)ToolActions.AXE_STRIP, (Block)post, (Block)stripped);
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)new CompAQVerticalSlabBlock(type + "_vertical_slab", context.slab(), BlockPropertyUtil.copyPropertySafe((Block)Blocks.f_50705_), module), context.planks(), module);
        RegistryUtil.createLeafCarpet(type + "_leaf_carpet", module, context.leaves());
    }

    public static void registerModifiedLootTable(ResourceLocation loot, ItemLike item, int weight, int quality, LootTableLoadEvent event) {
        if (event.getName().equals((Object)loot)) {
            LootPoolEntryContainer entry = LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79711_(quality).m_7512_();
            RegistryUtil.add(event, entry);
        }
    }

    private static void add(LootTableLoadEvent event, LootPoolEntryContainer entry) {
        LootTable table = event.getTable();
        List pools = ((AccessorLootTable)table).zeta$getPools();
        if (pools != null && !pools.isEmpty()) {
            LootPool firstPool = (LootPool)pools.get(0);
            LootPoolEntryContainer[] entries = firstPool.f_79023_;
            LootPoolEntryContainer[] newEntries = new LootPoolEntryContainer[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            newEntries[entries.length] = entry;
            firstPool.f_79023_ = newEntries;
        }
    }

    public static void registerDisabledWoodsetExtension(String type, ZetaModule module) {
        new ZetaBlock("vertical_" + type + "_planks", module, BlockPropertyUtil.copyPropertySafe((Block)Blocks.f_50705_));
        SkyrootQuarkBlocksModule.makeChestBlocks(module, type, Blocks.f_50087_, SoundType.f_56736_, BooleanSuppliers.TRUE);
        new AQHedgeBlock(type + "_hedge", module);
        new AQHollowLogBlock("hollow_" + type + "_log", module);
        new VariantLadderBlock(type, module, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_), true);
        if (!type.equals("skyroot")) {
            new AQVariantBookshelfBlock(type, module, true, SoundType.f_56736_);
        }
        AQWoodenPostBlock post = new AQWoodenPostBlock(type + "_post", module);
        AQWoodenPostBlock stripped = new AQWoodenPostBlock("stripped_" + type + "_post", module);
        ToolInteractionHandler.registerInteraction((ToolAction)ToolActions.AXE_STRIP, (Block)post, (Block)stripped);
        new CompAQVerticalSlabBlock(type + "_vertical_slab", BlockPropertyUtil.copyPropertySafe((Block)Blocks.f_50705_), module);
        new AQLeafCarpetBlock(type + "_leaf_carpet", module);
    }

    public static void addCreativeModeTab(ResourceKey<CreativeModeTab> tab, ItemLike item, RegistryObject<? extends ItemLike> parent, ZetaModule module) {
        if (!module.isEnabled()) {
            return;
        }
        boolean flag = false;
        for (TabModel tm : TABS) {
            if (!tm.getTab().equals(tab)) continue;
            tm.add(item, (Supplier<? extends ItemLike>)parent);
            flag = true;
        }
        if (!flag) {
            HashMap<ItemLike, Supplier<? extends ItemLike>> map = new HashMap<ItemLike, Supplier<? extends ItemLike>>();
            map.put(item, (Supplier<? extends ItemLike>)parent);
            TABS.add(new TabModel(tab, map));
        }
    }

    public static void createHedge(String name, ZetaModule module, RegistryObject<? extends Block> fence) {
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)new AQHedgeBlock(name, module), fence, module);
    }

    public static void createLeafCarpet(String name, ZetaModule module, RegistryObject<? extends Block> leaves) {
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_NATURAL_BLOCKS.getKey(), (ItemLike)new AQLeafCarpetBlock(name, module), leaves, module);
    }

    public static void createLeafCarpetParticle(String name, ZetaModule module, RegistryObject<? extends Block> leaves, Supplier<? extends ParticleOptions> particle) {
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_NATURAL_BLOCKS.getKey(), (ItemLike)new LeafCarpetWithParticlesBlock(name, module, particle), leaves, module);
    }

    public static ToIntFunction<BlockState> litBlockEmission(int emission) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? emission : 0;
    }
}

