/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.module;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.item.AetherCreativeTabs;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import org.razordevs.ascended_quark.AscendedQuark;
import org.razordevs.ascended_quark.blocks.AQTrappedVariantChestBlock;
import org.razordevs.ascended_quark.blocks.AQVariantChestBlock;
import org.razordevs.ascended_quark.entity.block.AQVariantChestBlockEntity;
import org.razordevs.ascended_quark.entity.block.AQVariantTrappedChestBlockEntity;
import org.razordevs.ascended_quark.entity.render.AQVariantChestRenderer;
import org.razordevs.ascended_quark.proxy.AQClient;
import org.razordevs.ascended_quark.util.RegistryUtil;
import org.razordevs.ascended_quark.util.WoodSetContext;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorAbstractChestedHorse;
import org.violetmoon.zeta.client.SimpleWithoutLevelRenderer;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.event.play.entity.living.ZLivingDeath;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerInteract;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="aether", description="Enables skyroot woodset blocks for quark blocks, such as skyroot post. Disable if another mod already adds compat blocks. ", antiOverlap={"everycomp"})
public class SkyrootQuarkBlocksModule
extends ZetaModule {
    protected static final List<Block> aqRegularChests = new ArrayList<Block>();
    protected static final List<Block> aqTrappedChests = new ArrayList<Block>();
    public static BlockEntityType<AQVariantChestBlockEntity> aqChestTEType;
    public static BlockEntityType<AQVariantTrappedChestBlockEntity> aqTrappedChestTEType;
    private static final ThreadLocal<ItemStack> WAIT_TO_REPLACE_CHEST;

    @LoadEvent
    public void register(ZRegister register) {
        RegistryUtil.registerWoodsetExtension("skyroot", this, new WoodSetContext((RegistryObject<? extends Block>)AetherBlocks.SKYROOT_SLAB, (RegistryObject<? extends Block>)AetherBlocks.SKYROOT_PLANKS, (RegistryObject<? extends Block>)AetherBlocks.SKYROOT_FENCE, (RegistryObject<? extends Block>)AetherBlocks.SKYROOT_LOG, (RegistryObject<? extends Block>)AetherBlocks.SKYROOT_LEAVES));
        RegistryUtil.createLeafCarpetParticle("golden_oak_leaf_carpet", this, (RegistryObject<? extends Block>)AetherBlocks.GOLDEN_OAK_LEAVES, (Supplier<? extends ParticleOptions>)AetherParticleTypes.GOLDEN_OAK_LEAVES);
        RegistryUtil.createLeafCarpetParticle("crystal_leaf_carpet", this, (RegistryObject<? extends Block>)AetherBlocks.CRYSTAL_LEAVES, (Supplier<? extends ParticleOptions>)AetherParticleTypes.CRYSTAL_LEAVES);
        RegistryUtil.createLeafCarpetParticle("crystal_fruit_leaf_carpet", this, (RegistryObject<? extends Block>)AetherBlocks.CRYSTAL_FRUIT_LEAVES, (Supplier<? extends ParticleOptions>)AetherParticleTypes.CRYSTAL_LEAVES);
        RegistryUtil.createLeafCarpetParticle("holiday_leaf_carpet", this, (RegistryObject<? extends Block>)AetherBlocks.HOLIDAY_LEAVES, (Supplier<? extends ParticleOptions>)AetherParticleTypes.HOLIDAY_LEAVES);
        RegistryUtil.createLeafCarpetParticle("decorated_holiday_leaf_carpet", this, (RegistryObject<? extends Block>)AetherBlocks.DECORATED_HOLIDAY_LEAVES, (Supplier<? extends ParticleOptions>)AetherParticleTypes.HOLIDAY_LEAVES);
        RegistryUtil.createHedge("golden_skyroot_hedge", this, (RegistryObject<? extends Block>)AetherBlocks.SKYROOT_FENCE);
        RegistryUtil.createHedge("crystal_skyroot_hedge", this, (RegistryObject<? extends Block>)AetherBlocks.SKYROOT_FENCE);
        RegistryUtil.createHedge("crystal_fruit_skyroot_hedge", this, (RegistryObject<? extends Block>)AetherBlocks.SKYROOT_FENCE);
        RegistryUtil.createHedge("holiday_skyroot_hedge", this, (RegistryObject<? extends Block>)AetherBlocks.SKYROOT_FENCE);
        RegistryUtil.createHedge("decorated_holiday_skyroot_hedge", this, (RegistryObject<? extends Block>)AetherBlocks.SKYROOT_FENCE);
    }

    public static void makeChestBlocks(ZetaModule module, String name, Block base, @Nullable SoundType sound, BooleanSupplier condition) {
        BlockBehaviour.Properties props = BlockPropertyUtil.copyPropertySafe((Block)base);
        if (sound != null) {
            props = props.m_60918_(sound);
        }
        AQVariantChestBlock regularChest = (AQVariantChestBlock)new AQVariantChestBlock(name, module, () -> aqChestTEType, props).setCondition(condition);
        aqRegularChests.add((Block)regularChest);
        AQTrappedVariantChestBlock trappedChest = (AQTrappedVariantChestBlock)new AQTrappedVariantChestBlock(name, module, () -> aqTrappedChestTEType, props).setCondition(condition);
        aqTrappedChests.add((Block)trappedChest);
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_FUNCTIONAL_BLOCKS.getKey(), (ItemLike)regularChest, (RegistryObject<? extends ItemLike>)AetherBlocks.CHEST_MIMIC, module);
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_FUNCTIONAL_BLOCKS.getKey(), (ItemLike)trappedChest, (RegistryObject<? extends ItemLike>)AetherBlocks.CHEST_MIMIC, module);
    }

    @LoadEvent
    public void postRegister(ZRegister.Post e) {
        aqChestTEType = BlockEntityType.Builder.m_155273_(AQVariantChestBlockEntity::new, (Block[])aqRegularChests.toArray(new Block[0])).m_58966_(null);
        aqTrappedChestTEType = BlockEntityType.Builder.m_155273_(AQVariantTrappedChestBlockEntity::new, (Block[])aqTrappedChests.toArray(new Block[0])).m_58966_(null);
        AscendedQuark.ZETA.registry.register(aqChestTEType, "skyroot_chest", Registries.f_256922_);
        AscendedQuark.ZETA.registry.register(aqTrappedChestTEType, "skyroot_trapped_chest", Registries.f_256922_);
    }

    @PlayEvent
    public void onClickEntity(ZPlayerInteract.EntityInteractSpecific event) {
        AbstractChestedHorse horse;
        Entity target = event.getTarget();
        Player player = event.getEntity();
        ItemStack held = player.m_21120_(event.getHand());
        if (!held.m_41619_() && target instanceof AbstractChestedHorse && !(horse = (AbstractChestedHorse)target).m_30502_() && held.m_41720_() != Items.f_42009_ && held.m_204117_(Tags.Items.CHESTS_WOODEN)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_));
            if (!target.m_9236_().f_46443_) {
                ItemStack copy = held.m_41777_();
                copy.m_41764_(1);
                held.m_41774_(1);
                horse.getPersistentData().m_128365_("Quark:DonkChest", (Tag)copy.serializeNBT());
                horse.m_30504_(true);
                horse.m_30625_();
                ((AccessorAbstractChestedHorse)horse).quark$playChestEquipsSound();
            }
        }
    }

    @PlayEvent
    public void onDeath(ZLivingDeath event) {
        AbstractChestedHorse horse;
        ItemStack chest;
        Entity target = event.getEntity();
        if (target instanceof AbstractChestedHorse && !(chest = ItemStack.m_41712_((CompoundTag)(horse = (AbstractChestedHorse)target).getPersistentData().m_128469_("Quark:DonkChest"))).m_41619_() && horse.m_30502_()) {
            WAIT_TO_REPLACE_CHEST.set(chest);
        }
    }

    @PlayEvent
    public void onEntityJoinWorld(ZEntityJoinLevel event) {
        ItemEntity item;
        Entity target = event.getEntity();
        if (target instanceof ItemEntity && (item = (ItemEntity)target).m_32055_().m_41720_() == Items.f_42009_) {
            ItemStack local = WAIT_TO_REPLACE_CHEST.get();
            if (local != null && !local.m_41619_()) {
                ((ItemEntity)target).m_32045_(local);
            }
            WAIT_TO_REPLACE_CHEST.remove();
        }
    }

    static {
        WAIT_TO_REPLACE_CHEST = new ThreadLocal();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends SkyrootQuarkBlocksModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            BlockEntityRenderers.m_173590_((BlockEntityType)aqChestTEType, ctx -> new AQVariantChestRenderer(ctx, false));
            BlockEntityRenderers.m_173590_((BlockEntityType)aqTrappedChestTEType, ctx -> new AQVariantChestRenderer(ctx, true));
            for (Block b : aqRegularChests) {
                AQClient.ZETA_CLIENT.setBlockEntityWithoutLevelRenderer(b.m_5456_(), (BlockEntityWithoutLevelRenderer)new SimpleWithoutLevelRenderer(aqChestTEType, b.m_49966_()));
            }
            for (Block b : aqTrappedChests) {
                AQClient.ZETA_CLIENT.setBlockEntityWithoutLevelRenderer(b.m_5456_(), (BlockEntityWithoutLevelRenderer)new SimpleWithoutLevelRenderer(aqTrappedChestTEType, b.m_49966_()));
            }
        }
    }
}

