/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.module;

import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.item.AetherItems;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.RegistryObject;
import org.razordevs.ascended_quark.items.AQSlimeInABucketItem;
import org.razordevs.ascended_quark.items.AQSwetInABucketItem;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerInteract;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.ItemNBTHelper;

@ZetaLoadModule(category="aether")
public class ExtraSlimeAndSwetInABucketModule
extends ZetaModule {
    @Config(flag="are_swets_exited_in_the_aether", name="Are Swets Exited In The Aether", description="Disables Swets from dancing in The Aether. Note that this config only affects the client.")
    public static boolean swets_exited = true;
    @Config(flag="are_swet_buckets_enabled", name="Are Swet Buckets Enabled", description="When disabled, disables all Ascended Quark bucket items except for the Slime in a Skyroot Bucket item. Disable if you find swet buckets unbalanced.")
    public boolean swet_bucket_enabled = true;
    public static List<Pair<RegistryObject<EntityType<Swet>>, AQSwetInABucketItem>> SLIME_WITH_BUCKET_ITEM = new ArrayList<Pair<RegistryObject<EntityType<Swet>>, AQSwetInABucketItem>>();
    public static List<Pair<RegistryObject<EntityType<Swet>>, AQSwetInABucketItem>> SLIME_WITH_BUCKET_ITEM_SKYROOT = new ArrayList<Pair<RegistryObject<EntityType<Swet>>, AQSwetInABucketItem>>();
    Item slime;

    @LoadEvent
    public void register(ZRegister register) {
        new AQSwetInABucketItem("blue_swet_in_a_bucket", this, (RegistryObject<EntityType<Swet>>)AetherEntityTypes.BLUE_SWET, false);
        new AQSwetInABucketItem("blue_swet_in_a_skyroot_bucket", this, (RegistryObject<EntityType<Swet>>)AetherEntityTypes.BLUE_SWET, true);
        new AQSwetInABucketItem("golden_swet_in_a_bucket", this, (RegistryObject<EntityType<Swet>>)AetherEntityTypes.GOLDEN_SWET, false);
        new AQSwetInABucketItem("golden_swet_in_a_skyroot_bucket", this, (RegistryObject<EntityType<Swet>>)AetherEntityTypes.GOLDEN_SWET, true);
        this.slime = new AQSlimeInABucketItem("slime_in_a_skyroot_bucket", this);
    }

    @PlayEvent
    public void entityInteract(ZPlayerInteract.EntityInteract event) {
        if (event.getTarget() != null && event.getTarget().m_6084_()) {
            Player player = event.getEntity();
            ItemStack stack = player.m_21205_();
            EntityType entity = event.getTarget().m_6095_();
            Pair<AQSwetInABucketItem, InteractionHand> result = this.CheckAllBucket(player, entity);
            if (result == null && entity == EntityType.f_20526_) {
                InteractionHand hand;
                if (player.m_21205_().m_41720_() == AetherItems.SKYROOT_BUCKET.get()) {
                    hand = InteractionHand.MAIN_HAND;
                } else if (player.m_21206_().m_41720_() == AetherItems.SKYROOT_BUCKET.get()) {
                    hand = InteractionHand.OFF_HAND;
                } else {
                    return;
                }
                if (!event.getLevel().f_46443_) {
                    ItemStack outStack = new ItemStack((ItemLike)this.slime);
                    CompoundTag cmp = event.getTarget().serializeNBT();
                    ItemNBTHelper.setCompound((ItemStack)outStack, (String)"slime_nbt", (CompoundTag)cmp);
                    if (stack.m_41613_() == 1) {
                        player.m_21008_(hand, outStack);
                    } else {
                        stack.m_41774_(1);
                        if (stack.m_41613_() == 0) {
                            player.m_21008_(hand, outStack);
                        } else if (!player.m_150109_().m_36054_(outStack)) {
                            player.m_36176_(outStack, false);
                        }
                    }
                    event.getLevel().m_220400_((Entity)player, GameEvent.f_223708_, event.getTarget().m_20182_());
                    event.getTarget().m_146870_();
                } else {
                    player.m_6674_(hand);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            } else if (result != null) {
                InteractionHand hand = (InteractionHand)result.getSecond();
                if (!event.getLevel().f_46443_) {
                    ItemStack outStack = new ItemStack((ItemLike)result.getFirst());
                    CompoundTag cmp = event.getTarget().serializeNBT();
                    ItemNBTHelper.setCompound((ItemStack)outStack, (String)"slime_nbt", (CompoundTag)cmp);
                    if (stack.m_41613_() == 1) {
                        player.m_21008_(hand, outStack);
                    } else {
                        stack.m_41774_(1);
                        if (stack.m_41613_() == 0) {
                            player.m_21008_(hand, outStack);
                        } else if (!player.m_150109_().m_36054_(outStack)) {
                            player.m_36176_(outStack, false);
                        }
                    }
                    event.getLevel().m_220400_((Entity)player, GameEvent.f_223708_, event.getTarget().m_20182_());
                    event.getTarget().m_146870_();
                } else {
                    player.m_6674_(hand);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @Nullable
    public Pair<AQSwetInABucketItem, InteractionHand> CheckAllBucket(Player player, EntityType<?> swet) {
        block6: {
            InteractionHand hand;
            ItemStack stack2;
            ItemStack stack;
            block5: {
                stack = player.m_21205_();
                stack2 = player.m_21206_();
                hand = InteractionHand.MAIN_HAND;
                if (!this.swet_bucket_enabled) {
                    return null;
                }
                if (stack.m_41720_() != Items.f_42446_ && stack2.m_41720_() != Items.f_42446_) break block5;
                if (stack.m_41720_() != Items.f_42446_) {
                    hand = InteractionHand.OFF_HAND;
                }
                for (Pair<RegistryObject<EntityType<Swet>>, AQSwetInABucketItem> entry : SLIME_WITH_BUCKET_ITEM) {
                    if (((RegistryObject)entry.getFirst()).get() != swet) continue;
                    return new Pair((Object)((AQSwetInABucketItem)((Object)entry.getSecond())), (Object)hand);
                }
                break block6;
            }
            if (stack.m_41720_() != AetherItems.SKYROOT_BUCKET.get() && stack2.m_41720_() != AetherItems.SKYROOT_BUCKET.get()) break block6;
            if (stack.m_41720_() != AetherItems.SKYROOT_BUCKET.get()) {
                hand = InteractionHand.OFF_HAND;
            }
            for (Pair<RegistryObject<EntityType<Swet>>, AQSwetInABucketItem> entry : SLIME_WITH_BUCKET_ITEM_SKYROOT) {
                if (((RegistryObject)entry.getFirst()).get() != swet) continue;
                return new Pair((Object)((AQSwetInABucketItem)((Object)entry.getSecond())), (Object)hand);
            }
        }
        return null;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ExtraSlimeAndSwetInABucketModule {
        @LoadEvent
        public void clientSetup(ZClientSetup event) {
            event.enqueueWork(() -> {
                for (Pair pair : SLIME_WITH_BUCKET_ITEM_SKYROOT) {
                    if (pair.getSecond() instanceof AQSwetInABucketItem && !swets_exited) continue;
                    ItemProperties.register((Item)((Item)pair.getSecond()), (ResourceLocation)new ResourceLocation("excited"), (stack, world, e, id) -> ItemNBTHelper.getBoolean((ItemStack)stack, (String)"excited", (boolean)false) ? 1.0f : 0.0f);
                }
                if (swets_exited) {
                    for (Pair pair : SLIME_WITH_BUCKET_ITEM) {
                        ItemProperties.register((Item)((Item)pair.getSecond()), (ResourceLocation)new ResourceLocation("excited"), (stack, world, e, id) -> ItemNBTHelper.getBoolean((ItemStack)stack, (String)"excited", (boolean)false) ? 1.0f : 0.0f);
                    }
                }
                ItemProperties.register((Item)this.slime, (ResourceLocation)new ResourceLocation("excited"), (stack, world, e, id) -> ItemNBTHelper.getBoolean((ItemStack)stack, (String)"excited", (boolean)false) ? 1.0f : 0.0f);
            });
        }
    }
}

