/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.module;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherCreativeTabs;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.RegistryObject;
import org.razordevs.ascended_quark.util.RegistryUtil;
import org.violetmoon.quark.content.building.module.CompressedBlocksModule;
import org.violetmoon.zeta.block.ZetaFlammableBlock;
import org.violetmoon.zeta.block.ZetaFlammablePillarBlock;
import org.violetmoon.zeta.block.ZetaPillarBlock;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZLoadComplete;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="aether")
public class CompressedBlockModule
extends ZetaModule {
    private static final List<Block> compostable = Lists.newArrayList();

    @LoadEvent
    public void register(ZRegister register) {
        CompressedBlockModule.crate("blue_berry", MapColor.f_283743_, true, this);
        CompressedBlockModule.pillar("skyroot_stick", MapColor.f_283825_, false, () -> CompressedBlocksModule.enableStickBlock, 300, this);
    }

    @LoadEvent
    public void loadComplete(ZLoadComplete event) {
        event.enqueueWork(() -> {
            for (Block block : compostable) {
                ComposterBlock.f_51914_.put((Object)block.m_5456_(), 1.0f);
            }
        });
    }

    public static void crate(String name, MapColor color, boolean compost, ZetaModule module) {
        Block block = new ZetaFlammableBlock(name + "_crate", module, 150, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_278183_().m_60978_(1.5f).m_60918_(SoundType.f_56736_)).setCreativeTab(AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey());
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)block, (RegistryObject<? extends ItemLike>)AetherBlocks.SKYROOT_PLANKS, module);
        if (compost) {
            compostable.add(block);
        }
    }

    public static void disabledCrate(String name, MapColor color, boolean compost, ZetaModule module) {
        ZetaFlammableBlock block = new ZetaFlammableBlock(name + "_crate", module, 150, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_278183_().m_60978_(1.5f).m_60918_(SoundType.f_56736_));
        if (compost) {
            compostable.add((Block)block);
        }
    }

    private static void pillar(String name, MapColor color, boolean compost, BooleanSupplier cond, int flammability, ZetaModule module) {
        ZetaPillarBlock block = new ZetaFlammablePillarBlock(name + "_block", module, flammability, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_278183_().m_60978_(0.5f).m_60918_(SoundType.f_56736_)).setCondition(cond);
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_BUILDING_BLOCKS.getKey(), (ItemLike)block, (RegistryObject<? extends ItemLike>)AetherBlocks.SKYROOT_PLANKS, module);
        if (compost) {
            compostable.add((Block)block);
        }
    }
}

