/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.module;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.entity.monster.Cockatrice;
import com.aetherteam.aether.entity.monster.Zephyr;
import com.aetherteam.aether.entity.passive.Aerbunny;
import com.aetherteam.aether.entity.passive.Phyg;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="aether")
public class AetherVariantAnimalTexturesModule
extends ZetaModule {
    private static ListMultimap<VariantTextureType, ResourceLocation> textures;
    private static final int PHYG_COUNT = 2;
    private static final int AERBUNNY_COUNT = 2;
    private static final int ZEPHYR_COUNT = 2;
    private static final int COCKATRICE_COUNT = 1;
    @Config
    public static boolean enablePhyg;
    @Config
    public static boolean enableAerbunny;
    @Config
    public static boolean enableZephyr;
    @Config
    public static boolean enableCockatrice;
    private static boolean isEnabled;

    static {
        enablePhyg = true;
        enableAerbunny = true;
        enableZephyr = true;
        enableCockatrice = true;
    }

    public static enum VariantTextureType {
        PHYG,
        AERBUNNY,
        ZEPHYR,
        ZEPHYR_LAYER,
        COCKATRICE;

    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends AetherVariantAnimalTexturesModule {
        @LoadEvent
        public void clientSetup(ZClientSetup event) {
            if (!this.isEnabled()) {
                return;
            }
            textures = Multimaps.newListMultimap(new EnumMap(VariantTextureType.class), ArrayList::new);
            Client.registerTextures(VariantTextureType.PHYG, 2, new ResourceLocation("aether", "textures/entity/mobs/phyg/phyg.png"));
            Client.registerTextures(VariantTextureType.AERBUNNY, 2, new ResourceLocation("aether", "textures/entity/mobs/aerbunny/aerbunny.png"));
            Client.registerTextures(VariantTextureType.ZEPHYR, 2, new ResourceLocation("aether", "textures/entity/mobs/zephyr/zephyr.png"));
            Client.registerTextures(VariantTextureType.ZEPHYR_LAYER, 2, new ResourceLocation("aether", "textures/entity/mobs/zephyr/zephyr_layer.png"));
            Client.registerTextures(VariantTextureType.COCKATRICE, 1, new ResourceLocation("aether", "textures/entity/mobs/cockatrice/cockatrice.png"));
        }

        @LoadEvent
        public void configChanged(ZConfigChanged event) {
            isEnabled = this.isEnabled();
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public static ResourceLocation getPhygTexture(Phyg entity) {
            if (!isEnabled || !enablePhyg) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.PHYG);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public static ResourceLocation getAerbunnyTexture(Aerbunny entity) {
            if (!isEnabled || !enableAerbunny) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.AERBUNNY);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public static ResourceLocation getZephyrTexture(Zephyr entity) {
            if (!isEnabled || !enableZephyr) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.ZEPHYR);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public static ResourceLocation getZephyrLayerTexture(Zephyr entity) {
            if (!isEnabled || !enableZephyr) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.ZEPHYR_LAYER);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public static ResourceLocation getCockatriceTexture(Cockatrice entity) {
            if (!isEnabled || !enableCockatrice || ((Boolean)AetherConfig.CLIENT.legacy_models.get()).booleanValue()) {
                return null;
            }
            return Client.getTextureOrShiny((Entity)entity, VariantTextureType.COCKATRICE);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static ResourceLocation getTextureOrShiny(Entity e, VariantTextureType type) {
            return Client.getTextureOrShiny(e, type, () -> Client.getRandomTexture(e, type));
        }

        @OnlyIn(value=Dist.CLIENT)
        public static ResourceLocation getTextureOrShiny(Entity e, VariantTextureType type, Supplier<ResourceLocation> nonShiny) {
            return nonShiny.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        private static ResourceLocation getRandomTexture(Entity e, VariantTextureType type) {
            List styles = textures.get((Object)type);
            UUID id = e.m_20148_();
            long most = id.getMostSignificantBits();
            int choice = Math.abs((int)(most % (long)styles.size()));
            return (ResourceLocation)styles.get(choice);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void registerTextures(VariantTextureType type, int count, ResourceLocation vanilla) {
            String name = type.name().toLowerCase(Locale.ROOT);
            for (int i = 1; i < count + 1; ++i) {
                textures.put((Object)type, (Object)new ResourceLocation("ascended_quark", String.format("textures/model/entity/variants/%s%d.png", name, i)));
            }
            if (vanilla != null) {
                textures.put((Object)type, (Object)vanilla);
            }
        }
    }
}

