/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.module;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tools.client.render.entity.PickarangRenderer;
import org.violetmoon.quark.content.tools.config.PickarangType;
import org.violetmoon.quark.content.tools.entity.rang.AbstractPickarang;
import org.violetmoon.quark.content.tools.entity.rang.Flamerang;
import org.violetmoon.quark.content.tools.entity.rang.Pickarang;
import org.violetmoon.quark.content.tools.item.PickarangItem;
import org.violetmoon.quark.content.tools.module.PickarangModule;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BooleanSuppliers;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="aether")
public class AQPickarangModule
extends ZetaModule {
    @Config(flag="phoenix_flamerang")
    public static boolean enableFlamerang = true;
    @Hint
    public static Item valk_pickarang;
    @Hint(value="flamerang")
    public static Item phoenix_flamerang;
    private static final List<PickarangType<?>> knownTypes;
    private static boolean isEnabled;

    private static String loot(ResourceLocation lootLoc, int defaultWeight) {
        return lootLoc.toString() + "," + defaultWeight;
    }

    @LoadEvent
    public final void register(ZRegister event) {
        valk_pickarang = this.makePickarang(PickarangModule.pickarangType, "valkyrie_pickarang", Pickarang::new, Pickarang::new, BooleanSuppliers.TRUE).setCreativeTab(CreativeModeTabs.f_256869_, (ItemLike)Items.f_42392_, false);
        phoenix_flamerang = this.makePickarang(PickarangModule.flamerangType, "phoenix_flamerang", Flamerang::new, Flamerang::new, () -> enableFlamerang).setCreativeTab(CreativeModeTabs.f_256869_, (ItemLike)Items.f_42397_, false);
    }

    private <T extends AbstractPickarang<T>> PickarangItem makePickarang(PickarangType<T> type, String name, EntityType.EntityFactory<T> entityFactory, PickarangType.PickarangConstructor<T> thrownFactory, BooleanSupplier condition) {
        EntityType entityType = EntityType.Builder.m_20704_(entityFactory, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.4f).m_20702_(4).m_20717_(10).setCustomClientFactory((t, l) -> (AbstractPickarang)entityFactory.m_20721_(type.getEntityType(), l)).m_20712_(name);
        Quark.ZETA.registry.register((Object)entityType, name, Registries.f_256939_);
        knownTypes.add(type);
        type.setEntityType(entityType, thrownFactory);
        return (PickarangItem)new PickarangItem(name, (ZetaModule)this, this.propertiesFor(type.durability, type.isFireResistant()), type).setCondition(condition);
    }

    private Item.Properties propertiesFor(int durability, boolean fireResist) {
        Item.Properties properties = new Item.Properties().m_41487_(1);
        if (durability > 0) {
            properties.m_41503_(durability);
        }
        if (fireResist) {
            properties.m_41486_();
        }
        return properties;
    }

    public static boolean getIsFireResistant(boolean vanillaVal, Entity entity) {
        if (!isEnabled || vanillaVal) {
            return vanillaVal;
        }
        Entity riding = entity.m_20202_();
        if (riding instanceof AbstractPickarang) {
            AbstractPickarang pick = (AbstractPickarang)riding;
            return pick.getPickarangType().isFireResistant();
        }
        return false;
    }

    static {
        knownTypes = new ArrayList();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends AQPickarangModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            knownTypes.forEach(t -> EntityRenderers.m_174036_((EntityType)t.getEntityType(), PickarangRenderer::new));
        }
    }
}

