/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.items;

import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.item.AetherCreativeTabs;
import com.aetherteam.aether.item.AetherItems;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.RegistryObject;
import org.razordevs.ascended_quark.module.ExtraSlimeAndSwetInABucketModule;
import org.razordevs.ascended_quark.util.RegistryUtil;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class AQSwetInABucketItem
extends ZetaItem {
    public static final String TAG_ENTITY_DATA = "slime_nbt";
    public static final String TAG_EXCITED = "excited";
    private final RegistryObject<EntityType<Swet>> bucketEntity;

    public AQSwetInABucketItem(String name, ZetaModule module, RegistryObject<EntityType<Swet>> bucketEntity, boolean isSkyroot) {
        super(name, module, new Item.Properties().m_41487_(1));
        this.bucketEntity = bucketEntity;
        if (isSkyroot) {
            ExtraSlimeAndSwetInABucketModule.SLIME_WITH_BUCKET_ITEM_SKYROOT.add((Pair<RegistryObject<EntityType<Swet>>, AQSwetInABucketItem>)new Pair(bucketEntity, (Object)this));
        } else {
            ExtraSlimeAndSwetInABucketModule.SLIME_WITH_BUCKET_ITEM.add((Pair<RegistryObject<EntityType<Swet>>, AQSwetInABucketItem>)new Pair(bucketEntity, (Object)this));
        }
        RegistryUtil.addCreativeModeTab((ResourceKey<CreativeModeTab>)AetherCreativeTabs.AETHER_EQUIPMENT_AND_UTILITIES.getKey(), (ItemLike)this, (RegistryObject<? extends ItemLike>)AetherItems.SKYROOT_TADPOLE_BUCKET, module);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        CompoundTag cmp;
        if (stack.m_41782_() && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_ENTITY_DATA, (boolean)false)) != null && cmp.m_128441_("CustomName")) {
            MutableComponent custom = Component.Serializer.m_130701_((String)cmp.m_128461_("CustomName"));
            return Component.m_237110_((String)"item.quark.slime_in_a_bucket.named", (Object[])new Object[]{custom});
        }
        return super.m_7626_(stack);
    }

    public EntityType<Swet> getBucketEntity() {
        return (EntityType)this.bucketEntity.get();
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        Level worldIn = context.m_43725_();
        Player playerIn = context.m_43723_();
        if (playerIn == null) {
            return InteractionResult.FAIL;
        }
        InteractionHand hand = context.m_43724_();
        double x = (double)pos.m_123341_() + 0.5 + (double)facing.m_122429_();
        double y = (double)pos.m_123342_() + 0.5 + (double)facing.m_122430_();
        double z = (double)pos.m_123343_() + 0.5 + (double)facing.m_122431_();
        if (!worldIn.f_46443_) {
            Swet swet = new Swet(this.getBucketEntity(), worldIn);
            CompoundTag data = ItemNBTHelper.getCompound((ItemStack)playerIn.m_21120_(hand), (String)TAG_ENTITY_DATA, (boolean)true);
            if (data != null) {
                swet.m_20258_(data);
            } else {
                swet.m_21051_(Attributes.f_22276_).m_22100_(1.0);
                swet.m_21051_(Attributes.f_22279_).m_22100_(0.3);
                swet.m_21153_(swet.m_21233_());
            }
            swet.m_6034_(x, y, z);
            worldIn.m_220400_((Entity)playerIn, GameEvent.f_157810_, swet.m_20182_());
            worldIn.m_7967_((Entity)swet);
            playerIn.m_6674_(hand);
        }
        worldIn.m_5594_(playerIn, pos, SoundEvents.f_11778_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (!playerIn.m_150110_().f_35937_) {
            playerIn.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (world instanceof ServerLevel) {
            boolean slime = world.m_220362_() == AetherDimensions.AETHER_DIMENSION_TYPE;
            boolean excited = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_EXCITED, (boolean)false);
            if (excited != slime) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_EXCITED, (boolean)slime);
            }
        }
    }
}

