/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.handler;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.razordevs.ascended_quark.AQGeneralConfig;
import org.razordevs.ascended_quark.handler.AQButton;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.event.bus.PlayEvent;

public class AQButtonHandler {
    @PlayEvent
    public static void onGuiInit(ZScreen.Init.Post event) {
        if (!AQGeneralConfig.enableAQButton) {
            return;
        }
        Set<String> targetButtonTranslationKeys = AQButtonHandler.getTargetButtons(event.getScreen());
        if (targetButtonTranslationKeys == null || targetButtonTranslationKeys.isEmpty()) {
            return;
        }
        Set targetButtonNames = targetButtonTranslationKeys.stream().map(x$0 -> I18n.m_118938_((String)x$0, (Object[])new Object[0])).collect(Collectors.toSet());
        List listeners = event.getListenersList();
        for (GuiEventListener listener : listeners) {
            AbstractWidget widget;
            if (!(listener instanceof AbstractWidget) || !targetButtonNames.contains((widget = (AbstractWidget)listener).m_6035_().getString())) continue;
            Button aqButton = AQButtonHandler.getButton(widget);
            event.addListener((GuiEventListener)aqButton);
            return;
        }
    }

    @NotNull
    private static Button getButton(AbstractWidget widget) {
        int x = widget.m_252754_();
        x = AQGeneralConfig.aqButtonOnRight ? (QuarkGeneralConfig.qButtonOnRight && QuarkGeneralConfig.enableQButton ? (x += widget.m_5711_() + 28) : (x += widget.m_5711_() + 4)) : (QuarkGeneralConfig.qButtonOnRight || !QuarkGeneralConfig.enableQButton ? (x -= 24) : (x -= 48));
        return new AQButton(x, widget.m_252907_());
    }

    @Nullable
    private static Set<String> getTargetButtons(Screen gui) {
        if (gui instanceof TitleScreen) {
            if (AQGeneralConfig.aqButtonOnRight) {
                return Set.of("menu.online");
            }
            return Set.of("fml.menu.mods.title", "fml.menu.mods");
        }
        if (gui instanceof PauseScreen) {
            if (AQGeneralConfig.aqButtonOnRight) {
                return Set.of("menu.shareToLan", "menu.playerReporting");
            }
            return Set.of("menu.options");
        }
        return null;
    }
}

