/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.entity.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.building.client.render.be.VariantChestRenderer;
import org.violetmoon.quark.content.building.module.VariantChestsModule;

public class AQVariantChestRenderer
extends VariantChestRenderer {
    private final Map<Pair<Block, ChestType>, Material> materialMap = new HashMap<Pair<Block, ChestType>, Material>();

    public AQVariantChestRenderer(BlockEntityRendererProvider.Context context, boolean isTrap) {
        super(context, isTrap);
    }

    @Nullable
    public Material getMaterial(ChestBlockEntity tile, ChestType type) {
        Block block = tile.m_58900_().m_60734_();
        Pair pair = Pair.of((Object)block, (Object)type);
        return this.materialMap.computeIfAbsent((Pair<Block, ChestType>)pair, b -> {
            if (block instanceof VariantChestsModule.IVariantChest) {
                VariantChestsModule.IVariantChest v = (VariantChestsModule.IVariantChest)block;
                StringBuilder tex = new StringBuilder(v.getTextureFolder()).append('/').append(v.getTexturePath()).append('/');
                if (this.isTrap) {
                    tex.append((String)this.choose(type, "trap", "trap_left", "trap_right"));
                } else {
                    tex.append((String)this.choose(type, "normal", "left", "right"));
                }
                return new Material(Sheets.f_110740_, new ResourceLocation("ascended_quark", tex.toString()));
            }
            return null;
        });
    }
}

