/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.datagen.tags;

import com.aetherteam.aether.AetherTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;
import org.razordevs.ascended_quark.blocks.AQHedgeBlock;
import org.razordevs.ascended_quark.blocks.AQHollowLogBlock;
import org.razordevs.ascended_quark.blocks.AQTrappedVariantChestBlock;
import org.razordevs.ascended_quark.blocks.AQWoodenPostBlock;
import org.violetmoon.quark.content.building.block.VerticalSlabBlock;

public class AQItemTagData
extends ItemTagsProvider {
    final HashMap<String, Item> itemMap;
    final HashMap<String, Block> blockMap;
    protected static final String[] Wood = new String[]{"skyroot", "roseroot", "yagroot", "cruderoot", "sunroot", "conberry"};

    public AQItemTagData(PackOutput p_275343_, CompletableFuture<HolderLookup.Provider> p_275729_, CompletableFuture<TagsProvider.TagLookup<Block>> p_275322_, @Nullable ExistingFileHelper existingFileHelper, HashMap<String, Item> itemMap, HashMap<String, Block> blockMap) {
        super(p_275343_, p_275729_, p_275322_, "ascended_quark", existingFileHelper);
        this.itemMap = itemMap;
        this.blockMap = blockMap;
    }

    @Nonnull
    public String m_6055_() {
        return "Ascended Quark Item Tags";
    }

    protected void m_6577_(HolderLookup.Provider provider) {
        ArrayList<Item> items = new ArrayList<Item>(this.itemMap.values());
        ArrayList<Block> blocks = new ArrayList<Block>(this.blockMap.values());
        this.blockMap.values().forEach(block -> items.add(block.m_5456_()));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.m_206424_(AetherTags.Items.TREATED_AS_AETHER_ITEM);
        items.forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tag).m_255245_(arg_0));
        blocks.forEach(block -> {
            if (block instanceof SlabBlock) {
                this.m_206424_(ItemTags.f_13139_).m_255245_((Object)block.m_5456_());
            }
        });
        blocks.forEach(block -> {
            if (block instanceof StairBlock) {
                this.m_206424_(ItemTags.f_13138_).m_255245_((Object)block.m_5456_());
            }
        });
        blocks.forEach(block -> {
            if (block instanceof WallBlock) {
                this.m_206424_(ItemTags.f_13140_).m_255245_((Object)block.m_5456_());
            }
        });
        blocks.forEach(block -> {
            if (block instanceof AQWoodenPostBlock) {
                this.m_206424_(ItemTags.create((ResourceLocation)new ResourceLocation("quark", "posts"))).m_255245_((Object)block.m_5456_());
            }
        });
        this.m_206424_(ItemTags.create((ResourceLocation)new ResourceLocation("quark", "stools"))).m_255245_((Object)this.blockMap.get("skyroot_stool").m_5456_());
        blocks.forEach(block -> {
            if (block instanceof AQHedgeBlock) {
                this.m_206424_(ItemTags.create((ResourceLocation)new ResourceLocation("quark", "hedges"))).m_255245_((Object)block.m_5456_());
            }
        });
        blocks.forEach(block -> {
            if (block instanceof AQHollowLogBlock) {
                this.m_206424_(ItemTags.create((ResourceLocation)new ResourceLocation("quark", "hollow_logs"))).m_255245_((Object)block.m_5456_());
            }
        });
        blocks.forEach(block -> {
            if (block instanceof ChestBlock) {
                this.m_206424_(Tags.Items.CHESTS_WOODEN).m_255245_((Object)block.m_5456_());
                this.m_206424_(Tags.Items.CHESTS).m_255245_((Object)block.m_5456_());
                if (block instanceof AQTrappedVariantChestBlock) {
                    this.m_206424_(Tags.Items.CHESTS_TRAPPED).m_255245_((Object)block.m_5456_());
                } else {
                    this.m_206424_(ItemTags.create((ResourceLocation)new ResourceLocation("quark", "revertable_chests"))).m_255245_((Object)block.m_5456_());
                    this.m_206424_(ItemTags.create((ResourceLocation)new ResourceLocation("quark", "boatable_chests"))).m_255245_((Object)block.m_5456_());
                }
            }
        });
        blocks.forEach(block -> {
            if (block instanceof LadderBlock) {
                this.m_206424_(ItemTags.create((ResourceLocation)new ResourceLocation("quark", "ladders"))).m_255245_((Object)block.m_5456_());
            }
        });
        this.m_206424_(ItemTags.f_13161_).m_255245_((Object)this.itemMap.get("ambrosium_torch_arrow"));
        this.blockMap.keySet().forEach(s -> {
            Block patt4970$temp = this.blockMap.get(s);
            if (patt4970$temp instanceof VerticalSlabBlock) {
                VerticalSlabBlock block = (VerticalSlabBlock)patt4970$temp;
                this.m_206424_(ItemTags.create((ResourceLocation)new ResourceLocation("quark", "vertical_slabs"))).m_255245_((Object)block.m_5456_());
                for (String string : Wood) {
                    if (!s.contains(string)) continue;
                    this.m_206424_(ItemTags.create((ResourceLocation)new ResourceLocation("quark", "wooden_vertical_slabs"))).m_255245_((Object)block.m_5456_());
                    break;
                }
            }
        });
        this.blockMap.keySet().forEach(s -> {
            if (s.contains("vertical_") && s.contains("_planks")) {
                this.m_206424_(AetherTags.Items.PLANKS_CRAFTING).m_255245_((Object)this.blockMap.get(s).m_5456_());
            }
        });
        this.blockMap.keySet().forEach(s -> {
            if (s.contains("bookshelf")) {
                this.m_206424_(Tags.Items.BOOKSHELVES).m_255245_((Object)this.blockMap.get(s).m_5456_());
            }
        });
    }
}

