/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class ConditionalSingleItemBuilder
implements RecipeBuilder {
    private final List<Pair<ResourceLocation, String>> condition = new ArrayList<Pair<ResourceLocation, String>>();
    private final RecipeCategory category;
    private final Item result;
    private final Ingredient ingredient;
    private final int count;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;
    private final RecipeSerializer<?> type;

    public ConditionalSingleItemBuilder(RecipeCategory category, RecipeSerializer<?> serializer, Ingredient ingredient, ItemLike result, int count) {
        this.category = category;
        this.type = serializer;
        this.result = result.m_5456_();
        this.ingredient = ingredient;
        this.count = count;
    }

    public static ConditionalSingleItemBuilder stonecutting(Ingredient ingredient, RecipeCategory category, ItemLike result) {
        return new ConditionalSingleItemBuilder(category, RecipeSerializer.f_44095_, ingredient, result, 1);
    }

    public static ConditionalSingleItemBuilder stonecutting(Ingredient ingredient, RecipeCategory category, ItemLike result, int count) {
        return new ConditionalSingleItemBuilder(category, RecipeSerializer.f_44095_, ingredient, result, count);
    }

    public ConditionalSingleItemBuilder unlockedBy(String name, CriterionTriggerInstance triggerInstance) {
        this.advancement.m_138386_(name, triggerInstance);
        return this;
    }

    public ConditionalSingleItemBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public ConditionalSingleItemBuilder condition(ResourceLocation condition, String name) {
        this.condition.add((Pair<ResourceLocation, String>)new Pair((Object)condition, (Object)name));
        return this;
    }

    public ConditionalSingleItemBuilder condition(Pair<ResourceLocation, String> ... condition) {
        this.condition.addAll(List.of(condition));
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeConsumer, ResourceLocation location) {
        this.ensureValid(location);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)location)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)location)).m_138360_(RequirementsStrategy.f_15979_);
        recipeConsumer.accept(new Result(location, this.type, this.group == null ? "" : this.group, this.ingredient, this.result, this.count, this.advancement, location.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.condition));
    }

    private void ensureValid(ResourceLocation location) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + location);
        }
    }

    public static class Result
    implements FinishedRecipe {
        @NotNull
        private final List<Pair<ResourceLocation, String>> condition;
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final int count;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<?> type;

        public Result(ResourceLocation location, RecipeSerializer<?> serializer, String group, Ingredient ingredient, Item result, int count, Advancement.Builder advBuilder, ResourceLocation advId, List<Pair<ResourceLocation, String>> condition) {
            this.id = location;
            this.type = serializer;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.count = count;
            this.advancement = advBuilder;
            this.advancementId = advId;
            this.condition = condition;
        }

        public void m_7917_(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            jsonObject.add("ingredient", this.ingredient.m_43942_());
            jsonObject.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            jsonObject.addProperty("count", (Number)this.count);
            if (!this.condition.isEmpty()) {
                if (this.condition.size() == 1) {
                    JsonObject conditions = new JsonObject();
                    conditions.addProperty("type", ((ResourceLocation)this.condition.get(0).getA()).toString());
                    conditions.addProperty("flag", (String)this.condition.get(0).getB());
                    jsonObject.add("conditions", (JsonElement)conditions);
                } else {
                    JsonArray values = new JsonArray();
                    for (int i = 0; i < this.condition.size(); ++i) {
                        JsonObject conditions = new JsonObject();
                        conditions.addProperty("type", ((ResourceLocation)this.condition.get(i).getA()).toString());
                        conditions.addProperty("flag", (String)this.condition.get(i).getB());
                        values.add((JsonElement)conditions);
                    }
                    JsonArray array = new JsonArray();
                    JsonObject object = new JsonObject();
                    object.addProperty("type", "forge:and");
                    object.add("values", (JsonElement)values);
                    array.add((JsonElement)object);
                    jsonObject.add("conditions", (JsonElement)array);
                }
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

