/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.datagen.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import oshi.util.tuples.Pair;

public class ConditionalShapelessRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final List<Pair<ResourceLocation, String>> condition = new ArrayList<Pair<ResourceLocation, String>>();
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;

    public ConditionalShapelessRecipeBuilder(RecipeCategory category, ItemLike result, int count) {
        this.category = category;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ConditionalShapelessRecipeBuilder shapeless(RecipeCategory category, ItemLike result) {
        return new ConditionalShapelessRecipeBuilder(category, result, 1);
    }

    public static ConditionalShapelessRecipeBuilder shapeless(RecipeCategory category, ItemLike result, int count) {
        return new ConditionalShapelessRecipeBuilder(category, result, count);
    }

    public ConditionalShapelessRecipeBuilder requires(TagKey<Item> tagKey) {
        return this.requires(Ingredient.m_204132_(tagKey));
    }

    public ConditionalShapelessRecipeBuilder condition(ResourceLocation condition, String name) {
        this.condition.add((Pair<ResourceLocation, String>)new Pair((Object)condition, (Object)name));
        return this;
    }

    public ConditionalShapelessRecipeBuilder requires(ItemLike itemLike) {
        return this.requires(itemLike, 1);
    }

    public ConditionalShapelessRecipeBuilder requires(ItemLike itemLike, int count) {
        for (int i = 0; i < count; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
        }
        return this;
    }

    public ConditionalShapelessRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public ConditionalShapelessRecipeBuilder requires(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ConditionalShapelessRecipeBuilder unlockedBy(String name, CriterionTriggerInstance triggerInstance) {
        this.advancement.m_138386_(name, triggerInstance);
        return this;
    }

    public ConditionalShapelessRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeConsumer, ResourceLocation location) {
        this.ensureValid(location);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)location)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)location)).m_138360_(RequirementsStrategy.f_15979_);
        recipeConsumer.accept((FinishedRecipe)new Result(location, this.result, this.count, this.group == null ? "" : this.group, ConditionalShapelessRecipeBuilder.m_245179_((RecipeCategory)this.category), this.ingredients, this.advancement, location.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.condition));
    }

    private void ensureValid(ResourceLocation location) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + location);
        }
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final List<Pair<ResourceLocation, String>> condition;
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation location, Item result, int count, String group, CraftingBookCategory bookCategory, List<Ingredient> ingredients, Advancement.Builder advBuilder, ResourceLocation advId, List<Pair<ResourceLocation, String>> condition) {
            super(bookCategory);
            this.id = location;
            this.result = result;
            this.count = count;
            this.group = group;
            this.ingredients = ingredients;
            this.advancement = advBuilder;
            this.advancementId = advId;
            this.condition = condition;
        }

        public void m_7917_(JsonObject jsonObject) {
            super.m_7917_(jsonObject);
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            jsonObject.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonobject);
            if (!this.condition.isEmpty()) {
                if (this.condition.size() == 1) {
                    JsonObject conditions = new JsonObject();
                    conditions.addProperty("type", ((ResourceLocation)this.condition.get(0).getA()).toString());
                    conditions.addProperty("flag", (String)this.condition.get(0).getB());
                    jsonObject.add("conditions", (JsonElement)conditions);
                } else {
                    JsonArray values = new JsonArray();
                    for (Pair<ResourceLocation, String> resourceLocationStringPair : this.condition) {
                        JsonObject conditions = new JsonObject();
                        conditions.addProperty("type", ((ResourceLocation)resourceLocationStringPair.getA()).toString());
                        conditions.addProperty("flag", (String)resourceLocationStringPair.getB());
                        values.add((JsonElement)conditions);
                    }
                    JsonArray array = new JsonArray();
                    JsonObject object = new JsonObject();
                    object.addProperty("type", "forge:and");
                    object.add("values", (JsonElement)values);
                    array.add((JsonElement)object);
                    jsonObject.add("conditions", (JsonElement)array);
                }
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

