/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.datagen.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class ConditionalShapedRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final List<Pair<ResourceLocation, String>> condition = new ArrayList<Pair<ResourceLocation, String>>();
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;
    private boolean showNotification = true;

    public ConditionalShapedRecipeBuilder(RecipeCategory category, ItemLike result, int count) {
        this.category = category;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ConditionalShapedRecipeBuilder shaped(RecipeCategory category, ItemLike itemLike) {
        return ConditionalShapedRecipeBuilder.shaped(category, itemLike, 1);
    }

    public static ConditionalShapedRecipeBuilder shaped(RecipeCategory category, ItemLike itemLike, int count) {
        return new ConditionalShapedRecipeBuilder(category, itemLike, count);
    }

    public ConditionalShapedRecipeBuilder define(Character character, TagKey<Item> tagKey) {
        return this.define(character, Ingredient.m_204132_(tagKey));
    }

    public ConditionalShapedRecipeBuilder define(Character character, ItemLike itemLike) {
        return this.define(character, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
    }

    public ConditionalShapedRecipeBuilder define(Character character, Ingredient ingredient) {
        if (this.key.containsKey(character)) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(character, ingredient);
        return this;
    }

    public ConditionalShapedRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public ConditionalShapedRecipeBuilder unlockedBy(String name, CriterionTriggerInstance triggerInstance) {
        this.advancement.m_138386_(name, triggerInstance);
        return this;
    }

    public ConditionalShapedRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public ConditionalShapedRecipeBuilder showNotification(boolean b) {
        this.showNotification = b;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    private void ensureValid(ResourceLocation location) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + location + "!");
        }
        HashSet $$1 = Sets.newHashSet(this.key.keySet());
        $$1.remove(Character.valueOf(' '));
        for (String $$2 : this.rows) {
            for (int $$3 = 0; $$3 < $$2.length(); ++$$3) {
                char $$4 = $$2.charAt($$3);
                if (!this.key.containsKey(Character.valueOf($$4)) && $$4 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + location + " uses undefined symbol '" + $$4 + "'");
                }
                $$1.remove(Character.valueOf($$4));
            }
        }
        if (!$$1.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + location);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + location + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + location);
        }
    }

    public ConditionalShapedRecipeBuilder condition(ResourceLocation condition, String name) {
        this.condition.add((Pair<ResourceLocation, String>)new Pair((Object)condition, (Object)name));
        return this;
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeConsumer, ResourceLocation location) {
        this.ensureValid(location);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)location)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)location)).m_138360_(RequirementsStrategy.f_15979_);
        recipeConsumer.accept((FinishedRecipe)new Result(location, this.result, this.count, this.group == null ? "" : this.group, ConditionalShapedRecipeBuilder.m_245179_((RecipeCategory)this.category), this.rows, this.key, this.advancement, location.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.showNotification, this.condition));
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        @NotNull
        private final List<Pair<ResourceLocation, String>> condition;
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final boolean showNotification;

        public Result(ResourceLocation location, Item item, int count, String group, CraftingBookCategory bookCategory, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder builder, ResourceLocation advLocation, boolean notify, List<Pair<ResourceLocation, String>> condition) {
            super(bookCategory);
            this.condition = condition;
            this.id = location;
            this.result = item;
            this.count = count;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advancement = builder;
            this.advancementId = advLocation;
            this.showNotification = notify;
        }

        public void m_7917_(JsonObject jsonObject) {
            super.m_7917_(jsonObject);
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonArray $$1 = new JsonArray();
            for (String string : this.pattern) {
                $$1.add(string);
            }
            jsonObject.add("pattern", (JsonElement)$$1);
            JsonObject $$3 = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                $$3.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            jsonObject.add("key", (JsonElement)$$3);
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject2.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonObject2);
            jsonObject.addProperty("show_notification", Boolean.valueOf(this.showNotification));
            if (!this.condition.isEmpty()) {
                if (this.condition.size() == 1) {
                    JsonObject jsonObject3 = new JsonObject();
                    jsonObject3.addProperty("type", ((ResourceLocation)this.condition.get(0).getA()).toString());
                    jsonObject3.addProperty("flag", (String)this.condition.get(0).getB());
                    jsonObject.add("conditions", (JsonElement)jsonObject3);
                } else {
                    JsonArray jsonArray = new JsonArray();
                    for (int i = 0; i < this.condition.size(); ++i) {
                        JsonObject conditions = new JsonObject();
                        conditions.addProperty("type", ((ResourceLocation)this.condition.get(i).getA()).toString());
                        conditions.addProperty("flag", (String)this.condition.get(i).getB());
                        jsonArray.add((JsonElement)conditions);
                    }
                    JsonArray array = new JsonArray();
                    JsonObject object = new JsonObject();
                    object.addProperty("type", "forge:and");
                    object.add("values", (JsonElement)jsonArray);
                    array.add((JsonElement)object);
                    jsonObject.add("conditions", (JsonElement)array);
                }
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44076_;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

