/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.datagen;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherItems;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.razordevs.ascended_quark.datagen.recipe.ConditionalShapedRecipeBuilder;
import org.razordevs.ascended_quark.datagen.recipe.ConditionalShapelessRecipeBuilder;
import org.razordevs.ascended_quark.datagen.recipe.ConditionalSingleItemBuilder;
import oshi.util.tuples.Pair;
import teamrazor.deepaether.init.DABlocks;

public class AQRecipeData
extends RecipeProvider {
    public static final ResourceLocation DEFAULT_FLAG = new ResourceLocation("ascended_quark", "flag");
    public static final ResourceLocation QUARK_FLAG = new ResourceLocation("quark", "flag");
    private final HashMap<String, Item> itemMap;
    private final HashMap<String, Block> blockMap;
    private static final String DA_WOOD = "deep_aether_wood";

    public AQRecipeData(PackOutput output, HashMap<String, Item> itemMap, HashMap<String, Block> blockMap) {
        super(output);
        this.itemMap = itemMap;
        this.blockMap = blockMap;
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.skyrootHedge((ItemLike)this.blockMap.get("decorated_holiday_skyroot_hedge"), (ItemLike)AetherBlocks.DECORATED_HOLIDAY_LEAVES.get(), consumer);
        this.woodset("roseroot", (Block)DABlocks.ROSEROOT_PLANKS.get(), (Block)DABlocks.ROSEROOT_LOG.get(), (Block)DABlocks.ROSEROOT_WOOD.get(), (Block)DABlocks.STRIPPED_ROSEROOT_WOOD.get(), (Block)DABlocks.ROSEROOT_LEAVES.get(), (Block)DABlocks.ROSEROOT_SLAB.get(), DA_WOOD, consumer);
        this.hedge((ItemLike)this.blockMap.get("flowering_roseroot_hedge"), (ItemLike)DABlocks.FLOWERING_ROSEROOT_LEAVES.get(), (ItemLike)DABlocks.ROSEROOT_LOG.get(), DEFAULT_FLAG, DA_WOOD, consumer);
        this.hedge((ItemLike)this.blockMap.get("blue_roseroot_hedge"), (ItemLike)DABlocks.BLUE_ROSEROOT_LEAVES.get(), (ItemLike)DABlocks.ROSEROOT_LOG.get(), DEFAULT_FLAG, DA_WOOD, consumer);
        this.hedge((ItemLike)this.blockMap.get("flowering_blue_roseroot_hedge"), (ItemLike)DABlocks.FLOWERING_BLUE_ROSEROOT_LEAVES.get(), (ItemLike)DABlocks.ROSEROOT_LOG.get(), DEFAULT_FLAG, DA_WOOD, consumer);
        this.carpet((ItemLike)this.blockMap.get("flowering_roseroot_leaf_carpet"), (ItemLike)DABlocks.FLOWERING_ROSEROOT_LEAVES.get(), DA_WOOD, consumer);
        this.carpet((ItemLike)this.blockMap.get("blue_roseroot_leaf_carpet"), (ItemLike)DABlocks.BLUE_ROSEROOT_LEAVES.get(), DA_WOOD, consumer);
        this.carpet((ItemLike)this.blockMap.get("flowering_blue_roseroot_leaf_carpet"), (ItemLike)DABlocks.FLOWERING_BLUE_ROSEROOT_LEAVES.get(), DA_WOOD, consumer);
        this.woodset("cruderoot", (Block)DABlocks.CRUDEROOT_PLANKS.get(), (Block)DABlocks.CRUDEROOT_LOG.get(), (Block)DABlocks.CRUDEROOT_WOOD.get(), (Block)DABlocks.STRIPPED_CRUDEROOT_WOOD.get(), (Block)DABlocks.CRUDEROOT_LEAVES.get(), (Block)DABlocks.CRUDEROOT_SLAB.get(), DA_WOOD, consumer);
        this.woodset("sunroot", (Block)DABlocks.SUNROOT_PLANKS.get(), (Block)DABlocks.SUNROOT_LOG.get(), (Block)DABlocks.SUNROOT_WOOD.get(), (Block)DABlocks.STRIPPED_SUNROOT_WOOD.get(), (Block)DABlocks.SUNROOT_LEAVES.get(), (Block)DABlocks.SUNROOT_SLAB.get(), DA_WOOD, consumer);
        this.woodset("yagroot", (Block)DABlocks.YAGROOT_PLANKS.get(), (Block)DABlocks.YAGROOT_LOG.get(), (Block)DABlocks.YAGROOT_WOOD.get(), (Block)DABlocks.STRIPPED_YAGROOT_WOOD.get(), (Block)DABlocks.YAGROOT_LEAVES.get(), (Block)DABlocks.YAGROOT_SLAB.get(), DA_WOOD, consumer);
        this.woodset("conberry", (Block)DABlocks.CONBERRY_PLANKS.get(), (Block)DABlocks.CONBERRY_LOG.get(), (Block)DABlocks.CONBERRY_WOOD.get(), (Block)DABlocks.STRIPPED_CONBERRY_WOOD.get(), (Block)DABlocks.CONBERRY_LEAVES.get(), (Block)DABlocks.CONBERRY_SLAB.get(), DA_WOOD, consumer);
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.blockMap.get("aether_mud_pillar")).define(Character.valueOf('A'), (ItemLike)DABlocks.AETHER_MUD_BRICKS_SLAB.get()).pattern("A").pattern("A").condition(QUARK_FLAG, "more_mud_blocks").condition(DEFAULT_FLAG, "more_aether_mud_blocks").unlockedBy(AQRecipeData.m_176602_((ItemLike)((ItemLike)DABlocks.AETHER_MUD_BRICKS_SLAB.get())), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)((ItemLike)DABlocks.AETHER_MUD_BRICKS_SLAB.get()))).m_176498_(consumer);
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.blockMap.get("aether_mud_brick_lattice"), 4).define(Character.valueOf('A'), (ItemLike)DABlocks.AETHER_MUD_BRICKS.get()).pattern(" A ").pattern("A A").pattern(" A ").condition(QUARK_FLAG, "more_mud_blocks").condition(DEFAULT_FLAG, "more_aether_mud_blocks").unlockedBy(AQRecipeData.m_176602_((ItemLike)((ItemLike)DABlocks.AETHER_MUD_BRICKS.get())), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)((ItemLike)DABlocks.AETHER_MUD_BRICKS.get()))).m_176498_(consumer);
        this.stonecuttingRecipe((ItemLike)this.blockMap.get("aether_mud_pillar"), (ItemLike)DABlocks.AETHER_MUD_BRICKS.get(), consumer, new Pair((Object)QUARK_FLAG, (Object)"more_mud_blocks"), new Pair((Object)DEFAULT_FLAG, (Object)"more_aether_mud_blocks"));
    }

    private void woodset(String type, Block planks, Block log, Block wood, Block strippedWood, Block leaves, Block slab, String flag, Consumer<FinishedRecipe> consumer) {
        this.verticalPlanks((ItemLike)this.blockMap.get("vertical_" + type + "_planks"), (ItemLike)planks, flag, consumer);
        this.hedge((ItemLike)this.blockMap.get(type + "_hedge"), (ItemLike)leaves, (ItemLike)log, DEFAULT_FLAG, flag, consumer);
        this.verticalSlab(this.blockMap.get(type + "_vertical_slab"), slab, flag, consumer);
        this.carpet((ItemLike)this.blockMap.get(type + "_leaf_carpet"), (ItemLike)leaves, flag, consumer);
        this.post((ItemLike)this.blockMap.get(type + "_post"), (ItemLike)wood, flag, consumer);
        this.post((ItemLike)this.blockMap.get("stripped_" + type + "_post"), (ItemLike)strippedWood, flag, consumer);
        this.chest((ItemLike)this.blockMap.get(type + "_chest"), (ItemLike)planks, flag, consumer);
        this.chest((ItemLike)this.blockMap.get(type + "_trapped_chest"), (ItemLike)planks, flag, consumer);
        this.hollowLog((ItemLike)this.blockMap.get("hollow_" + type + "_log"), (ItemLike)log, flag, consumer);
        this.ladder((ItemLike)this.blockMap.get(type + "_ladder"), (ItemLike)planks, flag, consumer);
        this.bookshelf(this.blockMap.get(type + "_bookshelf"), planks, flag, consumer);
    }

    private void bookshelf(Block bookshelf, Block planks, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)bookshelf, 1).define(Character.valueOf('A'), (ItemLike)planks).define(Character.valueOf('B'), (ItemLike)Items.f_42517_).pattern("AAA").pattern("BBB").pattern("AAA").condition(new ResourceLocation("quark", "flag"), "variant_bookshelves").condition(DEFAULT_FLAG, flag).unlockedBy(AQRecipeData.m_176602_((ItemLike)planks), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)planks)).m_176498_(consumer);
    }

    void slab(Block slab, Block texture, Consumer<FinishedRecipe> consumer) {
        AQRecipeData.m_247552_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{texture})).m_126132_(AQRecipeData.m_176602_((ItemLike)texture), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)texture)).m_176498_(consumer);
    }

    void verticalSlab(Block vertical, Block slab, String flag, Consumer<FinishedRecipe> consumer) {
        AQRecipeData.verticalSlabBuilder((ItemLike)vertical, Ingredient.m_43929_((ItemLike[])new ItemLike[]{slab}), flag).m_126132_(AQRecipeData.m_176602_((ItemLike)slab), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)slab)).m_176498_(consumer);
        this.verticalSlabRevert(vertical, slab, consumer, flag);
    }

    protected static RecipeBuilder verticalSlabBuilder(ItemLike itemLike, Ingredient ingredient, String flag) {
        return ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, itemLike, 3).define(Character.valueOf('#'), ingredient).pattern("#").pattern("#").pattern("#").condition(new ResourceLocation("quark", "flag"), "vertical_slabs").condition(DEFAULT_FLAG, flag);
    }

    void carpet(ItemLike carpet, ItemLike leaf, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, carpet, 3).define(Character.valueOf('A'), leaf).pattern("AA").condition(new ResourceLocation("quark", "flag"), "leaf_carpet").condition(DEFAULT_FLAG, flag).unlockedBy(AQRecipeData.m_176602_((ItemLike)leaf), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)leaf)).m_176498_(consumer);
    }

    void post(ItemLike post, ItemLike wood, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, post, 8).define(Character.valueOf('A'), wood).pattern("A").pattern("A").pattern("A").condition(new ResourceLocation("quark", "flag"), "wooden_posts").condition(DEFAULT_FLAG, flag).unlockedBy(AQRecipeData.m_176602_((ItemLike)wood), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)wood)).m_176498_(consumer);
    }

    void verticalPlanks(ItemLike verticalPlanks, ItemLike planks, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, verticalPlanks, 3).define(Character.valueOf('A'), planks).pattern("A").pattern("A").pattern("A").condition(new ResourceLocation("quark", "flag"), "vertical_planks").condition(DEFAULT_FLAG, flag).unlockedBy(AQRecipeData.m_176602_((ItemLike)planks), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)planks)).m_176498_(consumer);
        ConditionalShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, planks).condition(new ResourceLocation("quark", "flag"), "vertical_slabs").condition(DEFAULT_FLAG, flag).requires(verticalPlanks).unlockedBy(AQRecipeData.m_176602_((ItemLike)planks), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)planks)).m_176500_(consumer, AQRecipeData.m_176632_((ItemLike)verticalPlanks) + "_from_" + AQRecipeData.m_176632_((ItemLike)planks));
    }

    void chest(ItemLike chest, ItemLike planks, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, chest).define(Character.valueOf('A'), planks).pattern("AAA").pattern("A A").pattern("AAA").condition(new ResourceLocation("quark", "flag"), "variant_chests").condition(DEFAULT_FLAG, flag).unlockedBy(AQRecipeData.m_176602_((ItemLike)planks), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)planks)).m_176498_(consumer);
    }

    void hollowLog(ItemLike hollowLog, ItemLike log, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, hollowLog, 4).define(Character.valueOf('A'), log).pattern(" A ").pattern("A A").pattern(" A ").condition(new ResourceLocation("quark", "flag"), "hollow_logs").condition(DEFAULT_FLAG, flag).unlockedBy(AQRecipeData.m_176602_((ItemLike)log), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)log)).m_176498_(consumer);
    }

    void ladder(ItemLike ladder, ItemLike planks, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, ladder, 4).define(Character.valueOf('A'), planks).define(Character.valueOf('-'), (ItemLike)AetherItems.SKYROOT_STICK.get()).pattern("- -").pattern("-A-").pattern("- -").condition(new ResourceLocation("quark", "flag"), "variant_ladders").condition(DEFAULT_FLAG, flag).unlockedBy(AQRecipeData.m_176602_((ItemLike)planks), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)planks)).m_176498_(consumer);
    }

    void verticalSlabRevert(Block slab, Block reverted, Consumer<FinishedRecipe> consumer, String flag) {
        AQRecipeData.verticalSlabRevertBuilder((ItemLike)reverted, Ingredient.m_43929_((ItemLike[])new ItemLike[]{slab}), flag).m_126132_(AQRecipeData.m_176602_((ItemLike)slab), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)slab)).m_176500_(consumer, AQRecipeData.m_176632_((ItemLike)reverted) + "_from_" + AQRecipeData.m_176632_((ItemLike)slab));
    }

    void hedge(ItemLike hedge, ItemLike leaves, TagKey<Item> stem, ResourceLocation conditionLocation, String conditionName, Consumer<FinishedRecipe> consumer) {
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, hedge, 2).define(Character.valueOf('A'), stem).define(Character.valueOf('B'), leaves).pattern("B").pattern("A").unlockedBy(AQRecipeData.m_176602_((ItemLike)leaves), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)leaves)).condition(new ResourceLocation("quark", "flag"), "hedges").condition(conditionLocation, conditionName).m_176498_(consumer);
    }

    void hedge(ItemLike hedge, ItemLike leaves, ItemLike stem, ResourceLocation conditionLocation, String conditionName, Consumer<FinishedRecipe> consumer) {
        ConditionalShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, hedge, 2).define(Character.valueOf('A'), stem).define(Character.valueOf('B'), leaves).pattern("B").pattern("A").condition(new ResourceLocation("quark", "flag"), "hedges").condition(conditionLocation, conditionName).unlockedBy(AQRecipeData.m_176602_((ItemLike)leaves), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)leaves)).m_176498_(consumer);
    }

    void skyrootHedge(ItemLike hedge, ItemLike leaves, Consumer<FinishedRecipe> consumer) {
        this.hedge(hedge, leaves, (TagKey<Item>)AetherTags.Items.SKYROOT_LOGS, DEFAULT_FLAG, "skyroot_quark_blocks", consumer);
    }

    protected static RecipeBuilder verticalSlabRevertBuilder(ItemLike itemLike, Ingredient ingredient, String flag) {
        return ConditionalShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, itemLike).condition(new ResourceLocation("quark", "flag"), "vertical_slabs").condition(DEFAULT_FLAG, flag).requires(ingredient);
    }

    void slabRevert(Block slab, Block reverted, Consumer<FinishedRecipe> consumer) {
        AQRecipeData.slabRevertBuilder((ItemLike)reverted, Ingredient.m_43929_((ItemLike[])new ItemLike[]{slab})).m_126132_(AQRecipeData.m_176602_((ItemLike)slab), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)slab)).m_176500_(consumer, AQRecipeData.m_176632_((ItemLike)reverted) + "_from_" + AQRecipeData.m_176632_((ItemLike)slab));
    }

    protected static RecipeBuilder slabRevertBuilder(ItemLike itemLike, Ingredient ingredient) {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike).m_126124_(Character.valueOf('A'), ingredient).m_126130_("AA");
    }

    void stairs(Block stairs, Block texture, Consumer<FinishedRecipe> consumer) {
        AQRecipeData.m_176710_((ItemLike)stairs, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{texture})).m_126132_(AQRecipeData.m_176602_((ItemLike)texture), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)texture)).m_176498_(consumer);
    }

    void wall(Block wall, Block texture, Consumer<FinishedRecipe> consumer) {
        AQRecipeData.m_245864_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{texture})).m_126132_(AQRecipeData.m_176602_((ItemLike)texture), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)texture)).m_176498_(consumer);
    }

    protected ResourceLocation name(String name) {
        return new ResourceLocation("ascended_quark", name);
    }

    protected void stonecuttingRecipe(ItemLike item, ItemLike ingredient, Consumer<FinishedRecipe> consumer, Pair<ResourceLocation, String> ... condition) {
        this.stonecuttingRecipe(item, ingredient, 1, consumer, condition);
    }

    protected void stonecuttingRecipe(ItemLike item, ItemLike ingredient, int count, Consumer<FinishedRecipe> consumer, Pair<ResourceLocation, String>[] condition) {
        ConditionalSingleItemBuilder.stonecutting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), RecipeCategory.BUILDING_BLOCKS, item, count).condition(condition).unlockedBy(AQRecipeData.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)AQRecipeData.m_125977_((ItemLike)ingredient)).m_126140_(consumer, this.name(AQRecipeData.m_176517_((ItemLike)item, (ItemLike)ingredient) + "_stonecutting"));
    }
}

