/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.datagen;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.razordevs.ascended_quark.blocks.AQHedgeBlock;
import org.razordevs.ascended_quark.items.AQSlimeInABucketItem;
import org.razordevs.ascended_quark.items.AQSwetInABucketItem;

public class AQItemModelData
extends ItemModelProvider {
    final HashMap<String, Item> itemMap;
    final HashMap<String, Block> blockMap;

    public AQItemModelData(PackOutput output, ExistingFileHelper helper, HashMap<String, Item> itemMap, HashMap<String, Block> blockMap) {
        super(output, "ascended_quark", helper);
        this.itemMap = itemMap;
        this.blockMap = blockMap;
    }

    protected void registerModels() {
        ArrayList<Item> toGenerateBlockItem = new ArrayList<Item>();
        toGenerateBlockItem.addAll(this.itemMap.values());
        ArrayList<Block> toGenerateBlock = new ArrayList<Block>();
        toGenerateBlock.addAll(this.blockMap.values());
        for (Item item : toGenerateBlockItem) {
            if (item instanceof AQSlimeInABucketItem || item instanceof AQSwetInABucketItem) continue;
            System.out.println(item);
            if (item instanceof TieredItem) {
                this.handheldItem(item);
                continue;
            }
            this.item(item);
        }
        toGenerateBlock.remove(this.blockMap.get("ambrosium_lamp"));
        this.itemBlock(this.blockMap.get("ambrosium_lamp"), new ResourceLocation("ascended_quark", "block/ambrosium_lamp_0"));
        toGenerateBlock.remove(this.blockMap.get("quicksoil_framed_glass_pane"));
        this.itemBlockFlatName(this.blockMap.get("quicksoil_framed_glass_pane"), "quicksoil_framed_glass");
        for (Block block : toGenerateBlock) {
            if (block instanceof AQHedgeBlock) {
                this.itemBlock(block, new ResourceLocation("ascended_quark", "block/" + this.blockName(block) + "_post"));
                continue;
            }
            if (block instanceof WallBlock) {
                this.itemBlock(block, new ResourceLocation("ascended_quark", "block/" + this.blockName(block) + "_inventory"));
                continue;
            }
            if (block instanceof ChestBlock) {
                this.itemChest(block);
                continue;
            }
            if (block instanceof LadderBlock) {
                this.itemBlockFlat(block);
                continue;
            }
            this.itemBlock(block);
        }
    }

    public void handheldItem(Item item) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + this.itemName(item)));
    }

    public void itemBlock(Block block) {
        this.withExistingParent(this.blockName(block), this.texture(this.blockName(block)));
    }

    public void itemBlock(Block block, ResourceLocation location) {
        this.withExistingParent(this.blockName(block), location);
    }

    public void itemChest(Block block) {
        this.withExistingParent(this.blockName(block), this.mcLoc("item/" + this.blockName(Blocks.f_50087_)));
    }

    public void item(Item item) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + this.itemName(item)));
    }

    public void itemFence(Block block, Block baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/fence_inventory"))).texture("texture", this.texture(this.blockName(baseBlock)));
    }

    public void itemBlockFlatName(Block block, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(location));
    }

    public void itemButton(Block block, Block baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/button_inventory"))).texture("texture", this.texture(this.blockName(baseBlock)));
    }

    public void eggItem(Item item) {
        this.withExistingParent(this.itemName(item), this.mcLoc("item/template_spawn_egg"));
    }

    public void itemWallBlock(Block block, Block baseBlock) {
        this.wallInventory(this.blockName(block), this.texture(this.blockName(baseBlock)));
    }

    public void itemBlockFlat(Block block) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(block)));
    }

    public String blockName(Block block) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (location != null) {
            return location.m_135815_();
        }
        throw new IllegalStateException("Unknown block: " + block.toString());
    }

    public String itemName(Item item) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)item);
        if (location != null) {
            return location.m_135815_();
        }
        throw new IllegalStateException("Unknown item: " + item.toString());
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }
}

