/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.datagen;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.providers.AetherBlockStateProvider;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.razordevs.ascended_quark.AscendedQuark;
import org.razordevs.ascended_quark.blocks.AQWoodenPostBlock;
import org.violetmoon.quark.content.building.block.HedgeBlock;
import org.violetmoon.quark.content.building.block.VerticalSlabBlock;
import teamrazor.deepaether.init.DABlocks;

public class AQBlockstateData
extends AetherBlockStateProvider {
    final HashMap<String, Block> blockMap;

    public AQBlockstateData(PackOutput output, ExistingFileHelper helper, HashMap<String, Block> blockMap) {
        super(output, "ascended_quark", helper);
        this.blockMap = blockMap;
    }

    public void registerStatesAndModels() {
        this.woodset("roseroot", (Block)DABlocks.ROSEROOT_LOG.get(), (Block)DABlocks.STRIPPED_ROSEROOT_LOG.get(), (Block)DABlocks.ROSEROOT_PLANKS.get(), (Block)DABlocks.ROSEROOT_LEAVES.get());
        this.leafCarpet("blue_roseroot", (Block)DABlocks.BLUE_ROSEROOT_LEAVES.get());
        this.leafCarpet("flowering_blue_roseroot", (Block)DABlocks.FLOWERING_BLUE_ROSEROOT_LEAVES.get());
        this.leafCarpet("flowering_roseroot", (Block)DABlocks.FLOWERING_ROSEROOT_LEAVES.get());
        this.hedge("blue_roseroot", (Block)DABlocks.BLUE_ROSEROOT_LEAVES.get(), (Block)DABlocks.ROSEROOT_LOG.get());
        this.hedge("flowering_blue_roseroot", (Block)DABlocks.FLOWERING_BLUE_ROSEROOT_LEAVES.get(), (Block)DABlocks.ROSEROOT_LOG.get());
        this.hedge("flowering_roseroot", (Block)DABlocks.FLOWERING_ROSEROOT_LEAVES.get(), (Block)DABlocks.ROSEROOT_LOG.get());
        this.woodset("cruderoot", (Block)DABlocks.CRUDEROOT_LOG.get(), (Block)DABlocks.STRIPPED_CRUDEROOT_LOG.get(), (Block)DABlocks.CRUDEROOT_PLANKS.get(), (Block)DABlocks.CRUDEROOT_LEAVES.get());
        this.woodset("sunroot", (Block)DABlocks.SUNROOT_LOG.get(), (Block)DABlocks.STRIPPED_SUNROOT_LOG.get(), (Block)DABlocks.SUNROOT_PLANKS.get(), (Block)DABlocks.SUNROOT_LEAVES.get());
        this.woodset("yagroot", (Block)DABlocks.YAGROOT_LOG.get(), (Block)DABlocks.STRIPPED_YAGROOT_LOG.get(), (Block)DABlocks.YAGROOT_PLANKS.get(), (Block)DABlocks.YAGROOT_LEAVES.get());
        this.woodset("conberry", (Block)DABlocks.CONBERRY_LOG.get(), (Block)DABlocks.STRIPPED_CONBERRY_LOG.get(), (Block)DABlocks.CONBERRY_PLANKS.get(), (Block)DABlocks.CONBERRY_LEAVES.get());
        this.verticalPLank("skyroot", (Block)AetherBlocks.SKYROOT_PLANKS.get(), "construction/");
        this.pillar((RotatedPillarBlock)this.blockMap.get("skyroot_stick_block"));
        this.compressed("blue_berry_crate");
        this.compressed("goldenleaf_berries_crate");
        this.hollowLog("skyroot", (Block)AetherBlocks.SKYROOT_LOG.get(), (Block)AetherBlocks.STRIPPED_SKYROOT_LOG.get(), "natural/");
        this.post("skyroot", (Block)AetherBlocks.SKYROOT_LOG.get(), "natural/");
        this.strippedPost("skyroot", (Block)AetherBlocks.STRIPPED_SKYROOT_LOG.get(), "natural/");
        this.ladder("skyroot");
        this.hedge("skyroot", (Block)AetherBlocks.SKYROOT_LEAVES.get(), (Block)AetherBlocks.SKYROOT_LOG.get(), "natural/");
        this.hedge("golden_skyroot", (Block)AetherBlocks.GOLDEN_OAK_LEAVES.get(), (Block)AetherBlocks.SKYROOT_LOG.get(), "natural/");
        this.hedge("holiday_skyroot", (Block)AetherBlocks.HOLIDAY_LEAVES.get(), (Block)AetherBlocks.SKYROOT_LOG.get(), "natural/");
        this.hedge("decorated_holiday_skyroot", (Block)AetherBlocks.DECORATED_HOLIDAY_LEAVES.get(), (Block)AetherBlocks.SKYROOT_LOG.get(), "natural/");
        this.hedge("crystal_skyroot", (Block)AetherBlocks.CRYSTAL_LEAVES.get(), (Block)AetherBlocks.SKYROOT_LOG.get(), "natural/");
        this.hedge("crystal_fruit_skyroot", (Block)AetherBlocks.CRYSTAL_FRUIT_LEAVES.get(), (Block)AetherBlocks.SKYROOT_LOG.get(), "natural/");
        this.chest("skyroot", (Block)AetherBlocks.SKYROOT_PLANKS.get(), "construction/");
        this.leafCarpet("skyroot", (Block)AetherBlocks.SKYROOT_LEAVES.get(), "natural/");
        this.leafCarpet("crystal", (Block)AetherBlocks.CRYSTAL_LEAVES.get(), "natural/");
        this.leafCarpet("crystal_fruit", (Block)AetherBlocks.CRYSTAL_FRUIT_LEAVES.get(), "natural/");
        this.leafCarpet("holiday", (Block)AetherBlocks.HOLIDAY_LEAVES.get(), "natural/");
        this.leafCarpet("decorated_holiday", (Block)AetherBlocks.DECORATED_HOLIDAY_LEAVES.get(), "natural/");
        this.leafCarpet("golden_oak", (Block)AetherBlocks.GOLDEN_OAK_LEAVES.get(), "natural/");
        this.verticalSlab("skyroot", (Block)AetherBlocks.SKYROOT_PLANKS.get(), "construction/");
        this.verticalSlab("aerogel", (Block)AetherBlocks.AEROGEL.get(), "construction/");
        this.verticalSlab("holystone_brick", (Block)AetherBlocks.HOLYSTONE_BRICKS.get(), "construction/");
        this.verticalSlab("mossy_holystone", (Block)AetherBlocks.MOSSY_HOLYSTONE.get(), "natural/");
        this.verticalSlab("holystone", (Block)AetherBlocks.HOLYSTONE.get(), "natural/");
        this.verticalSlab("icestone", (Block)AetherBlocks.ICESTONE.get(), "natural/");
        this.verticalSlab("angelic", (Block)AetherBlocks.ANGELIC_STONE.get(), "dungeon/");
        this.verticalSlab("hellfire", (Block)AetherBlocks.HELLFIRE_STONE.get(), "dungeon/");
        this.verticalSlab("mossy_holystone_tile", (Block)DABlocks.MOSSY_HOLYSTONE_TILES.get());
        this.verticalSlab("holystone_tile", (Block)DABlocks.HOLYSTONE_TILES.get());
        this.verticalSlab("big_holystone_bricks", (Block)DABlocks.BIG_HOLYSTONE_BRICKS.get());
        this.verticalSlab("aseterite", (Block)DABlocks.ASETERITE.get());
        this.verticalSlab("polished_aseterite", (Block)DABlocks.POLISHED_ASETERITE.get());
        this.verticalSlab("aseterite_bricks", (Block)DABlocks.ASETERITE_BRICKS.get());
        this.verticalSlab("raw_clorite", (Block)DABlocks.RAW_CLORITE.get());
        this.verticalSlab("clorite", (Block)DABlocks.CLORITE.get());
        this.verticalSlab("polished_clorite", (Block)DABlocks.POLISHED_CLORITE.get());
        this.verticalSlab("aether_mud_bricks", (Block)DABlocks.AETHER_MUD_BRICKS.get());
        this.stoneSet("aether_dirt_bricks");
        this.stoneSet("icestone_bricks");
        this.stoneSet("polished_icestone");
        this.stoneSet("quicksoil_bricks");
        this.blockCutout("aether_mud_brick_lattice");
        this.pillar((RotatedPillarBlock)this.blockMap.get("aether_mud_pillar"));
    }

    public void woodset(String type, Block log, Block stripped, Block planks, Block leaves) {
        this.verticalPLank(type, planks);
        this.leafCarpet(type, leaves);
        this.verticalSlab(type, planks);
        this.hedge(type, leaves, log);
        this.post(type, log);
        this.strippedPost(type, stripped);
        this.ladder(type);
        this.hollowLog(type, log, stripped, "");
        this.bookshelf(type, planks);
        this.chest(type, planks);
    }

    public void stoneSet(String type) {
        Block base = this.blockMap.get(type);
        this.block(base);
        this.slab(this.blockMap.get(type + "_slab"), base);
        this.stairs(this.blockMap.get(type + "_stairs"), base);
        this.wallBlock(this.blockMap.get(type + "_wall"), base);
        this.verticalSlab(type);
    }

    public void ladder(String type) {
        Block block = this.blockMap.get(type + "_ladder");
        ResourceLocation location = this.texture(this.name(block));
        ModelBuilder ladder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/block"))).renderType(new ResourceLocation("cutout"))).ao(false)).texture("particle", location)).texture("texture", location)).element().from(0.0f, 0.0f, 15.2f).to(16.0f, 16.0f, 15.2f).shade(false).face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#texture").end().face(Direction.SOUTH).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#texture").end().end();
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AQBlockstateData.lambda$ladder$0((ModelFile)ladder, arg_0), new Property[]{LadderBlock.f_54338_});
    }

    public void chest(String type, Block planks, String location) {
        Block block = this.blockMap.get(type + "_chest");
        Block trapped = this.blockMap.get(type + "_trapped_chest");
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(this.chest(this.name(block), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)planks), location)))});
        this.getVariantBuilder(trapped).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(this.chest(this.name(trapped), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)planks), location)))});
    }

    public void chest(String type, Block planks) {
        Block block = this.blockMap.get(type + "_chest");
        Block trapped = this.blockMap.get(type + "_trapped_chest");
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(this.chest(this.name(block), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)planks))))});
        this.getVariantBuilder(trapped).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(this.chest(this.name(trapped), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)planks))))});
    }

    public ModelFile chest(String name, ResourceLocation particle) {
        return ((BlockModelBuilder)this.models().getBuilder(name)).texture("particle", particle);
    }

    public void pillar(RotatedPillarBlock block) {
        this.axisBlock(block, this.extend(this.texture(this.name((Block)block)), "_side"), this.extend(this.texture(this.name((Block)block)), "_top"));
    }

    public void strippedPost(String type, Block log) {
        this.post("stripped_" + type, log);
    }

    public void strippedPost(String type, Block log, String location) {
        this.post("stripped_" + type, log, location);
    }

    public void post(String type, Block log) {
        Block block = this.blockMap.get(type + "_post");
        this.postBlock(block, this.postModel(this.name(block), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)log))));
    }

    public void post(String type, Block log, String location) {
        Block block = this.blockMap.get(type + "_post");
        this.postBlock(block, this.postModel(this.name(block), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)log), location)));
    }

    public ModelFile postModel(String name, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("quark", "block/post"))).texture("texture", texture);
    }

    public void postBlock(Block block, ModelFile post) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ModelFile.ExistingModelFile small = this.models().getExistingFile(new ResourceLocation("ascended_quark", "block/chain_small"));
        ModelFile.ExistingModelFile small_up = this.models().getExistingFile(new ResourceLocation("ascended_quark", "block/chain_small_top"));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).addModel()).condition(AQWoodenPostBlock.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Y});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).rotationY(90).rotationX(90).addModel()).condition(AQWoodenPostBlock.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).rotationX(90).addModel()).condition(AQWoodenPostBlock.AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)small).addModel()).condition((Property)AQWoodenPostBlock.CHAINED[0], (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)small_up).addModel()).condition((Property)AQWoodenPostBlock.CHAINED[1], (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)small_up).rotationX(90).addModel()).condition((Property)AQWoodenPostBlock.CHAINED[2], (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)small).rotationX(90).addModel()).condition((Property)AQWoodenPostBlock.CHAINED[3], (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)small).rotationX(90).rotationY(90).addModel()).condition((Property)AQWoodenPostBlock.CHAINED[4], (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)small_up).rotationX(90).rotationY(90).addModel()).condition((Property)AQWoodenPostBlock.CHAINED[5], (Comparable[])new Boolean[]{true});
    }

    public void hedge(String type, Block leaf, Block log) {
        this.hedgeBlock(this.blockMap.get(type + "_hedge"), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)leaf)), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)log)));
    }

    public void hedge(String type, Block leaf, Block log, String location) {
        this.hedgeBlock(this.blockMap.get(type + "_hedge"), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)leaf), location), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)log), location));
    }

    public void hedgeBlock(Block block, ResourceLocation leaf, ResourceLocation log) {
        String baseName = this.key(block).toString();
        this.fourWayBlockExtended(block, this.hedgePost(baseName + "_post", leaf, log), this.hedgeSide(baseName + "_side", leaf), this.hedgeExtend(baseName + "_extend", leaf));
    }

    public ModelFile hedgePost(String name, ResourceLocation leaves, ResourceLocation log) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("quark", "block/hedge_post"))).texture("log", log)).texture("leaf", leaves)).renderType("cutout");
    }

    public ModelFile hedgeSide(String name, ResourceLocation leaves) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("quark", "block/hedge_side"))).texture("leaf", leaves)).renderType("cutout");
    }

    public ModelFile hedgeExtend(String name, ResourceLocation leaves) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("quark", "block/hedge_extend"))).texture("leaf", leaves)).renderType("cutout");
    }

    public void fourWayBlockExtended(Block block, ModelFile post, ModelFile side, ModelFile extend) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).addModel()).condition((Property)HedgeBlock.EXTEND, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(extend).addModel()).condition((Property)HedgeBlock.EXTEND, (Comparable[])new Boolean[]{false});
        PipeBlock.f_55154_.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.m_122434_().m_122479_()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
            }
        });
    }

    public ModelFile cubeAllTranslucent(Block block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.texture(this.name(block)))).renderType(new ResourceLocation("translucent"));
    }

    public void blockCutout(String name) {
        Block block = this.blockMap.get(name);
        this.simpleBlock(block, this.cubeAllTranslucent(block));
    }

    public ModelFile cubeAllCutout(Block block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.texture(this.name(block)))).renderType(new ResourceLocation("cutout"));
    }

    public void hollowLog(String type, Block log) {
        Block block = this.blockMap.get("hollow_" + type + "_log");
        this.hollowLog((RotatedPillarBlock)block, this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)log)), this.extend(this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)log)), "_top"), this.extendPrefix(this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)log)), "stripped_"));
    }

    public void hollowLog(String type, Block log, Block stripped, String prefix) {
        Block block = this.blockMap.get("hollow_" + type + "_log");
        this.hollowLog((RotatedPillarBlock)block, this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)log), prefix), this.extend(this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)log), prefix), "_top"), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)stripped), prefix));
    }

    public void hollowLog(RotatedPillarBlock block, ResourceLocation side, ResourceLocation end, ResourceLocation inside) {
        this.axisBlock(block, this.hollowCubeColumn(this.name((Block)block), side, end, inside), this.cubeColumnHorizontal(this.name((Block)block) + "_horizontal", side, end, inside));
    }

    public ModelFile hollowCubeColumn(String name, ResourceLocation side, ResourceLocation end, ResourceLocation inside) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("quark", "block/hollow_log"))).texture("side", side)).texture("end", end)).texture("inside", inside)).renderType(new ResourceLocation("translucent"));
    }

    public ModelFile cubeColumnHorizontal(String name, ResourceLocation side, ResourceLocation end, ResourceLocation inside) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("quark", "block/hollow_log_horizontal"))).texture("side", side)).texture("end", end)).texture("inside", inside)).renderType(new ResourceLocation("translucent"));
    }

    public void compressed(String type) {
        Block block = this.blockMap.get(type);
        ModelFile compressed = this.cubeBottomTop(this.name(block), this.texture(this.name(block)), AscendedQuark.asResource("block/crate_bottom"), this.extend(this.texture(this.name(block)), "_top"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(compressed)});
    }

    public void bookshelf(String type, Block planks) {
        Block block = this.blockMap.get(type + "_bookshelf");
        ModelFile bookshelf = this.cubeBottomTop(this.name(block), this.texture(this.name(block)), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)planks)), this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)planks)));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(bookshelf)});
    }

    public ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public ResourceLocation texture(ResourceLocation name) {
        return new ResourceLocation(name.m_135827_(), "block/" + name.m_135815_());
    }

    public ResourceLocation texture(ResourceLocation name, String location) {
        return new ResourceLocation(name.m_135827_(), "block/" + location + name.m_135815_());
    }

    public ModelFile cubeBottomTop(String block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return this.models().cubeBottomTop(block, side, bottom, top);
    }

    public void fenceGateBlockInternal(FenceGateBlock block, String baseName, ResourceLocation texture) {
        ModelBuilder gate = this.models().fenceGate(baseName, texture);
        ModelBuilder gateOpen = this.models().fenceGateOpen(baseName + "_open", texture);
        ModelBuilder gateWall = this.models().fenceGateWall(baseName + "_wall", texture);
        ModelBuilder gateWallOpen = this.models().fenceGateWallOpen(baseName + "_wall_open", texture);
        this.fenceGateBlock(block, (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    public void wood(RotatedPillarBlock block, RotatedPillarBlock baseBlock) {
        this.axisBlock(block, this.texture(this.name((Block)baseBlock)), this.texture(this.name((Block)baseBlock)));
    }

    public void block(Block block) {
        this.simpleBlock(block, this.cubeAll(block));
    }

    public void verticalSlab(String type, Block texture) {
        Block block = this.blockMap.get(type + "_vertical_slab");
        this.verticalSlabBlock(block, this.verticalSlab(type + "_vertical_slab", this.blockTexture(texture)), (ModelFile)this.models().getExistingFile(this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)texture))));
    }

    public void verticalSlab(String type) {
        this.verticalSlab(type, type);
    }

    public void verticalSlab(String type, String texture) {
        Block block = this.blockMap.get(type + "_vertical_slab");
        this.verticalSlabBlock(block, this.verticalSlab(type + "_vertical_slab", this.texture(texture)), (ModelFile)this.models().getExistingFile(this.texture(texture)));
    }

    public void verticalSlab(String type, Block texture, String suffix) {
        Block block = this.blockMap.get(type + "_vertical_slab");
        this.verticalSlabBlock(block, this.verticalSlab(type + "_vertical_slab", this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)texture), suffix)), (ModelFile)this.models().getExistingFile(this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)texture))));
    }

    public void verticalSlabBlock(Block block, ModelFile halfSlab, ModelFile fullSlab) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.NORTH).modelForState().modelFile(halfSlab).rotationY(0).uvLock(true).addModel()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.SOUTH).modelForState().modelFile(halfSlab).rotationY(180).uvLock(true).addModel()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.EAST).modelForState().modelFile(halfSlab).rotationY(90).uvLock(true).addModel()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.WEST).modelForState().modelFile(halfSlab).rotationY(270).uvLock(true).addModel()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE).modelForState().modelFile(fullSlab).addModel();
    }

    public void verticalPLank(String type, Block texture) {
        Block block = this.blockMap.get("vertical_" + type + "_planks");
        this.simpleBlock(block, this.verticalPLank("vertical_" + type + "_planks", this.blockTexture(texture)));
    }

    public void verticalPLank(String type, Block texture, String suffix) {
        Block block = this.blockMap.get("vertical_" + type + "_planks");
        this.simpleBlock(block, this.verticalPLank("vertical_" + type + "_planks", this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)texture), suffix)));
    }

    public ModelFile verticalPLank(String name, ResourceLocation texture) {
        return this.models().singleTexture(name, new ResourceLocation("quark", "block/vertical_planks"), "all", texture);
    }

    public void leafCarpet(String type, Block texture) {
        Block block = this.blockMap.get(type + "_leaf_carpet");
        this.simpleBlock(block, this.leafCarpet(type + "_leaf_carpet", this.blockTexture(texture)));
    }

    public void leafCarpet(String type, Block texture, String suffix) {
        Block block = this.blockMap.get(type + "_leaf_carpet");
        this.simpleBlock(block, this.leafCarpet(type + "_leaf_carpet", this.texture(BuiltInRegistries.f_256975_.m_7981_((Object)texture), suffix)));
    }

    public ModelFile leafCarpet(String name, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().singleTexture(name, new ResourceLocation("quark", "block/leaf_carpet"), "all", texture)).renderType("cutout");
    }

    public ModelFile verticalSlab(String name, ResourceLocation texture) {
        return this.sideBottomTop(name, new ResourceLocation("quark", "block/vertical_slab"), texture);
    }

    public ModelFile sideBottomTop(String name, ResourceLocation parent, ResourceLocation location) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture("side", location)).texture("bottom", location)).texture("top", location);
    }

    public void pottedPlant(Block block, Block flower) {
        ModelBuilder pot = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/flower_pot_cross"))).texture("plant", this.modLoc("block/" + this.name(flower)))).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pot)});
    }

    public void pottedPlantFix(Block block, Block flower) {
        ModelBuilder pot = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/flower_pot_cross"))).texture("plant", this.modLoc("block/" + this.name(flower) + "_pot"))).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pot)});
    }

    public void saplingBlock(Block block) {
        ModelBuilder sapling = ((BlockModelBuilder)this.models().cross(this.name(block), this.texture(this.name(block)))).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AQBlockstateData.lambda$saplingBlock$2((ModelFile)sapling, arg_0), new Property[]{SaplingBlock.f_55973_});
    }

    public void stairs(Block block, Block baseBlock) {
        this.stairsBlock((StairBlock)block, this.texture(this.name(baseBlock)));
    }

    public void slab(Block block, Block baseBlock) {
        this.slabBlock((SlabBlock)block, this.texture(this.name(baseBlock)), this.texture(this.name(baseBlock)));
    }

    public void verticalSlabBlock(Block block, Block baseBlock) {
        this.verticalSlabBlock((VerticalSlabBlock)block, this.texture(this.name(baseBlock)), this.texture(this.name(baseBlock)));
    }

    public void verticalSlabBlock(VerticalSlabBlock block, ResourceLocation doubleslab, ResourceLocation texture) {
        this.verticalSlabBlock(block, doubleslab, texture, texture, texture);
    }

    public void verticalSlabBlock(VerticalSlabBlock block, ResourceLocation doubleslab, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        ModelBuilder vertical_slab = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), new ResourceLocation("quark", "block/vertical_slab"))).texture("bottom", bottom)).texture("top", top)).texture("side", side);
        this.getVariantBuilder((Block)block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)vertical_slab)});
    }

    public void wallBlock(Block block, Block baseBlock) {
        this.wallBlockInventory(this.name(block) + "_inventory", this.texture(this.name(baseBlock)));
        this.wallBlockInternal((WallBlock)block, this.name(block), this.texture(this.name(baseBlock)));
    }

    public void wallBlockInventory(String name, ResourceLocation texture) {
        ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/wall_inventory"))).texture("wall", texture);
    }

    public void blockDoubleDrops(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cubeAll(block)).build(), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void wallBlockInternal(WallBlock block, String baseName, ResourceLocation texture) {
        this.wallBlock(block, (ModelFile)this.models().wallPost(baseName + "_post", texture), (ModelFile)this.models().wallSide(baseName + "_side", texture), (ModelFile)this.models().wallSideTall(baseName + "_side_tall", texture));
    }

    protected BlockModelBuilder makeWallPostModel(int width, int height, String name) {
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/block"))).element().from((float)(8 - width), 0.0f, (float)(8 - width)).to((float)(8 + width), (float)height, (float)(8 + width)).face(Direction.DOWN).texture("#top").cullface(Direction.DOWN).end().face(Direction.UP).texture("#top").cullface(Direction.UP).end().face(Direction.NORTH).texture("#side").end().face(Direction.SOUTH).texture("#side").end().face(Direction.WEST).texture("#side").end().face(Direction.EAST).texture("#side").end().end();
    }

    protected BlockModelBuilder makeWallSideModel(int length, int height, String name, ModelBuilder.FaceRotation faceRotation, int u1, int u2) {
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/block"))).element().from(5.0f, 0.0f, 0.0f).to(11.0f, (float)height, (float)length).face(Direction.DOWN).texture("#top").rotation(faceRotation).uvs((float)u1, 5.0f, (float)u2, 11.0f).cullface(Direction.DOWN).end().face(Direction.UP).texture("#top").rotation(faceRotation).uvs((float)u1, 5.0f, (float)u2, 11.0f).end().face(Direction.NORTH).texture("#side").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#side").end().face(Direction.WEST).texture("#side").end().face(Direction.EAST).texture("#side").end().end();
    }

    public void logWallBlock(WallBlock block, Block baseBlock, String location, String modid, boolean postUsesTop, ModelFile postBig, ModelFile postShort, ModelFile postTall, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt, ModelFile sideShort, ModelFile sideAltShort, ModelFile sideTallShort, ModelFile sideTallAltShort) {
        this.logWallBlockInternal(block, this.name((Block)block), new ResourceLocation(modid, "block/" + location + this.name(baseBlock)), postUsesTop, postBig, postShort, postTall, side, sideAlt, sideTall, sideTallAlt, sideShort, sideAltShort, sideTallShort, sideTallAltShort);
    }

    private void logWallBlockInternal(WallBlock block, String baseName, ResourceLocation texture, boolean postUsesTop, ModelFile postBig, ModelFile postShort, ModelFile postTall, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt, ModelFile sideShort, ModelFile sideAltShort, ModelFile sideTallShort, ModelFile sideTallAltShort) {
        this.logWallBlock(this.getMultipartBuilder((Block)block), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_post_short")).parent(postShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_post_tall")).parent(postTall)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side")).parent(side)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_alt")).parent(sideAlt)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_tall")).parent(sideTall)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_tall_alt")).parent(sideTallAlt)).texture("particle", texture)).texture("top", texture)).texture("side", texture));
        this.logWallBlockWithPost(this.getMultipartBuilder((Block)block), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_post")).parent(postBig)).texture("particle", texture)).texture("top", (String)(postUsesTop ? texture + "_top" : texture.toString()))).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_short")).parent(sideShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_alt_short")).parent(sideAltShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_tall_short")).parent(sideTallShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_tall_alt_short")).parent(sideTallAltShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture));
    }

    public void logWallBlock(MultiPartBlockStateBuilder builder, ModelFile postShort, ModelFile postTall, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(postShort).addModel()).nestedGroup().condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{false}).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.LOW}).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.LOW}).end().end().part().modelFile(postTall).addModel()).nestedGroup().condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{false}).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.TALL}).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.TALL}).end().end().part().modelFile(postShort).rotationY(90).addModel()).nestedGroup().condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{false}).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.NONE}).condition((Property)WallBlock.f_57951_, (Comparable[])new WallSide[]{WallSide.LOW}).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.NONE}).condition((Property)WallBlock.f_57952_, (Comparable[])new WallSide[]{WallSide.LOW}).end().end().part().modelFile(postTall).rotationY(90).addModel()).nestedGroup().condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{false}).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.NONE}).condition((Property)WallBlock.f_57951_, (Comparable[])new WallSide[]{WallSide.TALL}).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.NONE}).condition((Property)WallBlock.f_57952_, (Comparable[])new WallSide[]{WallSide.TALL}).end().end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).m_122434_().m_122479_()).forEach(e -> {
            this.logWallSidePart(builder, side, sideAlt, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.LOW, false);
            this.logWallSidePart(builder, sideTall, sideTallAlt, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.TALL, false);
        });
    }

    public void logWallBlockWithPost(MultiPartBlockStateBuilder builder, ModelFile postBig, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(postBig).addModel()).condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{true}).end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).m_122434_().m_122479_()).forEach(e -> {
            this.logWallSidePart(builder, side, sideAlt, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.LOW, true);
            this.logWallSidePart(builder, sideTall, sideTallAlt, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.TALL, true);
        });
    }

    private void logWallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, ModelFile modelAlt, Map.Entry<Direction, Property<WallSide>> entry, WallSide height, boolean hasPost) {
        int rotation = ((int)entry.getKey().m_122435_() + 180) % 360;
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(rotation < 180 ? model : modelAlt).rotationY(rotation).addModel()).condition(entry.getValue(), (Comparable[])new WallSide[]{height}).condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{hasPost});
    }

    public String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public ResourceLocation extendPrefix(ResourceLocation location, String prefix) {
        return new ResourceLocation(location.m_135827_(), prefix + location.m_135815_());
    }

    private static /* synthetic */ ConfiguredModel[] lambda$saplingBlock$2(ModelFile sapling, BlockState state) {
        return ConfiguredModel.builder().modelFile(sapling).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$ladder$0(ModelFile ladder, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)LadderBlock.f_54337_);
        return ConfiguredModel.builder().modelFile(ladder).rotationY((int)(direction.m_122435_() + 180.0f) % 360).build();
    }
}

